/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.runtime;

import com.jformdesigner.runtime.AlignmentUtil;
import java.util.StringTokenizer;

public class GridBagSpec {
    public static final int CENTER = 0;
    public static final int TOP = 1;
    public static final int LEFT = 2;
    public static final int BOTTOM = 3;
    public static final int RIGHT = 4;
    public static final int FILL = 5;
    public static final int BASELINE = 6;
    public static final int ABOVE_BASELINE = 7;
    public static final int BELOW_BASELINE = 8;
    private static final int DEFAULT_ALIGN = 5;
    private int defaultAlignment;
    private int minimumSize;
    private double resizeWeight;

    public GridBagSpec() {
        this(5, 0, 0.0);
    }

    public GridBagSpec(int n2, int n3, double d2) {
        this.defaultAlignment = n2;
        this.minimumSize = n3;
        this.resizeWeight = d2;
    }

    public GridBagSpec(String string) {
        this();
        int n2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (!stringTokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException(string);
        }
        int n3 = stringTokenizer.countTokens();
        String string2 = stringTokenizer.nextToken();
        if (n3 >= 2 && (n2 = AlignmentUtil.toValue(string2)) >= 0) {
            this.defaultAlignment = n2;
            string2 = stringTokenizer.nextToken();
        }
        this.minimumSize = Integer.parseInt(string2);
        if (stringTokenizer.hasMoreTokens()) {
            this.resizeWeight = Double.parseDouble(stringTokenizer.nextToken());
        }
    }

    public int getDefaultAlignment() {
        return this.defaultAlignment;
    }

    public int getMinimumSize() {
        return this.minimumSize;
    }

    public double getResizeWeight() {
        return this.resizeWeight;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.defaultAlignment != 5) {
            stringBuffer.append(AlignmentUtil.toName(this.defaultAlignment));
            stringBuffer.append(':');
        }
        stringBuffer.append(this.minimumSize);
        if (this.resizeWeight != 0.0) {
            stringBuffer.append(':');
            stringBuffer.append(this.resizeWeight);
        }
        return stringBuffer.toString();
    }

    public static String toString(int n2) {
        return AlignmentUtil.toName(n2);
    }

    public static GridBagSpec[] decodeSpecs(String string) {
        if (string == null) {
            return new GridBagSpec[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        GridBagSpec[] gridBagSpecArray = new GridBagSpec[stringTokenizer.countTokens()];
        for (int i2 = 0; i2 < gridBagSpecArray.length; ++i2) {
            gridBagSpecArray[i2] = new GridBagSpec(stringTokenizer.nextToken());
        }
        return gridBagSpecArray;
    }

    public static String encodeSpecs(GridBagSpec[] gridBagSpecArray) {
        StringBuffer stringBuffer = new StringBuffer(gridBagSpecArray.length * 9);
        for (int i2 = 0; i2 < gridBagSpecArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(gridBagSpecArray[i2].toString());
        }
        return stringBuffer.toString();
    }
}

