/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.runtime;

import com.jformdesigner.model.FormLayoutConstraints;
import com.jformdesigner.model.FormLayoutManager;
import com.jformdesigner.runtime.AbstractLayoutCreator;
import com.jformdesigner.runtime.ComponentProvider;
import com.jformdesigner.runtime.FormCreator;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jdesktop.layout.GroupLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupLayoutCreator
extends AbstractLayoutCreator {
    private static final int PADDING_SEPARATE = 1234;
    private static final int PADDING_SEPARATE_VALUE = 18;

    @Override
    public LayoutManager createLayoutManager(Container container, FormLayoutManager formLayoutManager) {
        boolean bl2 = formLayoutManager.getPropertyBoolean("autocreateContainerGaps", false);
        boolean bl3 = formLayoutManager.getPropertyBoolean("autocreateGaps", false);
        boolean bl4 = formLayoutManager.getPropertyBoolean("honorsVisibility", true);
        GroupLayout groupLayout = new GroupLayout(container);
        groupLayout.setAutocreateContainerGaps(bl2);
        groupLayout.setAutocreateGaps(bl3);
        groupLayout.setHonorsVisibility(bl4);
        return groupLayout;
    }

    @Override
    public void addComponentToContainer(Container container, Component component, Object object, int n2, FormLayoutConstraints formLayoutConstraints) {
    }

    @Override
    public void finishLayoutInitialization(Container container, FormLayoutManager formLayoutManager) {
        String string = formLayoutManager.getPropertyString("$horizontalGroup", "");
        String string2 = formLayoutManager.getPropertyString("$verticalGroup", "");
        FormCreator formCreator = this.getFormCreator();
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        HashMap<String, ArrayList<String>> hashMap2 = new HashMap<String, ArrayList<String>>();
        GroupLayout groupLayout = (GroupLayout)container.getLayout();
        groupLayout.setHorizontalGroup(GroupLayoutCreator.composeHorizontalGroup(groupLayout, string, formCreator, hashMap));
        groupLayout.setVerticalGroup(GroupLayoutCreator.composeVerticalGroup(groupLayout, string2, formCreator, hashMap2));
        GroupLayoutCreator.composeLinks(groupLayout, hashMap, 1, formCreator);
        GroupLayoutCreator.composeLinks(groupLayout, hashMap2, 2, formCreator);
    }

    public static GroupLayout.Group composeHorizontalGroup(GroupLayout groupLayout, String string, ComponentProvider componentProvider, Map<String, ArrayList<String>> map) {
        return GroupLayoutCreator.composeGroups(groupLayout, string, componentProvider, true, map);
    }

    public static GroupLayout.Group composeVerticalGroup(GroupLayout groupLayout, String string, ComponentProvider componentProvider, Map<String, ArrayList<String>> map) {
        return GroupLayoutCreator.composeGroups(groupLayout, string, componentProvider, false, map);
    }

    private static GroupLayout.Group composeGroups(GroupLayout groupLayout, String string, ComponentProvider componentProvider, boolean bl2, Map<String, ArrayList<String>> map) {
        GroupLayout.Group group = null;
        String[] stringArray = GroupLayoutCreator.toTokens(string, ';');
        for (int i2 = stringArray.length - 1; i2 >= 0; --i2) {
            GroupLayout.Group group2 = GroupLayoutCreator.composeGroup(groupLayout, null, stringArray[i2], componentProvider, bl2, true, true, map);
            if (group == null) {
                group = group2;
                continue;
            }
            if (!(group instanceof GroupLayout.ParallelGroup)) {
                GroupLayout.ParallelGroup parallelGroup = groupLayout.createParallelGroup();
                parallelGroup.add(group);
                group = parallelGroup;
            }
            ((GroupLayout.ParallelGroup)group).add(group2);
        }
        return group;
    }

    private static GroupLayout.Group composeGroup(GroupLayout groupLayout, GroupLayout.Group group, String string, ComponentProvider componentProvider, boolean bl2, boolean bl3, boolean bl4, Map<String, ArrayList<String>> map) {
        GroupLayout.SequentialGroup sequentialGroup = null;
        String[] stringArray = GroupLayoutCreator.toTokens(string, ' ');
        if (stringArray.length == 0) {
            return groupLayout.createSequentialGroup();
        }
        String string2 = stringArray[0];
        boolean bl5 = "par".equals(string2);
        boolean bl6 = "seq".equals(string2);
        if (bl5 || bl6) {
            Object object;
            int n2;
            int n3 = 1;
            int n4 = 1;
            boolean bl7 = true;
            int n5 = 1;
            if (n5 < stringArray.length && !stringArray[n5].startsWith("{") && (n2 = 0) < ((String[])(object = GroupLayoutCreator.toTokens(stringArray[n5++], ':'))).length) {
                if (bl5) {
                    n3 = GroupLayoutCreator.decodeAlignment((String)object[n2++]);
                }
                if (n2 < ((Object)object).length) {
                    n4 = GroupLayoutCreator.decodeAlignment((String)object[n2++]);
                    if (++n2 < ((Object)object).length) {
                        bl7 = GroupLayoutCreator.decodeSize((String)object[n2++]) != -2;
                    }
                }
            }
            GroupLayout.Group group2 = sequentialGroup = bl5 ? groupLayout.createParallelGroup(n3, bl7) : groupLayout.createSequentialGroup();
            if (n5 < stringArray.length) {
                object = stringArray[n5++];
                assert (((String)object).startsWith("{"));
                assert (((String)object).endsWith("}"));
                String[] stringArray2 = GroupLayoutCreator.toTokens(((String)object).substring(1, ((String)object).length() - 1), ',');
                for (int i2 = 0; i2 < stringArray2.length; ++i2) {
                    boolean bl8 = bl4 && (!bl6 || i2 == stringArray2.length - 1);
                    GroupLayoutCreator.composeGroup(groupLayout, sequentialGroup, stringArray2[i2].trim(), componentProvider, bl2, bl3, bl8, map);
                    if (!bl3 || !bl6) continue;
                    bl3 = false;
                }
            }
            if (group != null) {
                if (group instanceof GroupLayout.SequentialGroup) {
                    ((GroupLayout.SequentialGroup)group).add(sequentialGroup);
                } else {
                    ((GroupLayout.ParallelGroup)group).add(n4, sequentialGroup);
                }
            }
        } else {
            String string3 = null;
            int n6 = 1;
            int n7 = 0;
            int n8 = -1;
            int n9 = -1;
            int n10 = -1;
            String[] stringArray3 = stringArray.length > 1 ? GroupLayoutCreator.toTokens(stringArray[1], ':') : null;
            int n11 = 0;
            if ("comp".equals(string2)) {
                string3 = stringArray3[n11++];
                if (n11 < stringArray3.length) {
                    String string4;
                    if ((string4 = stringArray3[n11++]) != null) {
                        ArrayList<String> arrayList = map.get(string4);
                        if (arrayList == null) {
                            arrayList = new ArrayList();
                            map.put(string4, arrayList);
                        }
                        arrayList.add(string3);
                    }
                    if (n11 < stringArray3.length) {
                        n6 = GroupLayoutCreator.decodeAlignment(stringArray3[n11++]);
                    }
                }
            } else if ("space".equals(string2)) {
                if (n11 < stringArray3.length) {
                    n7 = GroupLayoutCreator.decodePaddingType(stringArray3[n11++]);
                }
            } else {
                throw new IllegalArgumentException();
            }
            boolean bl9 = false;
            boolean bl10 = false;
            if (n11 < stringArray3.length) {
                bl9 = stringArray3[n11] != null;
                n8 = GroupLayoutCreator.decodeSize(stringArray3[n11++]);
                if (n11 < stringArray3.length) {
                    bl10 = stringArray3[n11] != null;
                    n9 = GroupLayoutCreator.decodeSize(stringArray3[n11++]);
                    if (n11 < stringArray3.length) {
                        n10 = GroupLayoutCreator.decodeSize(stringArray3[n11++]);
                    }
                    if (n9 != -1 && n9 < 0) {
                        n9 = -1;
                    }
                }
            }
            if (group == null) {
                group = groupLayout.createSequentialGroup();
                sequentialGroup = group;
            }
            if (string3 != null) {
                Component component = componentProvider.getComponent(string3);
                if (!bl9) {
                    if (bl2 && component.getClass().getName().equals("javax.swing.JComboBox")) {
                        n8 = 0;
                    } else if (n9 >= 0) {
                        int n12;
                        Dimension dimension = component.getMinimumSize();
                        int n13 = n12 = bl2 ? dimension.width : dimension.height;
                        if (n12 > n9) {
                            n8 = -2;
                        }
                    }
                }
                if (group instanceof GroupLayout.SequentialGroup) {
                    ((GroupLayout.SequentialGroup)group).add(component, n8, n9, n10);
                } else {
                    ((GroupLayout.ParallelGroup)group).add(n6, component, n8, n9, n10);
                }
            } else if (!bl9 || !bl10) {
                GroupLayout.SequentialGroup sequentialGroup2 = (GroupLayout.SequentialGroup)group;
                if (bl3 || bl4) {
                    sequentialGroup2.addContainerGap(n9, n10);
                } else if (n7 == 0 || n7 == 1) {
                    sequentialGroup2.addPreferredGap(n7, n9, n10);
                } else if (n7 == 1234) {
                    if (n9 == -1) {
                        n9 = 18;
                    }
                    if (n10 == -1) {
                        n10 = 18;
                    }
                    sequentialGroup2.add(18, n9, n10);
                }
            } else {
                if (n8 < 0) {
                    n8 = n9;
                }
                n8 = Math.min(n8, n9);
                n10 = Math.max(n10, n9);
                if (group instanceof GroupLayout.SequentialGroup) {
                    ((GroupLayout.SequentialGroup)group).add(n8, n9, n10);
                } else {
                    ((GroupLayout.ParallelGroup)group).add(n8, n9, n10);
                }
            }
        }
        return sequentialGroup;
    }

    private static int decodeAlignment(String string) {
        if (string == null) {
            return 1;
        }
        if (string.length() == 1) {
            switch (string.charAt(0)) {
                case 'l': {
                    return 1;
                }
                case 't': {
                    return 2;
                }
                case 'c': {
                    return 4;
                }
                case 'b': {
                    return 3;
                }
            }
        }
        return 1;
    }

    private static int decodeSize(String string) {
        if (string == null) {
            return -1;
        }
        if (string.length() == 1) {
            switch (string.charAt(0)) {
                case 'd': {
                    return -1;
                }
                case 'p': {
                    return -2;
                }
                case 'x': {
                    return Short.MAX_VALUE;
                }
            }
        }
        return Integer.parseInt(string);
    }

    private static int decodePaddingType(String string) {
        if (string == null) {
            return 0;
        }
        if (string.length() == 1) {
            switch (string.charAt(0)) {
                case 'u': {
                    return 1;
                }
                case 's': {
                    return 1234;
                }
                case 'i': {
                    return 3;
                }
            }
        }
        return 0;
    }

    private static void composeLinks(GroupLayout groupLayout, Map<String, ArrayList<String>> map, int n2, ComponentProvider componentProvider) {
        if (map.isEmpty()) {
            return;
        }
        for (ArrayList<String> arrayList : map.values()) {
            Component[] componentArray = new Component[arrayList.size()];
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                componentArray[i2] = componentProvider.getComponent(arrayList.get(i2));
            }
            groupLayout.linkSize(componentArray, n2);
        }
    }

    public static String[] toTokens(String string, char c2) {
        int n2;
        int n3;
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        int n4 = 1;
        int n5 = 0;
        int n6 = string.length();
        for (n3 = 0; n3 < n6; ++n3) {
            n2 = string.charAt(n3);
            if (n2 == c2 && n5 == 0) {
                ++n4;
                continue;
            }
            if (n2 == 123) {
                ++n5;
                continue;
            }
            if (n2 != 125) continue;
            --n5;
        }
        if (n4 == 1) {
            return new String[]{string};
        }
        n3 = 0;
        n2 = 0;
        String[] stringArray = new String[n4];
        for (int i2 = 0; i2 < n6; ++i2) {
            char c3 = string.charAt(i2);
            if (c3 == c2 && n5 == 0) {
                if (i2 > n2) {
                    stringArray[n3] = string.substring(n2, i2);
                }
                ++n3;
                n2 = i2 + 1;
                continue;
            }
            if (c3 == '{') {
                ++n5;
                continue;
            }
            if (c3 != '}') continue;
            --n5;
        }
        if (n2 < n6) {
            stringArray[n3] = string.substring(n2);
        }
        return stringArray;
    }
}

