/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.runtime;

import com.jformdesigner.runtime.BeanInfoEx;
import com.jformdesigner.runtime.IntrospectorEx$Hook;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntrospectorEx {
    private static IntrospectorEx$Hook hook;
    private static Map<Class<?>, BeanInfoEx> beanInfoCache;

    public static IntrospectorEx$Hook getHook() {
        return hook;
    }

    public static void setHook(IntrospectorEx$Hook introspectorEx$Hook) {
        hook = introspectorEx$Hook;
    }

    public static void useHardRefCache() {
        beanInfoCache = Collections.synchronizedMap(new HashMap(100));
    }

    public static BeanInfoEx getBeanInfoEx(Class<?> clazz) {
        BeanInfoEx beanInfoEx = beanInfoCache.get(clazz);
        if (beanInfoEx == null) {
            BeanInfo beanInfo = hook != null ? hook.getBeanInfo(clazz) : Introspector.getBeanInfo(clazz);
            beanInfoEx = new BeanInfoEx(beanInfo);
            beanInfoCache.put(clazz, beanInfoEx);
        }
        return beanInfoEx;
    }

    public static void flushCaches() {
        beanInfoCache.clear();
        if (hook != null) {
            hook.flushCaches();
        } else {
            Introspector.flushCaches();
        }
    }

    public static void flushFromCaches(Class<?> clazz) {
        beanInfoCache.remove(clazz);
        if (hook != null) {
            hook.flushFromCaches(clazz);
        } else {
            Introspector.flushFromCaches(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushCaches(ClassLoader classLoader) {
        Map<Class<?>, BeanInfoEx> map = beanInfoCache;
        synchronized (map) {
            Iterator<Class<?>> iterator = beanInfoCache.keySet().iterator();
            while (iterator.hasNext()) {
                Class<?> clazz = iterator.next();
                if (clazz.getClassLoader() != classLoader) continue;
                iterator.remove();
                do {
                    if (hook != null) {
                        hook.flushFromCaches(clazz);
                        continue;
                    }
                    Introspector.flushFromCaches(clazz);
                } while ((clazz = clazz.getSuperclass()) != null && clazz.getClassLoader() == classLoader);
            }
        }
        if (hook != null) {
            hook.flushCaches(classLoader);
        }
    }

    static {
        beanInfoCache = Collections.synchronizedMap(new WeakHashMap(100));
    }
}

