/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.runtime;

import com.jformdesigner.runtime.NullConstraints;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;

public class NullLayout
implements LayoutManager2 {
    private boolean autoSize = true;
    private final HashMap<Component, NullConstraints> consMap = new HashMap();

    public NullLayout() {
    }

    public NullLayout(boolean bl2) {
        this.autoSize = bl2;
    }

    public boolean isAutoSize() {
        return this.autoSize;
    }

    public void setAutoSize(boolean bl2) {
        this.autoSize = bl2;
    }

    public NullConstraints getConstraints(Component component) {
        return this.consMap.get(component);
    }

    public void addLayoutComponent(String string, Component component) {
        throw new IllegalArgumentException();
    }

    public void addLayoutComponent(Component component, Object object) {
        if (!(object instanceof NullConstraints)) {
            throw new IllegalArgumentException();
        }
        this.consMap.put(component, (NullConstraints)object);
    }

    public void removeLayoutComponent(Component component) {
        this.consMap.remove(component);
    }

    public Dimension preferredLayoutSize(Container container) {
        if (!this.autoSize) {
            return new Dimension(0, 0);
        }
        Dimension dimension = new Dimension();
        for (Map.Entry<Component, NullConstraints> entry : this.consMap.entrySet()) {
            Component component = entry.getKey();
            NullConstraints nullConstraints = entry.getValue();
            Rectangle rectangle = this.componentBounds(component, nullConstraints);
            dimension.width = Math.max(rectangle.x + rectangle.width, dimension.width);
            dimension.height = Math.max(rectangle.y + rectangle.height, dimension.height);
        }
        Insets insets = container.getInsets();
        dimension.width += insets.right;
        dimension.height += insets.bottom;
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public void layoutContainer(Container container) {
        for (Map.Entry<Component, NullConstraints> entry : this.consMap.entrySet()) {
            Component component = entry.getKey();
            NullConstraints nullConstraints = entry.getValue();
            component.setBounds(this.componentBounds(component, nullConstraints));
        }
    }

    public void invalidateLayout(Container container) {
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    private Rectangle componentBounds(Component component, NullConstraints nullConstraints) {
        Rectangle rectangle = new Rectangle(nullConstraints.x, nullConstraints.y, nullConstraints.width, nullConstraints.height);
        if (rectangle.width < 0 || rectangle.height < 0) {
            Dimension dimension = component.getPreferredSize();
            if (rectangle.width < 0) {
                rectangle.width = dimension.width;
            }
            if (rectangle.height < 0) {
                rectangle.height = dimension.height;
            }
        }
        return rectangle;
    }
}

