/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.runtime;

import com.jformdesigner.model.FormLayoutConstraints;
import com.jformdesigner.model.FormLayoutManager;
import com.jformdesigner.runtime.AbstractLayoutCreator;
import com.jformdesigner.runtime.TableConstraints;
import com.jformdesigner.runtime.TableSpec;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;

public class TableLayoutCreator
extends AbstractLayoutCreator {
    private static final String PROP_COLUMN_SPECS = "$columnSpecs";
    private static final String PROP_ROW_SPECS = "$rowSpecs";
    private TableSpec[] columnSpecs;
    private TableSpec[] rowSpecs;

    public LayoutManager createLayoutManager(Container container, FormLayoutManager formLayoutManager) {
        String string = formLayoutManager.getPropertyString(PROP_COLUMN_SPECS, "");
        String string2 = formLayoutManager.getPropertyString(PROP_ROW_SPECS, "");
        int n2 = formLayoutManager.getPropertyInt("hGap", 0);
        int n3 = formLayoutManager.getPropertyInt("vGap", 0);
        this.columnSpecs = TableSpec.decodeSpecs(string);
        this.rowSpecs = TableSpec.decodeSpecs(string2);
        double[] dArray = this.toSizes(this.columnSpecs);
        double[] dArray2 = this.toSizes(this.rowSpecs);
        TableLayout tableLayout = new TableLayout(dArray, dArray2);
        tableLayout.setHGap(n2);
        tableLayout.setVGap(n3);
        return tableLayout;
    }

    private double[] toSizes(TableSpec[] tableSpecArray) {
        double[] dArray = new double[tableSpecArray.length];
        for (int i2 = 0; i2 < tableSpecArray.length; ++i2) {
            dArray[i2] = tableSpecArray[i2].getSize();
        }
        return dArray;
    }

    public void addComponentToContainer(Container container, Component component, Object object, int n2, FormLayoutConstraints formLayoutConstraints) {
        object = TableLayoutCreator.updateConstraints(object, this.columnSpecs, this.rowSpecs);
        container.add(component, object, n2);
    }

    public static Object updateConstraints(Object object, TableSpec[] tableSpecArray, TableSpec[] tableSpecArray2) {
        int n2;
        if (!(object instanceof TableConstraints)) {
            return object;
        }
        TableConstraints tableConstraints = (TableConstraints)object;
        int n3 = tableConstraints.getHAlign();
        int n4 = tableConstraints.getVAlign();
        if (n3 != -1 && n4 != -1) {
            return tableConstraints;
        }
        tableConstraints = new TableConstraints(tableConstraints);
        if (n3 == -1) {
            n2 = 2;
            if (tableConstraints.col1 == tableConstraints.col2 && tableConstraints.col1 >= 0 && tableConstraints.col1 < tableSpecArray.length) {
                n2 = TableLayoutCreator.updateHAlign(n3, tableConstraints.col1, tableSpecArray);
            }
            tableConstraints.setHAlign(n2);
        }
        if (n4 == -1) {
            n2 = 2;
            if (tableConstraints.row1 == tableConstraints.row2 && tableConstraints.row1 >= 0 && tableConstraints.row1 < tableSpecArray2.length) {
                n2 = TableLayoutCreator.updateVAlign(n4, tableConstraints.row1, tableSpecArray2);
            }
            tableConstraints.setVAlign(n2);
        }
        return tableConstraints;
    }

    public static int updateHAlign(int n2, int n3, TableSpec[] tableSpecArray) {
        int n4 = 2;
        switch (tableSpecArray[n3].getDefaultAlignment()) {
            case 2: {
                n4 = 0;
                break;
            }
            case 0: {
                n4 = 1;
                break;
            }
            case 4: {
                n4 = 3;
                break;
            }
            case 5: {
                n4 = 2;
            }
        }
        return n4;
    }

    public static int updateVAlign(int n2, int n3, TableSpec[] tableSpecArray) {
        int n4 = 2;
        switch (tableSpecArray[n3].getDefaultAlignment()) {
            case 1: {
                n4 = 0;
                break;
            }
            case 0: {
                n4 = 1;
                break;
            }
            case 3: {
                n4 = 3;
                break;
            }
            case 5: {
                n4 = 2;
            }
        }
        return n4;
    }
}

