/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.layout;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormSpecParser;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.util.LayoutStyle;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class LayoutMap {
    private static final char VARIABLE_PREFIX_CHAR = '$';
    private static final Map COLUMN_ALIASES = new HashMap();
    private static final Map ROW_ALIASES = new HashMap();
    private static LayoutMap root = null;
    private final LayoutMap parent;
    private final Map columnMap;
    private final Map columnMapCache;
    private final Map rowMap;
    private final Map rowMapCache;

    public LayoutMap() {
        this(LayoutMap.getRoot());
    }

    public LayoutMap(LayoutMap layoutMap) {
        this.parent = layoutMap;
        this.columnMap = new HashMap();
        this.rowMap = new HashMap();
        this.columnMapCache = new HashMap();
        this.rowMapCache = new HashMap();
    }

    public static LayoutMap getRoot() {
        if (root == null) {
            root = LayoutMap.createRoot();
        }
        return root;
    }

    public boolean columnContainsKey(String string) {
        String string2 = this.resolveColumnKey(string);
        return this.columnMap.containsKey(string2) || this.parent != null && this.parent.columnContainsKey(string2);
    }

    public String columnGet(String string) {
        String string2 = this.resolveColumnKey(string);
        String string3 = (String)this.columnMapCache.get(string2);
        if (string3 != null) {
            return string3;
        }
        String string4 = (String)this.columnMap.get(string2);
        if (string4 == null && this.parent != null) {
            string4 = this.parent.columnGet(string2);
        }
        if (string4 == null) {
            return null;
        }
        String string5 = this.expand(string4, true);
        this.columnMapCache.put(string2, string5);
        return string5;
    }

    public String columnPut(String string, String string2) {
        String string3 = this.resolveColumnKey(string);
        if (string2 == null) {
            throw new NullPointerException("The column expression value must not be null.");
        }
        this.columnMapCache.clear();
        return this.columnMap.put(string3, string2.toLowerCase(Locale.ENGLISH));
    }

    public String columnPut(String string, ColumnSpec columnSpec) {
        return this.columnPut(string, columnSpec.encode());
    }

    public String columnPut(String string, Size size) {
        return this.columnPut(string, size.encode());
    }

    public String columnRemove(String string) {
        String string2 = this.resolveColumnKey(string);
        this.columnMapCache.clear();
        return (String)this.columnMap.remove(string2);
    }

    public boolean rowContainsKey(String string) {
        String string2 = this.resolveRowKey(string);
        return this.rowMap.containsKey(string2) || this.parent != null && this.parent.rowContainsKey(string2);
    }

    public String rowGet(String string) {
        String string2 = this.resolveRowKey(string);
        String string3 = (String)this.rowMapCache.get(string2);
        if (string3 != null) {
            return string3;
        }
        String string4 = (String)this.rowMap.get(string2);
        if (string4 == null && this.parent != null) {
            string4 = this.parent.rowGet(string2);
        }
        if (string4 == null) {
            return null;
        }
        String string5 = this.expand(string4, false);
        this.rowMapCache.put(string2, string5);
        return string5;
    }

    public String rowPut(String string, String string2) {
        String string3 = this.resolveRowKey(string);
        if (string2 == null) {
            throw new NullPointerException("The row expression value must not be null.");
        }
        this.rowMapCache.clear();
        return this.rowMap.put(string3, string2.toLowerCase(Locale.ENGLISH));
    }

    public String rowPut(String string, RowSpec rowSpec) {
        return this.rowPut(string, rowSpec.encode());
    }

    public String rowPut(String string, Size size) {
        return this.rowPut(string, size.encode());
    }

    public String rowRemove(String string) {
        String string2 = this.resolveRowKey(string);
        this.rowMapCache.clear();
        return (String)this.rowMap.remove(string2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("\n  Column associations:");
        for (Map.Entry entry : this.columnMap.entrySet()) {
            stringBuffer.append("\n    ");
            stringBuffer.append(entry.getKey());
            stringBuffer.append("->");
            stringBuffer.append(entry.getValue());
        }
        stringBuffer.append("\n  Row associations:");
        for (Map.Entry entry : this.rowMap.entrySet()) {
            stringBuffer.append("\n    ");
            stringBuffer.append(entry.getKey());
            stringBuffer.append("->");
            stringBuffer.append(entry.getValue());
        }
        return stringBuffer.toString();
    }

    String expand(String string, boolean bl2) {
        String string2;
        int n2 = 0;
        int n3 = string.indexOf(36, n2);
        if (n3 == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        do {
            stringBuffer.append(string.substring(n2, n3));
            string2 = this.nextVariableName(string, n3);
            stringBuffer.append(this.expansion(string2, bl2));
        } while ((n3 = string.indexOf(36, n2 = n3 + string2.length() + 1)) != -1);
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    private String nextVariableName(String string, int n2) {
        int n3;
        int n4 = string.length();
        if (n4 <= n2) {
            FormSpecParser.fail(string, n2, "Missing variable name after variable char '$'.");
        }
        if (string.charAt(n2 + 1) == '{') {
            int n5 = string.indexOf(125, n2 + 1);
            if (n5 == -1) {
                FormSpecParser.fail(string, n2, "Missing closing brace '}' for variable.");
            }
            return string.substring(n2 + 1, n5 + 1);
        }
        for (n3 = n2 + 1; n3 < n4 && Character.isUnicodeIdentifierPart(string.charAt(n3)); ++n3) {
        }
        return string.substring(n2 + 1, n3);
    }

    private String expansion(String string, boolean bl2) {
        String string2;
        String string3 = LayoutMap.stripBraces(string);
        String string4 = string2 = bl2 ? this.columnGet(string3) : this.rowGet(string3);
        if (string2 == null) {
            String string5 = bl2 ? "column" : "row";
            throw new IllegalArgumentException("Unknown " + string5 + " layout variable \"" + string3 + "\"");
        }
        return string2;
    }

    private static String stripBraces(String string) {
        return string.charAt(0) == '{' ? string.substring(1, string.length() - 1) : string;
    }

    private String resolveColumnKey(String string) {
        if (string == null) {
            throw new NullPointerException("The key must not be null.");
        }
        String string2 = string.toLowerCase(Locale.ENGLISH);
        String string3 = (String)COLUMN_ALIASES.get(string2);
        return string3 == null ? string2 : string3;
    }

    private String resolveRowKey(String string) {
        if (string == null) {
            throw new NullPointerException("The key must not be null.");
        }
        String string2 = string.toLowerCase(Locale.ENGLISH);
        String string3 = (String)ROW_ALIASES.get(string2);
        return string3 == null ? string2 : string3;
    }

    private static LayoutMap createRoot() {
        LayoutMap layoutMap = new LayoutMap(null);
        layoutMap.columnPut("label-component-gap", new String[]{"lcg", "lcgap"}, FormFactory.LABEL_COMPONENT_GAP_COLSPEC);
        layoutMap.columnPut("related-gap", new String[]{"rg", "rgap"}, FormFactory.RELATED_GAP_COLSPEC);
        layoutMap.columnPut("unrelated-gap", new String[]{"ug", "ugap"}, FormFactory.UNRELATED_GAP_COLSPEC);
        layoutMap.columnPut("button", new String[]{"b"}, FormFactory.BUTTON_COLSPEC);
        layoutMap.columnPut("growing-button", new String[]{"gb"}, FormFactory.GROWING_BUTTON_COLSPEC);
        layoutMap.columnPut("dialog-margin", new String[]{"dm", "dmargin"}, ColumnSpec.createGap(LayoutStyle.getCurrent().getDialogMarginX()));
        layoutMap.columnPut("tabbed-dialog-margin", new String[]{"tdm", "tdmargin"}, ColumnSpec.createGap(LayoutStyle.getCurrent().getTabbedDialogMarginX()));
        layoutMap.columnPut("glue", FormFactory.GLUE_COLSPEC.toShortString());
        layoutMap.rowPut("related-gap", new String[]{"rg", "rgap"}, FormFactory.RELATED_GAP_ROWSPEC);
        layoutMap.rowPut("unrelated-gap", new String[]{"ug", "ugap"}, FormFactory.UNRELATED_GAP_ROWSPEC);
        layoutMap.rowPut("narrow-line-gap", new String[]{"nlg", "nlgap"}, FormFactory.NARROW_LINE_GAP_ROWSPEC);
        layoutMap.rowPut("line-gap", new String[]{"lg", "lgap"}, FormFactory.LINE_GAP_ROWSPEC);
        layoutMap.rowPut("paragraph-gap", new String[]{"pg", "pgap"}, FormFactory.PARAGRAPH_GAP_ROWSPEC);
        layoutMap.rowPut("dialog-margin", new String[]{"dm", "dmargin"}, RowSpec.createGap(LayoutStyle.getCurrent().getDialogMarginY()));
        layoutMap.rowPut("tabbed-dialog-margin", new String[]{"tdm", "tdmargin"}, RowSpec.createGap(LayoutStyle.getCurrent().getTabbedDialogMarginY()));
        layoutMap.rowPut("button", new String[]{"b"}, FormFactory.BUTTON_ROWSPEC);
        layoutMap.rowPut("glue", FormFactory.GLUE_ROWSPEC);
        return layoutMap;
    }

    private void columnPut(String string, String[] stringArray, ColumnSpec columnSpec) {
        this.ensureLowerCase(string);
        this.columnPut(string, columnSpec);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.ensureLowerCase(stringArray[i2]);
            COLUMN_ALIASES.put(stringArray[i2], string);
        }
    }

    private void rowPut(String string, String[] stringArray, RowSpec rowSpec) {
        this.ensureLowerCase(string);
        this.rowPut(string, rowSpec);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.ensureLowerCase(stringArray[i2]);
            ROW_ALIASES.put(stringArray[i2], string);
        }
    }

    private void ensureLowerCase(String string) {
        String string2 = string.toLowerCase(Locale.ENGLISH);
        if (!string2.equals(string)) {
            throw new IllegalArgumentException("The string \"" + string + "\" should be lower case.");
        }
    }
}

