/*
 * Copyright (C) 2008-2011 Karl Tauber <karl at jformdesigner dot com>
 * All Rights Reserved
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 *  o Neither the name of JFormDesigner or Karl Tauber nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.jformdesigner.runtime;

import com.jformdesigner.model.FormBinding;

/**
 * @author Karl Tauber
 * @since 5.0
 */
public interface BeansBindingConstants
{
	public static final String PROP_SOURCE = FormBinding.PROP_SOURCE;
	public static final String PROP_SOURCE_PATH = FormBinding.PROP_SOURCE_PATH;
	public static final String PROP_SOURCE_PATH_TYPE = "sourcePathType";
	public static final String PROP_TARGET = FormBinding.PROP_TARGET;
	public static final String PROP_TARGET_PATH = FormBinding.PROP_TARGET_PATH;
	public static final String PROP_TARGET_PATH_TYPE = "targetPathType";
	public static final String PROP_UPDATE_STRATEGY = "updateStrategy";
	public static final String PROP_BIND_IMMEDIATELY = "bindImmediately";
	public static final String PROP_NAME = "name";
	public static final String PROP_DETAIL_PATH = "detailPath";
	public static final String PROP_DETAIL_PATH_TYPE = "detailPathType";
	public static final String PROP_SUB_BINDINGS = "subBindings";
	public static final String PROP_COLUMN_NAME = "columnName";
	public static final String PROP_COLUMN_CLASS = "columnClass";
	public static final String PROP_EDITABLE = "editable";

	public static final String PROP_CONVERTER = "converter";
	public static final String PROP_VALIDATOR = "validator";
	public static final String PROP_SOURCE_NULL_VALUE = "sourceNullValue";
	public static final String PROP_TARGET_NULL_VALUE = "targetNullValue";
	public static final String PROP_SOURCE_UNREADABLE_VALUE = "sourceUnreadableValue";
}
