/*
 * Decompiled with CFR 0.152.
 */
package jarxplorer.gui.tree;

import jarxplorer.model.ConstructorNode;
import jarxplorer.model.FieldNode;
import jarxplorer.model.MethodNode;
import jarxplorer.model.MyTreeNode;
import jarxplorer.parser.MyField;
import jarxplorer.parser.MyMethod;
import java.net.URL;
import java.util.HashMap;
import javax.swing.ImageIcon;

public class IconFactory {
    private static final HashMap<String, String> defaultIcons = new HashMap();
    private static final HashMap<String, String> classIcons = new HashMap();
    private static IconFactory instance = null;

    private IconFactory() {
        defaultIcons.put("RootNode", "jarxplorer/icons/root.gif");
        defaultIcons.put("DirectoryNode", "jarxplorer/icons/directory.gif");
        defaultIcons.put("ClassNode", "jarxplorer/icons/class.gif");
        defaultIcons.put("ClassNodeLabel", "jarxplorer/icons/classLabel.gif");
        defaultIcons.put("FieldNodeLabel", "jarxplorer/icons/fields.gif");
        defaultIcons.put("MethodNodeLabel", "jarxplorer/icons/methods.gif");
        defaultIcons.put("ConstructorNodeLabel", "jarxplorer/icons/constructors.gif");
        defaultIcons.put("DefaultNode", "jarxplorer/icons/default.gif");
        defaultIcons.put("FileJava", "jarxplorer/icons/filejava.gif");
        defaultIcons.put("Error", "jarxplorer/icons/error.gif");
        classIcons.put("MethodNode", "jarxplorer/icons/methods/defaultmethod.gif");
        classIcons.put("MethodNodeprivate", "jarxplorer/icons/methods/privatemethod.gif");
        classIcons.put("MethodNodepublic", "jarxplorer/icons/methods/publicmethod.gif");
        classIcons.put("MethodNodeprotected", "jarxplorer/icons/methods/protectedmethod.gif");
        classIcons.put("MethodNodestatic", "jarxplorer/icons/methods/defaultstaticmethod.gif");
        classIcons.put("MethodNodepublicstatic", "jarxplorer/icons/methods/publicstaticmethod.gif");
        classIcons.put("MethodNodeprivatestatic", "jarxplorer/icons/methods/privatestaticmethod.gif");
        classIcons.put("MethodNodeprotectecstatic", "jarxplorer/icons/methods/protectedstatic.gif");
        classIcons.put("FieldNode", "jarxplorer/icons/fields/defaultfield.gif");
        classIcons.put("FieldNodeprivate", "jarxplorer/icons/fields/privatefield.gif");
        classIcons.put("FieldNodepublic", "jarxplorer/icons/fields/publicfield.gif");
        classIcons.put("FieldNodeprotected", "jarxplorer/icons/fields/protectedfield.gif");
        classIcons.put("FieldNodestatic", "jarxplorer/icons/fields/defaultstaticfield.gif");
        classIcons.put("FieldNodepublicstatic", "jarxplorer/icons/fields/publicstaticfield.gif");
        classIcons.put("FieldNodeprivatestatic", "jarxplorer/icons/fields/privatestaticfield.gif");
        classIcons.put("FieldNodeprotectedstatic", "jarxplorer/icons/fields/protectedstaticfield.gif");
        classIcons.put("ConstructorNode", "jarxplorer/icons/constructor/defaultconstructor.gif");
        classIcons.put("ConstructorNodeprivate", "jarxplorer/icons/constructor/privateconstructor.gif");
        classIcons.put("ConstructorNodepublic", "jarxplorer/icons/constructor/publicconstructor.gif");
        classIcons.put("ConstructorNodeprotected", "jarxplorer/icons/constructor/protectedconstructor.gif");
        classIcons.put("ConstructorNodestatic", "jarxplorer/icons/constructor/staticconstructor.gif");
        classIcons.put("DefaultNode", "jarxplorer/icons/default.gif");
    }

    public static final IconFactory getInstance() {
        if (instance == null) {
            instance = new IconFactory();
        }
        return instance;
    }

    public HashMap getMap() {
        return defaultIcons;
    }

    public ImageIcon getIcon(String string) {
        URL uRL = ClassLoader.getSystemResource(defaultIcons.get(string));
        return new ImageIcon(uRL);
    }

    public ImageIcon getIcon(MyTreeNode myTreeNode, boolean bl) {
        URL uRL;
        String string = myTreeNode.getType();
        if (defaultIcons.containsKey(string)) {
            uRL = ClassLoader.getSystemResource(defaultIcons.get(string));
        } else if (string.equals("MethodNode")) {
            MyMethod myMethod = ((MethodNode)myTreeNode).getMethod();
            String string2 = this.getKey(myMethod);
            uRL = ClassLoader.getSystemResource(classIcons.get(string2));
        } else if (string.equals("FieldNode")) {
            MyField myField = ((FieldNode)myTreeNode).getField();
            String string3 = this.getKey(myField);
            uRL = ClassLoader.getSystemResource(classIcons.get(string3));
        } else if (string.equals("ConstructorNode")) {
            MyMethod myMethod = ((ConstructorNode)myTreeNode).getMethod();
            String string4 = this.getConstructorKey(myMethod);
            uRL = ClassLoader.getSystemResource(classIcons.get(string4));
        } else {
            uRL = bl ? ClassLoader.getSystemResource(defaultIcons.get("DefaultNode")) : ClassLoader.getSystemResource(defaultIcons.get("DirectoryNode"));
        }
        return new ImageIcon(uRL);
    }

    private String getConstructorKey(MyMethod myMethod) {
        String string = "ConstructorNode" + myMethod.getModifiers();
        if (classIcons.containsKey(string = this.cleanUpKey(string))) {
            return string;
        }
        return "DefaultNode";
    }

    private String getKey(MyField myField) {
        String string = "FieldNode" + myField.getModifiers();
        if (classIcons.containsKey(string = this.cleanUpKey(string))) {
            return string;
        }
        return "DefaultNode";
    }

    private String getKey(MyMethod myMethod) {
        String string = "MethodNode" + myMethod.getModifiers();
        if (classIcons.containsKey(string = this.cleanUpKey(string))) {
            return string;
        }
        return "DefaultNode";
    }

    private String cleanUpKey(String string) {
        return string.replace(" ", "").replace("final", "").replace("abstract", "").replace("synchronized", "").replace("transient", "").replace("native", "");
    }
}

