/*
 * Decompiled with CFR 0.152.
 */
package jarxplorer.parser;

import de.schlichtherle.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Utility;

public class MyClass {
    private String path;
    private String fileSize;
    private String modificationTime;
    private String name;
    private String access;
    private String superClass;
    private String className;

    public MyClass(String string, String string2, JavaClass javaClass) {
        File file = new File(string);
        this.path = file.getAbsolutePath();
        this.fileSize = new Long(file.length()).toString();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd, yyyy k:m:s");
        this.modificationTime = simpleDateFormat.format(new Date(file.lastModified()));
        String string3 = javaClass.getClassName();
        int n = string3.lastIndexOf(".") + 1;
        this.name = string3.substring(n, string3.length());
        this.superClass = javaClass.getSuperclassName();
        String string4 = string2.replace("/", ".");
        this.className = string4.substring(0, string4.length() - 6);
        this.access = Utility.accessToString(javaClass.getAccessFlags(), true);
    }

    public String getPath() {
        return this.path;
    }

    public String getFileSize() {
        return this.fileSize;
    }

    public String getModificationTime() {
        return this.modificationTime;
    }

    public String getName() {
        return this.name;
    }

    public String getAccess() {
        return this.access;
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public String getClassName() {
        return this.className;
    }
}

