/*
 * Decompiled with CFR 0.152.
 */
package sdoc;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainView;
import sdoc.SyntaxDocument;
import sdoc.SyntaxEditorPaneUI;
import sdoc.SyntaxSupport;
import sdoc.SyntaxTextUI;
import sdoc.lexers.tokens.Token;

class SyntaxView
extends PlainView {
    public SyntaxView(Element elem) {
        super(elem);
    }

    protected void drawLine(int lineIndex, Graphics g, int x, int y) {
        JTextComponent comp = (JTextComponent)this.getContainer();
        if (!(this.getDocument() instanceof SyntaxDocument)) {
            return;
        }
        SyntaxDocument document = (SyntaxDocument)this.getDocument();
        int index = -1;
        index = comp.getUI() instanceof SyntaxTextUI ? ((SyntaxTextUI)comp.getUI()).getSelectedIndex() : ((SyntaxEditorPaneUI)comp.getUI()).getSelectedIndex();
        SyntaxSupport config = SyntaxSupport.getInstance();
        FontMetrics fm = comp.getFontMetrics(comp.getFont());
        Rectangle rec = new Rectangle(x, y - fm.getMaxAscent() + 1, comp.getWidth(), fm.getMaxAscent());
        Graphics2D g2d = (Graphics2D)g;
        if (index == lineIndex && config.getShouldHighlightCurrentLine()) {
            if (config.getShouldDrawCurrentLineFill()) {
                g2d.setColor(config.getCurrentLineFillColor());
                g2d.fill(rec);
            }
            if (config.getShouldDrawCurrentLineBorder()) {
                g2d.setColor(config.getCurrentLineBorderColor());
                g2d.draw(rec);
            }
        }
        List tokens = document.getTokenListForLine(lineIndex);
        float nextX = x;
        int i = 0;
        while (i < tokens.size()) {
            Token token = (Token)tokens.get(i);
            nextX = token.paint((Graphics2D)g, nextX, y, comp, this);
            ++i;
        }
    }
}

