/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.ArchiveBusyException;
import de.schlichtherle.io.ArchiveController;
import de.schlichtherle.io.ArchiveEntryMetaData;
import de.schlichtherle.io.ArchiveException;
import de.schlichtherle.io.ArchiveFileSystem;
import de.schlichtherle.io.ArchiveStatistics;
import de.schlichtherle.io.ArchiveWarningException;
import de.schlichtherle.io.ChainableIOException;
import de.schlichtherle.io.File;
import de.schlichtherle.io.FileBusyException;
import de.schlichtherle.io.FileConstants;
import de.schlichtherle.io.FileFactory;
import de.schlichtherle.io.InputIOException;
import de.schlichtherle.io.ReentrantLock;
import de.schlichtherle.io.ReentrantReadWriteLock;
import de.schlichtherle.io.archive.Archive;
import de.schlichtherle.io.archive.spi.ArchiveDriver;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.InputArchiveBusyException;
import de.schlichtherle.io.archive.spi.OutputArchiveBusyException;
import de.schlichtherle.io.rof.SimpleReadOnlyFile;
import de.schlichtherle.key.PromptingKeyManager;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;

abstract class ArchiveController
implements Archive,
FileConstants {
    private static final String CLASS_NAME;
    private static final Logger logger;
    private static final Map controllers;
    private static final LiveStatistics liveStats;
    private static final CopyLock copyLock;
    private static final Comparator REVERSE_CONTROLLERS;
    private final WeakReference weakThis = new WeakReference<ArchiveController>(this);
    private final java.io.File target;
    private final ArchiveController enclController;
    private final String enclEntryName;
    private ArchiveDriver driver;
    private final ReentrantLock readLock;
    private final ReentrantLock writeLock;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$de$schlichtherle$key$PromptingKeyManager;

    protected ArchiveController(java.io.File file, ArchiveController archiveController, String string, ArchiveDriver archiveDriver) {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !file.isAbsolute()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && archiveController != null != (string != null)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && archiveDriver == null) {
            throw new AssertionError();
        }
        this.target = file;
        this.enclController = archiveController;
        this.enclEntryName = string;
        this.driver = archiveDriver;
        ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
        this.readLock = reentrantReadWriteLock.readLock();
        this.writeLock = reentrantReadWriteLock.writeLock();
        this.schedule(false);
    }

    protected final ReentrantLock readLock() {
        return this.readLock;
    }

    protected final ReentrantLock writeLock() {
        return this.writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void runWriteLocked(IORunnable iORunnable) throws IOException {
        int n;
        for (int i = n = this.readLock().lockCount(); i > 0; --i) {
            this.readLock().unlock();
        }
        this.writeLock().lock();
        try {
            try {
                iORunnable.run();
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                for (int i = n; i > 0; --i) {
                    this.readLock().lock();
                }
                throw throwable;
            }
            for (int i = n; i > 0; --i) {
                this.readLock().lock();
            }
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * Exception decompiling
     */
    static ArchiveController getInstance(File var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void schedule(boolean bl) {
        Map map = controllers;
        synchronized (map) {
            if (bl) {
                controllers.put(this.getTarget(), this);
            } else {
                controllers.put(this.getTarget(), this.weakThis);
            }
        }
    }

    public final java.io.File getTarget() {
        return this.target;
    }

    public final String getPath() {
        return this.target.getPath();
    }

    public final ArchiveController getEnclController() {
        return this.enclController;
    }

    public final String getEnclEntryName() {
        return this.enclEntryName;
    }

    public final String enclEntryName(String string) {
        return "" != string ? this.enclEntryName + "/" + string : this.enclEntryName;
    }

    protected final ArchiveDriver getDriver() {
        return this.driver;
    }

    protected final void setDriver(ArchiveDriver archiveDriver) {
        this.driver = archiveDriver;
    }

    static final ArchiveStatistics getLiveStatistics() {
        return liveStats;
    }

    protected final boolean usesNativeTargetFile() {
        return this.enclController == null || this.enclController.getTarget().isDirectory();
    }

    protected abstract ArchiveFileSystem getFileSystem(boolean var1) throws IOException;

    protected abstract InputStream getInputStream(String var1) throws IOException;

    protected abstract InputStream getInputStream(ArchiveEntry var1, ArchiveEntry var2) throws IOException;

    protected abstract OutputStream getOutputStream(String var1) throws IOException;

    protected abstract OutputStream getOutputStream(ArchiveEntry var1, ArchiveEntry var2) throws IOException;

    protected abstract void onFileSystemTouch() throws IOException;

    protected abstract boolean hasNewData(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateAll(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) throws ArchiveException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (!bl2 && bl4) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        int n2 = 0;
        logger.log(Level.FINE, "updateAll.entering", new Object[]{string, bl, bl2, bl3, bl4, bl5, bl6});
        if (bl6) {
            CountingReadOnlyFile.resetOnReuse();
            CountingOutputStream.resetOnReuse();
        }
        try {
            try {
                if (bl5) {
                    System.runFinalization();
                }
                ChainableIOException chainableIOException = null;
                ControllerEnumeration controllerEnumeration = new ControllerEnumeration(string, REVERSE_CONTROLLERS);
                while (controllerEnumeration.hasMoreElements()) {
                    ArchiveController archiveController = (ArchiveController)controllerEnumeration.nextElement();
                    archiveController.writeLock().lock();
                    try {
                        if (archiveController.isTouched()) {
                            ++n2;
                        }
                        try {
                            archiveController.update((ArchiveException)chainableIOException, bl, bl2, bl3, bl4, bl5, true);
                        }
                        catch (ArchiveException archiveException) {
                            chainableIOException = archiveException;
                        }
                    }
                    finally {
                        archiveController.writeLock().unlock();
                    }
                    ++n;
                }
                if (chainableIOException != null) {
                    throw (ArchiveException)chainableIOException.sortPriority();
                }
                Object var15_16 = null;
            }
            catch (ArchiveWarningException archiveWarningException) {
                logger.log(Level.FINE, "updateAll.throwing", archiveWarningException);
                throw archiveWarningException;
            }
            catch (ArchiveException archiveException) {
                logger.log(Level.FINE, "updateAll.throwing", archiveException);
                throw archiveException;
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            CountingReadOnlyFile.setResetOnReuse();
            CountingOutputStream.setResetOnReuse();
            logger.log(Level.FINE, "updateAll.finally", new Object[]{new Integer(n), new Integer(n2)});
            throw throwable;
        }
        CountingReadOnlyFile.setResetOnReuse();
        CountingOutputStream.setResetOnReuse();
        logger.log(Level.FINE, "updateAll.finally", new Object[]{new Integer(n), new Integer(n2)});
    }

    protected final void update() throws ArchiveException {
        if (!$assertionsDisabled && !this.writeLock().isLocked()) {
            throw new AssertionError();
        }
        this.update(null, false, false, false, false, false, false);
    }

    protected abstract void update(ArchiveException var1, boolean var2, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7) throws ArchiveException;

    protected abstract boolean isTouched();

    protected abstract void reset() throws IOException;

    public String toString() {
        return this.getClass().getName() + "@" + System.identityHashCode(this) + "(" + this.getPath() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean exists(String string) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem archiveFileSystem = this.getFileSystem(false);
            boolean bl = archiveFileSystem.exists(string);
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isFile(String string) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem archiveFileSystem = this.getFileSystem(false);
            boolean bl = archiveFileSystem.isFile(string);
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isDirectory(String string) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem archiveFileSystem = this.getFileSystem(false);
            boolean bl = archiveFileSystem.isDirectory(string);
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Icon getOpenIcon(String string) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem archiveFileSystem = this.getFileSystem(false);
            if ("" != string) {
                Icon icon = archiveFileSystem.getOpenIcon(string);
                return icon;
            }
            Icon icon = this.getDriver().getOpenIcon(this);
            return icon;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Icon getClosedIcon(String string) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem archiveFileSystem = this.getFileSystem(false);
            if ("" != string) {
                Icon icon = archiveFileSystem.getClosedIcon(string);
                return icon;
            }
            Icon icon = this.getDriver().getClosedIcon(this);
            return icon;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean canRead(String string) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem archiveFileSystem = this.getFileSystem(false);
            boolean bl = archiveFileSystem.exists(string);
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean canWrite(String string) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem archiveFileSystem = this.getFileSystem(false);
            boolean bl = archiveFileSystem.canWrite(string);
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long length(String string) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem archiveFileSystem = this.getFileSystem(false);
            long l = archiveFileSystem.length(string);
            return l;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long lastModified(String string) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem archiveFileSystem = this.getFileSystem(false);
            long l = archiveFileSystem.lastModified(string);
            return l;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String[] list(String string) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem archiveFileSystem = this.getFileSystem(false);
            String[] stringArray = archiveFileSystem.list(string);
            return stringArray;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String[] list(String string, FilenameFilter filenameFilter, File file) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem archiveFileSystem = this.getFileSystem(false);
            String[] stringArray = archiveFileSystem.list(string, filenameFilter, file);
            return stringArray;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final java.io.File[] listFiles(String string, FilenameFilter filenameFilter, File file, FileFactory fileFactory) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem archiveFileSystem = this.getFileSystem(false);
            java.io.File[] fileArray = archiveFileSystem.listFiles(string, filenameFilter, file, fileFactory);
            return fileArray;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final java.io.File[] listFiles(String string, FileFilter fileFilter, File file, FileFactory fileFactory) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem archiveFileSystem = this.getFileSystem(false);
            java.io.File[] fileArray = archiveFileSystem.listFiles(string, fileFilter, file, fileFactory);
            return fileArray;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean setReadOnly(String string) throws IOException {
        this.writeLock().lock();
        try {
            ArchiveFileSystem archiveFileSystem = this.getFileSystem(false);
            boolean bl = archiveFileSystem.setReadOnly(string);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean setLastModified(String string, long l) throws IOException {
        this.writeLock().lock();
        try {
            ArchiveFileSystem archiveFileSystem = this.getFileSystem(false);
            if (archiveFileSystem.isReadOnly()) {
                boolean bl = false;
                return bl;
            }
            if (this.hasNewData(string)) {
                this.update();
                archiveFileSystem = this.getFileSystem(false);
            }
            boolean bl = archiveFileSystem.setLastModified(string, l);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean createNewFile(String string, boolean bl) throws IOException {
        this.writeLock().lock();
        try {
            ArchiveFileSystem archiveFileSystem = this.getFileSystem(bl);
            if (archiveFileSystem.isFile(string)) {
                boolean bl2 = false;
                return bl2;
            }
            this.getOutputStream(string).close();
            boolean bl3 = true;
            return bl3;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean mkdir(String string, boolean bl) throws IOException {
        this.writeLock().lock();
        try {
            if ("" != string) {
                ArchiveFileSystem archiveFileSystem = this.getFileSystem(bl);
                boolean bl2 = archiveFileSystem.mkdir(string, bl);
                return bl2;
            }
            this.getFileSystem(false);
            boolean bl3 = false;
            return bl3;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean delete(String string) throws IOException {
        this.writeLock().lock();
        try {
            if (this.hasNewData(string)) {
                this.update();
            }
            ArchiveFileSystem archiveFileSystem = this.getFileSystem(false);
            if ("" != string) {
                boolean bl = archiveFileSystem.delete(string);
                return bl;
            }
            String[] stringArray = archiveFileSystem.list(string);
            if (stringArray != null && stringArray.length != 0) {
                boolean bl = false;
                return bl;
            }
            this.reset();
            PromptingKeyManager.resetKeyProvider(this.getPath());
            if (this.usesNativeTargetFile()) {
                boolean bl = this.getTarget().delete();
                return bl;
            }
            boolean bl = this.enclController.delete(this.enclEntryName(string));
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void cp(java.io.File file, java.io.File file2, boolean bl) throws IOException {
        if (file == null || file2 == null) {
            throw new NullPointerException();
        }
        try {
            Object object;
            if (file instanceof File) {
                object = (File)file;
                if (((File)object).isArchive() && (((File)object).isDirectory() || ((File)object).exists() && !((File)object).isFile())) {
                    throw new FileNotFoundException(file.getPath() + ": Cannot read (possibly inaccessible) archive file!");
                }
                String string = ((File)object).getEnclEntryName();
                if (string != null) {
                    ArchiveController.cp((File)object, ((File)object).getEnclArchive().getArchiveController(), string, file2, bl);
                    return;
                }
            }
            try {
                object = new FileInputStream(file);
            }
            catch (IOException iOException) {
                throw new InputIOException(iOException);
            }
            try {
                ArchiveController.cp(file, (InputStream)object, file2, bl);
            }
            finally {
                try {
                    ((InputStream)object).close();
                }
                catch (IOException iOException) {
                    throw new InputIOException(iOException);
                }
            }
        }
        catch (InputArchiveBusyException inputArchiveBusyException) {
            throw new FileBusyException(inputArchiveBusyException);
        }
        catch (OutputArchiveBusyException outputArchiveBusyException) {
            throw new FileBusyException(outputArchiveBusyException);
        }
        catch (ArchiveBusyException archiveBusyException) {
            throw new FileBusyException(archiveBusyException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void cp(java.io.File file, InputStream inputStream, java.io.File file2, boolean bl) throws IOException {
        Object object;
        if (file2 instanceof File) {
            object = (File)file2;
            if (((File)object).isArchive() && (((File)object).isDirectory() || ((File)object).exists() && !((File)object).isFile())) {
                throw new FileNotFoundException(file2.getPath() + ": Cannot overwrite (possibly inaccessible) archive file!");
            }
            String string = ((File)object).getEnclEntryName();
            if (string != null) {
                ArchiveController.cp(file, inputStream, (File)object, ((File)object).getEnclArchive().getArchiveController(), string, bl);
                return;
            }
        }
        object = new FileOutputStream(file2);
        try {
            File.cat(inputStream, (OutputStream)object);
        }
        finally {
            ((OutputStream)object).close();
        }
        if (bl && !file2.setLastModified(file.lastModified())) {
            throw new FileNotFoundException(file2.getPath() + ": Couldn't preserve last modification time!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void cp(File file, ArchiveController archiveController, String string, java.io.File file2, boolean bl) throws IOException {
        try {
            try {
                FileOutputStream fileOutputStream;
                long l;
                Object object;
                if (file2 instanceof File) {
                    object = (File)file2;
                    if (((File)object).isArchive() && (((File)object).isDirectory() || ((File)object).exists() && !((File)object).isFile())) {
                        throw new FileNotFoundException(file2.getPath() + ": Cannot overwrite (possibly inaccessible) archive file!");
                    }
                    String string2 = ((File)object).getEnclEntryName();
                    if (string2 != null) {
                        ArchiveController.cp(file, archiveController, string, (File)object, ((File)object).getEnclArchive().getArchiveController(), string2, bl);
                        return;
                    }
                }
                archiveController.readLock().lock();
                try {
                    try {
                        object = archiveController.getInputStream(string);
                    }
                    catch (IOException iOException) {
                        throw new InputIOException(iOException);
                    }
                    l = archiveController.lastModified(string);
                }
                finally {
                    archiveController.readLock().unlock();
                }
                try {
                    fileOutputStream = new FileOutputStream(file2);
                }
                catch (IOException iOException) {
                    try {
                        ((InputStream)object).close();
                    }
                    catch (IOException iOException2) {
                        throw new InputIOException(iOException2);
                    }
                    throw iOException;
                }
                File.cp((InputStream)object, fileOutputStream);
                if (bl && !file2.setLastModified(l)) {
                    throw new FileNotFoundException(file2.getPath() + ": Couldn't preserve last modification time!");
                }
            }
            catch (FalsePositiveDirectoryEntryException falsePositiveDirectoryEntryException) {
                if (!$assertionsDisabled && archiveController != falsePositiveDirectoryEntryException.getSource()) {
                    throw new AssertionError();
                }
                ArchiveController.cp(file, archiveController.getEnclController(), archiveController.enclEntryName(string), file2, bl);
            }
        }
        catch (FalsePositiveNativeException falsePositiveNativeException) {
            if (!$assertionsDisabled && archiveController != falsePositiveNativeException.getSource()) {
                throw new AssertionError();
            }
            ArchiveController.cp(file.getDelegate(), file2, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void cp(File file, ArchiveController archiveController, String string, File file2, ArchiveController archiveController2, String string2, boolean bl) throws IOException {
        try {
            class IOStreamCreator
            implements IORunnable {
                InputStream in;
                OutputStream out;
                private final /* synthetic */ String val$srcEntryName;
                private final /* synthetic */ ArchiveController val$dstController;
                private final /* synthetic */ String val$dstEntryName;
                private final /* synthetic */ boolean val$preserve;

                IOStreamCreator(String string, ArchiveController archiveController2, String string2, boolean bl) {
                    this.val$srcEntryName = string;
                    this.val$dstController = archiveController2;
                    this.val$dstEntryName = string2;
                    this.val$preserve = bl;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    ArchiveEntry archiveEntry;
                    ArchiveFileSystem.Delta delta;
                    ArchiveEntry archiveEntry2;
                    class SrcControllerUpdater
                    implements IORunnable {
                        private final /* synthetic */ IOStreamCreator this$0;

                        SrcControllerUpdater(IOStreamCreator iOStreamCreator) {
                            this.this$0 = iOStreamCreator;
                        }

                        public void run() throws IOException {
                            if (IOStreamCreator.access$800(this.this$0).hasNewData(IOStreamCreator.access$700(this.this$0))) {
                                IOStreamCreator.access$800(this.this$0).update();
                            }
                            IOStreamCreator.access$800(this.this$0).readLock().lock();
                        }
                    }
                    ArchiveController.this.runWriteLocked(new SrcControllerUpdater(this));
                    try {
                        if (this.val$dstController.hasNewData(this.val$dstEntryName)) {
                            this.val$dstController.update();
                        }
                        ArchiveFileSystem archiveFileSystem = ArchiveController.this.getFileSystem(false);
                        archiveEntry2 = archiveFileSystem.get(this.val$srcEntryName);
                        boolean bl = File.isLenient();
                        ArchiveFileSystem archiveFileSystem2 = this.val$dstController.getFileSystem(bl);
                        delta = archiveFileSystem2.beginCreateAndLink(this.val$dstEntryName, bl, this.val$preserve ? archiveEntry2 : null);
                        archiveEntry = delta.getEntry();
                        try {
                            this.in = ArchiveController.this.getInputStream(archiveEntry2, archiveEntry);
                        }
                        catch (IOException iOException) {
                            throw new InputIOException(iOException);
                        }
                    }
                    finally {
                        ArchiveController.this.readLock().unlock();
                    }
                    try {
                        this.out = this.val$dstController.getOutputStream(archiveEntry, archiveEntry2);
                        try {
                            delta.commit();
                        }
                        catch (IOException iOException) {
                            this.out.close();
                            throw iOException;
                        }
                    }
                    catch (IOException iOException) {
                        try {
                            this.in.close();
                        }
                        catch (IOException iOException2) {
                            throw new InputIOException(iOException2);
                        }
                        throw iOException;
                    }
                }

                static /* synthetic */ String access$700(IOStreamCreator iOStreamCreator) {
                    return iOStreamCreator.val$srcEntryName;
                }

                static /* synthetic */ ArchiveController access$800(IOStreamCreator iOStreamCreator) {
                    return iOStreamCreator.ArchiveController.this;
                }
            }
            IOStreamCreator iOStreamCreator = archiveController.new IOStreamCreator(string, archiveController2, string2, bl);
            Object object = copyLock;
            synchronized (object) {
                archiveController2.runWriteLocked(iOStreamCreator);
            }
            object = iOStreamCreator.in;
            OutputStream outputStream = iOStreamCreator.out;
            File.cp((InputStream)object, outputStream);
        }
        catch (FalsePositiveDirectoryEntryException falsePositiveDirectoryEntryException) {
            if (archiveController2 != falsePositiveDirectoryEntryException.getSource()) {
                throw falsePositiveDirectoryEntryException;
            }
            ArchiveController.cp(file, archiveController, string, file2, archiveController2.getEnclController(), archiveController2.enclEntryName(string2), bl);
        }
        catch (FalsePositiveNativeException falsePositiveNativeException) {
            if (archiveController2 != falsePositiveNativeException.getSource()) {
                throw falsePositiveNativeException;
            }
            ArchiveController.cp(file, archiveController, string, file2.getDelegate(), bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void cp(java.io.File file, InputStream inputStream, File file2, ArchiveController archiveController, String string, boolean bl) throws IOException {
        try {
            class OStreamCreator
            implements IORunnable {
                OutputStream out;
                private final /* synthetic */ String val$dstEntryName;
                private final /* synthetic */ java.io.File val$src;
                private final /* synthetic */ boolean val$preserve;

                OStreamCreator(String string, java.io.File file, boolean bl) {
                    this.val$dstEntryName = string;
                    this.val$src = file;
                    this.val$preserve = bl;
                }

                public void run() throws IOException {
                    if (ArchiveController.this.hasNewData(this.val$dstEntryName)) {
                        ArchiveController.this.update();
                    }
                    boolean bl = File.isLenient();
                    File2ArchiveEntryAdapter file2ArchiveEntryAdapter = new File2ArchiveEntryAdapter(this.val$src);
                    ArchiveFileSystem archiveFileSystem = ArchiveController.this.getFileSystem(bl);
                    ArchiveFileSystem.Delta delta = archiveFileSystem.beginCreateAndLink(this.val$dstEntryName, bl, this.val$preserve ? file2ArchiveEntryAdapter : null);
                    ArchiveEntry archiveEntry = delta.getEntry();
                    this.out = ArchiveController.this.getOutputStream(archiveEntry, file2ArchiveEntryAdapter);
                    delta.commit();
                }
            }
            OStreamCreator oStreamCreator = archiveController.new OStreamCreator(string, file, bl);
            archiveController.runWriteLocked(oStreamCreator);
            OutputStream outputStream = oStreamCreator.out;
            try {
                File.cat(inputStream, outputStream);
            }
            finally {
                outputStream.close();
            }
        }
        catch (FalsePositiveDirectoryEntryException falsePositiveDirectoryEntryException) {
            if (!$assertionsDisabled && archiveController != falsePositiveDirectoryEntryException.getSource()) {
                throw new AssertionError();
            }
            ArchiveController.cp(file, inputStream, file2, archiveController.getEnclController(), archiveController.enclEntryName(string), bl);
        }
        catch (FalsePositiveNativeException falsePositiveNativeException) {
            if (!$assertionsDisabled && archiveController != falsePositiveNativeException.getSource()) {
                throw new AssertionError();
            }
            ArchiveController.cp(file, inputStream, file2.getDelegate(), bl);
        }
    }

    static {
        $assertionsDisabled = !ArchiveController.class.desiredAssertionStatus();
        CLASS_NAME = "de/schlichtherle/io/ArchiveController".replace('/', '.');
        logger = Logger.getLogger(CLASS_NAME, CLASS_NAME);
        controllers = new WeakHashMap();
        liveStats = new LiveStatistics();
        copyLock = new CopyLock();
        REVERSE_CONTROLLERS = new Comparator(){

            public int compare(Object object, Object object2) {
                return ((ArchiveController)object2).getTarget().compareTo(((ArchiveController)object).getTarget());
            }
        };
        Runtime.getRuntime().addShutdownHook(ShutdownHook.singleton);
    }

    protected class FalsePositiveDirectoryEntryException
    extends FalsePositiveEntryException {
        protected FalsePositiveDirectoryEntryException(ArchiveController archiveController2, String string) {
            super(archiveController2, string);
        }
    }

    protected class FalsePositiveFileEntryException
    extends FalsePositiveEntryException {
        protected FalsePositiveFileEntryException(ArchiveController archiveController2, String string, IOException iOException) {
            super(archiveController2, string, iOException);
        }
    }

    protected abstract class FalsePositiveEntryException
    extends FalsePositiveException {
        private final ArchiveController target;
        private final String entryName;
        static final /* synthetic */ boolean $assertionsDisabled;

        protected FalsePositiveEntryException(ArchiveController archiveController2, String string) {
            this(archiveController2, string, null);
        }

        protected FalsePositiveEntryException(ArchiveController archiveController2, String string, IOException iOException) {
            super(archiveController2.getPath() + File.separator + string);
            if (!$assertionsDisabled && archiveController2 == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && string == null) {
                throw new AssertionError();
            }
            this.target = archiveController2;
            this.entryName = string;
            if (iOException != null) {
                this.initCause(iOException);
            }
        }

        public ArchiveController getTarget() {
            return this.target;
        }

        public String getEntryName() {
            return this.entryName;
        }

        static {
            $assertionsDisabled = !(class$de$schlichtherle$io$ArchiveController == null ? (class$de$schlichtherle$io$ArchiveController = ArchiveController.class$("de.schlichtherle.io.ArchiveController")) : class$de$schlichtherle$io$ArchiveController).desiredAssertionStatus();
        }
    }

    protected class FalsePositiveNativeException
    extends FalsePositiveException {
        protected FalsePositiveNativeException(IOException iOException) {
            super(ArchiveController.this.getPath());
            this.initCause(iOException);
        }
    }

    protected abstract class FalsePositiveException
    extends FileNotFoundException {
        protected FalsePositiveException(String string) {
            super(string);
        }

        public ArchiveController getSource() {
            return ArchiveController.this;
        }
    }

    private static final class File2ArchiveEntryAdapter
    implements ArchiveEntry {
        private final java.io.File file;
        static final /* synthetic */ boolean $assertionsDisabled;

        private File2ArchiveEntryAdapter(java.io.File file) {
            if (!$assertionsDisabled && file == null) {
                throw new AssertionError();
            }
            this.file = file;
        }

        public String getName() {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Drivers should never call this method!");
            }
            if (this.file.isDirectory()) {
                return this.file.getName() + "/";
            }
            return this.file.getName();
        }

        public boolean isDirectory() {
            return this.file.isDirectory();
        }

        public long getSize() {
            return this.file.length();
        }

        public long getTime() {
            return this.file.lastModified();
        }

        public void setTime(long l) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Drivers should never call this method!");
            }
            this.file.setLastModified(l);
        }

        public Icon getOpenIcon() {
            return null;
        }

        public Icon getClosedIcon() {
            return null;
        }

        public ArchiveEntryMetaData getMetaData() {
            throw new AssertionError((Object)"Drivers should never call this method!");
        }

        public void setMetaData(ArchiveEntryMetaData archiveEntryMetaData) {
            throw new AssertionError((Object)"Drivers should never call this method!");
        }

        static {
            $assertionsDisabled = !(class$de$schlichtherle$io$ArchiveController == null ? (class$de$schlichtherle$io$ArchiveController = ArchiveController.class$("de.schlichtherle.io.ArchiveController")) : class$de$schlichtherle$io$ArchiveController).desiredAssertionStatus();
        }
    }

    protected static final class CountingOutputStream
    extends FilterOutputStream {
        private static volatile long _total;
        private static volatile boolean _resetOnReuse;

        public static long getTotal() {
            return _total;
        }

        private static void setResetOnReuse() {
            _resetOnReuse = true;
        }

        private static void resetOnReuse() {
            if (_resetOnReuse) {
                _resetOnReuse = false;
                _total = 0L;
            }
        }

        protected CountingOutputStream(OutputStream outputStream) {
            super(outputStream);
            CountingOutputStream.resetOnReuse();
        }

        public void write(int n) throws IOException {
            this.out.write(n);
            ++_total;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.out.write(byArray, n, n2);
            _total += (long)n2;
        }
    }

    protected static final class CountingReadOnlyFile
    extends SimpleReadOnlyFile {
        private static volatile long _total;

        public static long getTotal() {
            return _total;
        }

        private static void setResetOnReuse() {
        }

        private static void resetOnReuse() {
            _total = 0L;
        }

        protected CountingReadOnlyFile(java.io.File file) throws FileNotFoundException {
            super(file);
            CountingReadOnlyFile.resetOnReuse();
        }

        public int read() throws IOException {
            int n = super.read();
            if (n != -1) {
                ++_total;
            }
            return n;
        }

        public int read(byte[] byArray) throws IOException {
            int n = super.read(byArray);
            if (n != -1) {
                _total += (long)n;
            }
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = super.read(byArray, n, n2);
            if (n3 != -1) {
                _total += (long)n3;
            }
            return n3;
        }

        public int skipBytes(int n) throws IOException {
            int n2 = super.skipBytes(n);
            _total += (long)n2;
            return n2;
        }
    }

    private static final class ControllerEnumeration
    implements Enumeration {
        private final Iterator it;
        static final /* synthetic */ boolean $assertionsDisabled;

        public ControllerEnumeration() {
            this("", null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ControllerEnumeration(String string, Comparator comparator) {
            AbstractSet abstractSet;
            if (!$assertionsDisabled && string == null) {
                throw new AssertionError();
            }
            Map map = controllers;
            synchronized (map) {
                abstractSet = comparator != null ? new TreeSet(comparator) : new HashSet((int)((float)controllers.size() / 0.75f));
                Iterator iterator = controllers.values().iterator();
                while (iterator.hasNext()) {
                    Object object = iterator.next();
                    if (object instanceof Reference) {
                        if ((object = ((Reference)object).get()) == null) continue;
                        if (!$assertionsDisabled && !(object instanceof ArchiveController)) {
                            throw new AssertionError();
                        }
                        if (((ArchiveController)object).getPath().startsWith(string)) {
                            // empty if block
                        }
                        abstractSet.add(object);
                        continue;
                    }
                    if (!$assertionsDisabled && object == null) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !(object instanceof ArchiveController)) {
                        throw new AssertionError();
                    }
                    if (((ArchiveController)object).getPath().startsWith(string)) {
                        // empty if block
                    }
                    abstractSet.add(object);
                }
            }
            this.it = abstractSet.iterator();
        }

        public boolean hasMoreElements() {
            return this.it.hasNext();
        }

        public Object nextElement() {
            return this.it.next();
        }

        static {
            $assertionsDisabled = !(class$de$schlichtherle$io$ArchiveController == null ? (class$de$schlichtherle$io$ArchiveController = ArchiveController.class$("de.schlichtherle.io.ArchiveController")) : class$de$schlichtherle$io$ArchiveController).desiredAssertionStatus();
        }
    }

    private static final class LiveStatistics
    implements ArchiveStatistics {
        private LiveStatistics() {
        }

        public long getUpdateTotalByteCountRead() {
            return CountingReadOnlyFile.getTotal();
        }

        public long getUpdateTotalByteCountWritten() {
            return CountingOutputStream.getTotal();
        }

        public int getArchivesTotal() {
            return controllers.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getArchivesTouched() {
            int n = 0;
            ControllerEnumeration controllerEnumeration = new ControllerEnumeration();
            while (controllerEnumeration.hasMoreElements()) {
                ArchiveController archiveController = (ArchiveController)controllerEnumeration.nextElement();
                archiveController.readLock().lock();
                try {
                    if (!archiveController.isTouched()) continue;
                    ++n;
                }
                finally {
                    archiveController.readLock().unlock();
                }
            }
            return n;
        }

        public int getTopLevelArchivesTotal() {
            int n = 0;
            ControllerEnumeration controllerEnumeration = new ControllerEnumeration();
            while (controllerEnumeration.hasMoreElements()) {
                ArchiveController archiveController = (ArchiveController)controllerEnumeration.nextElement();
                if (archiveController.getEnclController() != null) continue;
                ++n;
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getTopLevelArchivesTouched() {
            int n = 0;
            ControllerEnumeration controllerEnumeration = new ControllerEnumeration();
            while (controllerEnumeration.hasMoreElements()) {
                ArchiveController archiveController = (ArchiveController)controllerEnumeration.nextElement();
                archiveController.readLock().lock();
                try {
                    if (archiveController.getEnclController() != null || !archiveController.isTouched()) continue;
                    ++n;
                }
                finally {
                    archiveController.readLock().unlock();
                }
            }
            return n;
        }
    }

    static final class ShutdownHook
    extends Thread {
        private static final ShutdownHook singleton = new ShutdownHook();
        static final Set deleteOnExit = Collections.synchronizedSet(new LinkedHashSet());

        private ShutdownHook() {
            super("TrueZIP ArchiveController Shutdown Hook");
            this.setPriority(10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Class clazz = class$de$schlichtherle$key$PromptingKeyManager == null ? (class$de$schlichtherle$key$PromptingKeyManager = ArchiveController.class$("de.schlichtherle.key.PromptingKeyManager")) : class$de$schlichtherle$key$PromptingKeyManager;
            synchronized (clazz) {
                try {
                    PromptingKeyManager.setPrompting(false);
                    logger.setLevel(Level.OFF);
                    Iterator iterator = deleteOnExit.iterator();
                    while (iterator.hasNext()) {
                        File file = (File)iterator.next();
                        if (!file.exists() || file.delete()) continue;
                        System.err.println(file.getPath() + ": failed to deleteOnExit()!");
                    }
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    try {
                        ArchiveController.updateAll("", false, true, false, true, false, false);
                    }
                    catch (ArchiveException archiveException) {
                        archiveException.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    ArchiveController.updateAll("", false, true, false, true, false, false);
                }
                catch (ArchiveException archiveException) {
                    archiveException.printStackTrace();
                }
            }
        }
    }

    private static final class CopyLock {
        private CopyLock() {
        }
    }

    protected static interface IORunnable {
        public void run() throws IOException;
    }
}

