/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.ArchiveBusyException;
import de.schlichtherle.io.ArchiveController;
import de.schlichtherle.io.File;
import de.schlichtherle.io.FileBusyException;
import de.schlichtherle.io.archive.spi.InputArchiveBusyException;
import de.schlichtherle.io.archive.spi.OutputArchiveBusyException;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileInputStream
extends FilterInputStream {
    static final /* synthetic */ boolean $assertionsDisabled;

    private static InputStream createInputStream(java.io.File file) throws FileNotFoundException {
        if (file instanceof File) {
            File file2 = (File)file;
            if (file2.isArchive() && (file2.isDirectory() || file2.exists() && !file2.isFile())) {
                throw new FileNotFoundException(file.getPath() + " (cannot read possibly inaccessible archive file)");
            }
            String string = file2.getEnclEntryName();
            if (string != null) {
                return FileInputStream.createInputStream(file2.getEnclArchive().getArchiveController(), string, file2);
            }
        }
        return new java.io.FileInputStream(file);
    }

    private static InputStream createInputStream(ArchiveController archiveController, String string, File file) throws FileNotFoundException {
        try {
            return archiveController.getInputStream(string);
        }
        catch (ArchiveController.FalsePositiveDirectoryEntryException falsePositiveDirectoryEntryException) {
            return FileInputStream.createInputStream(archiveController.getEnclController(), archiveController.enclEntryName(string), file);
        }
        catch (ArchiveController.FalsePositiveNativeException falsePositiveNativeException) {
            java.io.File file2 = file.getDelegate();
            if (file2.exists() && !file2.isDirectory()) {
                return new java.io.FileInputStream(file);
            }
            throw falsePositiveNativeException;
        }
        catch (InputArchiveBusyException inputArchiveBusyException) {
            throw new FileBusyException(inputArchiveBusyException);
        }
        catch (OutputArchiveBusyException outputArchiveBusyException) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            throw new FileBusyException(outputArchiveBusyException);
        }
        catch (ArchiveBusyException archiveBusyException) {
            throw new FileBusyException(archiveBusyException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            FileNotFoundException fileNotFoundException = new FileNotFoundException(file.getPath());
            fileNotFoundException.initCause(iOException);
            throw fileNotFoundException;
        }
    }

    public FileInputStream(String string) throws FileNotFoundException {
        super(FileInputStream.createInputStream(File.getDefaultArchiveDetector().createFile(string)));
    }

    public FileInputStream(java.io.File file) throws FileNotFoundException {
        super(FileInputStream.createInputStream(file));
    }

    public int read(byte[] byArray) throws IOException {
        return this.in.read(byArray, 0, byArray.length);
    }

    static {
        $assertionsDisabled = !FileInputStream.class.desiredAssertionStatus();
    }
}

