/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.key.passwd.swing;

import de.schlichtherle.key.KeyPromptingDisabledException;
import de.schlichtherle.key.passwd.swing.PromptingAesKeyProviderUI;
import de.schlichtherle.key.passwd.swing.PromptingKeyProviderUI;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Window;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.JOptionPane;

public class PromptingKeyManager
extends de.schlichtherle.key.PromptingKeyManager {
    private static Reference parent;

    public PromptingKeyManager() {
        this.mapPromptingKeyProviderUIType("de.schlichtherle.key.PromptingKeyProvider", PromptingKeyProviderUI.class);
        this.mapPromptingKeyProviderUIType("de.schlichtherle.key.PromptingAesKeyProvider", PromptingAesKeyProviderUI.class);
    }

    public static synchronized Window getParentWindow() {
        Window window = null;
        if (parent != null) {
            window = (Window)parent.get();
        }
        if (window == null) {
            window = PromptingKeyManager.searchActiveWindow(Frame.getFrames());
        }
        if (window == null) {
            window = JOptionPane.getRootFrame();
        }
        for (Container container = window; container != null; container = container.getParent()) {
            if (!(container instanceof Window) || !container.isVisible()) continue;
            return container;
        }
        return window;
    }

    private static Window searchActiveWindow(Window[] windowArray) {
        int n = windowArray.length;
        for (int i = 0; i < n; ++i) {
            Window window = windowArray[i];
            if (window.isActive()) {
                return window;
            }
            if ((window = PromptingKeyManager.searchActiveWindow(window.getOwnedWindows())) == null) continue;
            return window;
        }
        return null;
    }

    public static synchronized void setParentWindow(Window window) {
        parent = window != null ? new WeakReference<Window>(window) : null;
    }

    protected boolean isPromptingImpl() {
        return super.isPromptingImpl() && !GraphicsEnvironment.isHeadless();
    }

    protected void ensurePromptingImpl() throws KeyPromptingDisabledException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new KeyPromptingDisabledException(new HeadlessException());
        }
        super.ensurePromptingImpl();
    }
}

