/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.swing;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public abstract class AbstractComboBoxBrowser
implements Serializable {
    private final Listener listener = new Listener();
    private JComboBox comboBox;
    private String lastInitials;
    private transient boolean recursion;

    public AbstractComboBoxBrowser() {
    }

    public AbstractComboBoxBrowser(JComboBox jComboBox) {
        this.comboBoxChanged(null, jComboBox);
    }

    public JComboBox getComboBox() {
        return this.comboBox;
    }

    public void setComboBox(JComboBox jComboBox) {
        this.comboBoxChanged(this.getComboBox(), jComboBox);
    }

    private void comboBoxChanged(JComboBox jComboBox, JComboBox jComboBox2) {
        if (jComboBox2 == jComboBox) {
            return;
        }
        ComboBoxEditor comboBoxEditor = null;
        if (jComboBox != null) {
            comboBoxEditor = jComboBox.getEditor();
            jComboBox.setEditor(((ComboBoxEditorProxy)comboBoxEditor).getEditor());
            jComboBox.removePropertyChangeListener("editor", this.listener);
        }
        this.comboBox = jComboBox2;
        ComboBoxEditorProxy comboBoxEditorProxy = null;
        if (jComboBox2 != null) {
            jComboBox2.updateUI();
            comboBoxEditorProxy = new ComboBoxEditorProxy(jComboBox2.getEditor());
            jComboBox2.setEditor(comboBoxEditorProxy);
            jComboBox2.addPropertyChangeListener("editor", this.listener);
        }
        this.editorChanged(comboBoxEditor, comboBoxEditorProxy);
    }

    private void editorChanged(ComboBoxEditor comboBoxEditor, ComboBoxEditor comboBoxEditor2) {
        Component component;
        Component component2;
        if (comboBoxEditor2 == comboBoxEditor) {
            return;
        }
        JTextComponent jTextComponent = null;
        if (comboBoxEditor != null && (component2 = comboBoxEditor.getEditorComponent()) instanceof JTextComponent) {
            jTextComponent = (JTextComponent)component2;
        }
        component2 = null;
        if (comboBoxEditor2 != null && (component = comboBoxEditor2.getEditorComponent()) instanceof JTextComponent) {
            component2 = (JTextComponent)component;
        }
        this.textChanged(jTextComponent, (JTextComponent)component2);
    }

    private void textChanged(JTextComponent jTextComponent, JTextComponent jTextComponent2) {
        if (jTextComponent2 == jTextComponent) {
            return;
        }
        Document document = null;
        if (jTextComponent != null) {
            jTextComponent.removePropertyChangeListener("document", this.listener);
            document = jTextComponent.getDocument();
        }
        Document document2 = null;
        if (jTextComponent2 != null) {
            jTextComponent2.addPropertyChangeListener("document", this.listener);
            document2 = jTextComponent2.getDocument();
        }
        this.documentChanged(document, document2);
    }

    private void documentChanged(Document document, Document document2) {
        if (document2 == document) {
            return;
        }
        if (document != null) {
            document.removeDocumentListener(this.listener);
        }
        if (document2 != null) {
            document2.addDocumentListener(this.listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void documentUpdated() {
        if (this.lock()) {
            return;
        }
        try {
            JComboBox jComboBox = this.getComboBox();
            ComboBoxEditorProxy comboBoxEditorProxy = (ComboBoxEditorProxy)jComboBox.getEditor();
            JTextComponent jTextComponent = (JTextComponent)comboBoxEditorProxy.getEditorComponent();
            if (!jTextComponent.hasFocus()) {
                return;
            }
            String string = jTextComponent.getText();
            jComboBox.setPopupVisible(false);
            if (this.updateConditionally(string)) {
                ComboBoxModel comboBoxModel = jComboBox.getModel();
                if (!string.equals(comboBoxModel.getSelectedItem())) {
                    comboBoxModel.setSelectedItem(string);
                }
                jComboBox.setPopupVisible(true);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEditor(ComboBoxEditor comboBoxEditor, Object object) {
        if (this.lock()) {
            return;
        }
        try {
            comboBoxEditor.setItem(object);
            if (!(object instanceof String)) {
                return;
            }
            JTextComponent jTextComponent = (JTextComponent)comboBoxEditor.getEditorComponent();
            if (!jTextComponent.hasFocus()) {
                return;
            }
            Caret caret = jTextComponent.getCaret();
            caret.setDot(((String)object).length());
        }
        finally {
            this.unlock();
        }
    }

    private final boolean updateConditionally(String string) {
        if (string.equals(this.lastInitials)) {
            return false;
        }
        return this.update(string);
    }

    protected abstract boolean update(String var1);

    private final boolean lock() {
        if (this.recursion) {
            return true;
        }
        this.recursion = true;
        return false;
    }

    private final void unlock() {
        this.recursion = false;
    }

    private final class ComboBoxEditorProxy
    extends BasicComboBoxEditor
    implements ComboBoxEditor {
        private final ComboBoxEditor comboBoxEditor;

        public ComboBoxEditorProxy(ComboBoxEditor comboBoxEditor) {
            this.comboBoxEditor = comboBoxEditor;
        }

        public ComboBoxEditor getEditor() {
            return this.comboBoxEditor;
        }

        public Component getEditorComponent() {
            return this.comboBoxEditor.getEditorComponent();
        }

        public void setItem(Object object) {
            AbstractComboBoxBrowser.this.updateEditor(this.comboBoxEditor, object);
        }

        public Object getItem() {
            return this.comboBoxEditor.getItem();
        }

        public void selectAll() {
            this.comboBoxEditor.selectAll();
        }

        public void addActionListener(ActionListener actionListener) {
            this.comboBoxEditor.addActionListener(actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            this.comboBoxEditor.removeActionListener(actionListener);
        }
    }

    private final class Listener
    implements DocumentListener,
    PropertyChangeListener {
        private Listener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            AbstractComboBoxBrowser.this.documentUpdated();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            AbstractComboBoxBrowser.this.documentUpdated();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            AbstractComboBoxBrowser.this.documentUpdated();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("editor".equals(string)) {
                AbstractComboBoxBrowser.this.editorChanged((ComboBoxEditor)propertyChangeEvent.getOldValue(), (ComboBoxEditor)propertyChangeEvent.getNewValue());
            } else if ("document".equals(string)) {
                AbstractComboBoxBrowser.this.documentChanged((Document)propertyChangeEvent.getOldValue(), (Document)propertyChangeEvent.getNewValue());
            } else {
                throw new AssertionError((Object)("Received change event for unknown property: " + string));
            }
        }
    }
}

