/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GCanvas;
import acm.graphics.GContainer;
import acm.graphics.GIterator;
import acm.graphics.GMath;
import acm.graphics.GObject;
import acm.graphics.GObjectList;
import acm.graphics.GPoint;
import acm.graphics.GRectangle;
import acm.graphics.GScalable;
import acm.util.ErrorException;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.Iterator;

public class GCompound
extends GObject
implements GContainer,
GScalable {
    private boolean complete = false;
    private GObjectList contents = new GObjectList(this);
    private GObject lastObject;
    private GObject dragObject;
    static final long serialVersionUID = 1L;

    @Override
    public void add(GObject gobj) {
        if (this.complete) {
            throw new ErrorException("You can't add objects to a GCompound that has been marked as complete.");
        }
        this.contents.add(gobj);
        this.repaint();
    }

    @Override
    public final void add(GObject gobj, double x, double y) {
        gobj.setLocation(x, y);
        this.add(gobj);
    }

    @Override
    public final void add(GObject gobj, GPoint pt) {
        this.add(gobj, pt.getX(), pt.getY());
    }

    @Override
    public void remove(GObject gobj) {
        if (this.complete) {
            throw new ErrorException("You can't remove objects from a GCompound that has been marked as complete.");
        }
        this.contents.remove(gobj);
        this.repaint();
    }

    @Override
    public void removeAll() {
        if (this.complete) {
            throw new ErrorException("You can't remove objects from a GCompound that has been marked as complete.");
        }
        this.contents.removeAll();
        this.repaint();
    }

    @Override
    public int getElementCount() {
        return this.contents.getElementCount();
    }

    @Override
    public GObject getElement(int index) {
        return this.contents.getElement(index);
    }

    @Override
    public GObject getElementAt(double x, double y) {
        return this.contents.getElementAt(x, y, false);
    }

    @Override
    public final GObject getElementAt(GPoint pt) {
        return this.getElementAt(pt.getX(), pt.getY());
    }

    public Iterator<GObject> iterator() {
        return new GIterator(this, 0);
    }

    public Iterator<GObject> iterator(int direction) {
        return new GIterator(this, direction);
    }

    @Override
    public void paint(Graphics g) {
        g = g.create();
        g.translate(GMath.round(this.getX()), GMath.round(this.getY()));
        this.contents.mapPaint(g);
    }

    @Override
    public void scale(double sx, double sy) {
        Component comp = this.getComponent();
        boolean oldAutoRepaint = false;
        if (comp instanceof GCanvas) {
            oldAutoRepaint = ((GCanvas)comp).getAutoRepaintFlag();
            ((GCanvas)comp).setAutoRepaintFlag(false);
        }
        for (int i = this.getElementCount() - 1; i >= 0; --i) {
            GObject gobj = this.getElement(i);
            gobj.setLocation(sx * gobj.getX(), sy * gobj.getY());
            if (!(gobj instanceof GScalable)) continue;
            ((GScalable)((Object)gobj)).scale(sx, sy);
        }
        if (comp instanceof GCanvas) {
            ((GCanvas)comp).setAutoRepaintFlag(oldAutoRepaint);
        }
        this.repaint();
    }

    @Override
    public final void scale(double sf) {
        this.scale(sf, sf);
    }

    @Override
    public GRectangle getBounds() {
        GRectangle bounds = this.contents.getBounds();
        bounds.translate(this.getX(), this.getY());
        return bounds;
    }

    @Override
    public boolean contains(double x, double y) {
        return this.contents.contains(x - this.getX(), y - this.getY());
    }

    public final GPoint getCanvasPoint(GPoint localPoint) {
        return this.getCanvasPoint(localPoint.getX(), localPoint.getY());
    }

    public GPoint getCanvasPoint(double x, double y) {
        GContainer c = this;
        while (c instanceof GCompound) {
            GCompound comp = c;
            x += comp.getX();
            y += comp.getY();
            c = comp.getParent();
        }
        return new GPoint(x, y);
    }

    public final GPoint getLocalPoint(GPoint canvasPoint) {
        return this.getLocalPoint(canvasPoint.getX(), canvasPoint.getY());
    }

    public GPoint getLocalPoint(double x, double y) {
        GContainer c = this;
        while (c instanceof GCompound) {
            GCompound comp = c;
            x -= comp.getX();
            y -= comp.getY();
            c = comp.getParent();
        }
        return new GPoint(x, y);
    }

    public void markAsComplete() {
        this.complete = true;
    }

    protected void sendToFront(GObject gobj) {
        this.contents.sendToFront(gobj);
        this.repaint();
    }

    protected void sendToBack(GObject gobj) {
        this.contents.sendToBack(gobj);
        this.repaint();
    }

    protected void sendForward(GObject gobj) {
        this.contents.sendForward(gobj);
        this.repaint();
    }

    protected void sendBackward(GObject gobj) {
        this.contents.sendBackward(gobj);
        this.repaint();
    }

    @Override
    protected void fireMouseListeners(MouseEvent e) {
        int id;
        if (super.areMouseListenersEnabled()) {
            super.fireMouseListeners(e);
            return;
        }
        GPoint pt = new GPoint((double)e.getX() - this.getX(), (double)e.getY() - this.getY());
        GObject gobj = this.getElementAt(pt);
        MouseEvent newEvent = null;
        if (gobj != this.lastObject) {
            if (this.lastObject != null) {
                newEvent = GCanvas.createMouseEvent(this.lastObject, 505, e);
                this.lastObject.fireMouseListeners(newEvent);
            }
            if (gobj != null) {
                newEvent = GCanvas.createMouseEvent(gobj, 504, e);
                gobj.fireMouseListeners(newEvent);
            }
        }
        this.lastObject = gobj;
        if (this.dragObject != null) {
            gobj = this.dragObject;
        }
        if (gobj != null && (id = e.getID()) != 505 && id != 504) {
            if (id == 501) {
                this.dragObject = gobj;
            } else if (id == 502) {
                this.dragObject = null;
            }
            newEvent = GCanvas.createMouseEvent(gobj, id, e);
            gobj.fireMouseListeners(newEvent);
        }
        if (newEvent != null && newEvent.isConsumed()) {
            e.consume();
        }
    }

    @Override
    protected boolean areMouseListenersEnabled() {
        if (super.areMouseListenersEnabled()) {
            return true;
        }
        return this.contents.areMouseListenersEnabled();
    }
}

