/*
 * Decompiled with CFR 0.152.
 */
package cpusim;

import cpusim.BreakException;
import cpusim.ExecutionException;
import cpusim.Field;
import cpusim.IOChannel;
import cpusim.MachineInstruction;
import cpusim.Microinstruction;
import cpusim.Module;
import cpusim.SwingWorker;
import cpusim.assembler.PunctChar;
import cpusim.microinstruction.Arithmetic;
import cpusim.microinstruction.Comment;
import cpusim.microinstruction.Decode;
import cpusim.microinstruction.End;
import cpusim.microinstruction.IO;
import cpusim.microinstruction.Increment;
import cpusim.microinstruction.MemoryAccess;
import cpusim.microinstruction.SetCondBit;
import cpusim.module.ConditionBit;
import cpusim.module.ControlUnit;
import cpusim.module.RAM;
import cpusim.module.Register;
import cpusim.module.RegisterArray;
import cpusim.util.Assert;
import cpusim.util.CPUSimConstants;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class Machine
extends Module
implements Serializable,
CPUSimConstants {
    public static final String[] MICRO_CLASSES = new String[]{"arithmetic", "branch", "decode", "end", "increment", "io", "logical", "memoryAccess", "set", "setCondBit", "shift", "test", "transferRtoR", "transferRtoA", "transferAtoR"};
    private Vector<Register> registers = new Vector();
    private Vector<RegisterArray> registerArrays = new Vector();
    private Vector<ConditionBit> conditionBits = new Vector();
    private Vector<RAM> rams = new Vector();
    private List<MachineInstruction> instructions;
    private Vector EQUs;
    private HashMap<String, Vector<Microinstruction>> microMap;
    private HashMap<String, Vector> moduleMap = new HashMap();
    private ControlUnit controlUnit;
    private MachineInstruction fetchSequence;
    private boolean isDirty = false;
    private File file = null;
    private volatile int runMode;
    private List<Field> fields;
    private PunctChar[] punctChars;
    private int startingAddressForLoading = 0;
    private RAM codeStore = null;
    private SwingWorker swingWorker;

    public Machine(String name) {
        super(name);
        this.microMap = new HashMap();
        this.instructions = new ArrayList<MachineInstruction>();
        this.EQUs = new Vector();
        this.fields = new ArrayList<Field>();
        this.punctChars = this.getDefaultPunctChars();
        this.fetchSequence = new MachineInstruction("Fetch sequence", 0L, "", this);
        this.controlUnit = new ControlUnit("ControlUnit", this);
        this.initializeModuleMap();
        this.initializeMicroMap();
    }

    public PunctChar[] getDefaultPunctChars() {
        return new PunctChar[]{new PunctChar('!', PunctChar.Use.symbol), new PunctChar('#', PunctChar.Use.symbol), new PunctChar('$', PunctChar.Use.symbol), new PunctChar('%', PunctChar.Use.symbol), new PunctChar('&', PunctChar.Use.symbol), new PunctChar('^', PunctChar.Use.symbol), new PunctChar('_', PunctChar.Use.symbol), new PunctChar('`', PunctChar.Use.symbol), new PunctChar('*', PunctChar.Use.symbol), new PunctChar('?', PunctChar.Use.symbol), new PunctChar('@', PunctChar.Use.symbol), new PunctChar('~', PunctChar.Use.symbol), new PunctChar('+', PunctChar.Use.symbol), new PunctChar('-', PunctChar.Use.symbol), new PunctChar('(', PunctChar.Use.token), new PunctChar(')', PunctChar.Use.token), new PunctChar(',', PunctChar.Use.token), new PunctChar('/', PunctChar.Use.token), new PunctChar('=', PunctChar.Use.token), new PunctChar('[', PunctChar.Use.token), new PunctChar('\\', PunctChar.Use.token), new PunctChar(']', PunctChar.Use.token), new PunctChar('{', PunctChar.Use.token), new PunctChar('|', PunctChar.Use.token), new PunctChar('}', PunctChar.Use.token), new PunctChar('.', PunctChar.Use.pseudo), new PunctChar(':', PunctChar.Use.label), new PunctChar(';', PunctChar.Use.comment)};
    }

    public PunctChar[] getPunctChars() {
        return this.punctChars;
    }

    public void setPunctChars(PunctChar[] punctChars) {
        this.punctChars = punctChars;
    }

    public char getLabelChar() {
        for (PunctChar c : this.punctChars) {
            if (c.getUse() != PunctChar.Use.label) continue;
            return c.getChar();
        }
        Assert.That(false, "No label char found in the machine's punctChars");
        return ':';
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public void setFields(List<Field> f) {
        this.fields = f;
    }

    public Vector getModule(String moduleType) {
        return this.moduleMap.get(moduleType);
    }

    public Vector<Microinstruction> getMicros(String micro) {
        return this.microMap.get(micro);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File newFile) {
        this.file = newFile;
    }

    public List<MachineInstruction> getInstructions() {
        return this.instructions;
    }

    public Vector getEQUs() {
        return this.EQUs;
    }

    public End getEnd() {
        return (End)this.microMap.get("end").elementAt(0);
    }

    public int getStartingAddressForLoading() {
        return this.startingAddressForLoading;
    }

    public RAM getCodeStore() {
        return this.codeStore;
    }

    public void setCodeStore(RAM r) {
        this.codeStore = r;
    }

    public void setStartingAddressForLoading(int add) {
        this.startingAddressForLoading = add;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    private void initializeModuleMap() {
        this.moduleMap.put("registers", this.registers);
        this.moduleMap.put("registerArrays", this.registerArrays);
        this.moduleMap.put("conditionBits", this.conditionBits);
        this.moduleMap.put("rams", this.rams);
    }

    private void initializeMicroMap() {
        for (String aMicroClass : MICRO_CLASSES) {
            this.microMap.put(aMicroClass, new Vector());
        }
        this.microMap.get("end").addElement(new End(this));
    }

    public void copyFrom(Machine newMachine) {
        if (newMachine.equals(this)) {
            return;
        }
        this.registers.clear();
        this.registers.addAll(newMachine.registers);
        this.registerArrays.clear();
        this.registerArrays.addAll(newMachine.registerArrays);
        this.conditionBits.clear();
        this.conditionBits.addAll(newMachine.conditionBits);
        this.rams.clear();
        this.rams.addAll(newMachine.rams);
        this.fields.clear();
        this.fields.addAll(newMachine.fields);
        for (String aMicroClass : MICRO_CLASSES) {
            Vector<Microinstruction> newMicros = newMachine.microMap.get(aMicroClass);
            this.microMap.put(aMicroClass, newMicros);
        }
        this.instructions = newMachine.instructions;
        for (MachineInstruction instr : this.instructions) {
            instr.setMachine(this);
        }
        this.EQUs = newMachine.EQUs;
        this.controlUnit = newMachine.controlUnit;
        this.fetchSequence = newMachine.fetchSequence;
        this.isDirty = newMachine.isDirty;
        this.file = newMachine.file;
        this.codeStore = newMachine.codeStore;
        this.startingAddressForLoading = newMachine.startingAddressForLoading;
        this.setName(newMachine.getName());
        this.punctChars = newMachine.punctChars;
        this.getEnd().setMachine(this);
        for (int i = 0; i < this.getMicros("decode").size(); ++i) {
            ((Decode)this.getMicros("decode").elementAt(i)).setMachine(this);
        }
    }

    public Vector getAllRegisters() {
        Vector allRegisters = (Vector)this.registers.clone();
        for (int i = 0; i < this.registerArrays.size(); ++i) {
            Register[] registers;
            for (Register register : registers = this.registerArrays.elementAt(i).registers()) {
                allRegisters.addElement(register);
            }
        }
        return allRegisters;
    }

    public void setInstructions(List<MachineInstruction> newInstructions) {
        this.instructions = newInstructions;
    }

    public void setEQUs(Vector newEQUs) {
        this.EQUs = newEQUs;
    }

    public void setRegisters(Vector<Register> newRegisters) {
        for (int i = 0; i < this.registers.size(); ++i) {
            Register oldRegister = this.registers.elementAt(i);
            if (newRegisters.contains(oldRegister)) continue;
            HashMap microsThatUseIt = this.getMicrosThatUse(oldRegister);
            Set e = microsThatUseIt.keySet();
            for (Object anE : e) {
                Microinstruction micro = (Microinstruction)anE;
                this.removeAllOccurencesOf(micro);
                ((Vector)microsThatUseIt.get(micro)).removeElement(micro);
            }
        }
        this.registers.clear();
        this.registers.addAll(newRegisters);
    }

    public void setRegisterArrays(Vector<RegisterArray> newRegisterArrays) {
        for (int i = 0; i < this.registerArrays.size(); ++i) {
            RegisterArray oldArray = this.registerArrays.elementAt(i);
            if (newRegisterArrays.contains(oldArray)) continue;
            HashMap microsThatUseIt = this.getMicrosThatUse(oldArray);
            Set e = microsThatUseIt.keySet();
            for (Object anE : e) {
                Microinstruction micro = (Microinstruction)anE;
                this.removeAllOccurencesOf(micro);
                ((Vector)microsThatUseIt.get(micro)).removeElement(micro);
            }
        }
        this.registerArrays.clear();
        this.registerArrays.addAll(newRegisterArrays);
    }

    public HashMap getMicrosThatUse(Module m) {
        HashMap<Microinstruction, Vector<Microinstruction>> result = new HashMap<Microinstruction, Vector<Microinstruction>>();
        for (String aMicroClass : MICRO_CLASSES) {
            Vector<Microinstruction> v = this.microMap.get(aMicroClass);
            for (int i = v.size() - 1; i >= 0; --i) {
                Microinstruction micro = v.elementAt(i);
                if (!micro.uses(m)) continue;
                result.put(micro, v);
            }
        }
        return result;
    }

    public void setEnd(End end2) {
        Vector<Microinstruction> ends = this.microMap.get("end");
        ends.clear();
        ends.addElement(end2);
    }

    public void setConditionBits(Vector<ConditionBit> newConditionBits) {
        Microinstruction micro;
        int i;
        for (i = this.getMicros("arithmetic").size() - 1; i >= 0; --i) {
            micro = (Arithmetic)this.getMicros("arithmetic").elementAt(i);
            if ((newConditionBits.contains(((Arithmetic)micro).getOverflowBit()) || ((Arithmetic)micro).getOverflowBit() == NO_CONDITIONBIT) && (newConditionBits.contains(((Arithmetic)micro).getCarryBit()) || ((Arithmetic)micro).getCarryBit() == NO_CONDITIONBIT)) continue;
            this.removeAllOccurencesOf(micro);
            this.getMicros("arithmetic").removeElement(micro);
        }
        for (i = this.getMicros("setCondBit").size() - 1; i >= 0; --i) {
            micro = (SetCondBit)this.getMicros("setCondBit").elementAt(i);
            if (newConditionBits.contains(((SetCondBit)micro).getBit())) continue;
            this.removeAllOccurencesOf(micro);
            this.getMicros("setCondBit").removeElement(micro);
        }
        for (i = this.getMicros("increment").size() - 1; i >= 0; --i) {
            micro = (Increment)this.getMicros("increment").elementAt(i);
            if (newConditionBits.contains(((Increment)micro).getOverflowBit()) || ((Increment)micro).getOverflowBit() == NO_CONDITIONBIT) continue;
            this.removeAllOccurencesOf(micro);
            this.getMicros("increment").removeElement(micro);
        }
        this.conditionBits.clear();
        this.conditionBits.addAll(newConditionBits);
    }

    public void setRAMs(Vector<RAM> newRams) {
        for (int i = this.getMicros("memoryAccess").size() - 1; i >= 0; --i) {
            MemoryAccess access = (MemoryAccess)this.getMicros("memoryAccess").get(i);
            if (newRams.contains(access.getMemory())) continue;
            this.removeAllOccurencesOf(access);
            this.getMicros("memoryAccess").removeElement(access);
        }
        this.rams.clear();
        this.rams.addAll(newRams);
    }

    public void setMicros(String microClass, Vector<Microinstruction> newMicros) {
        Vector<Microinstruction> oldMicros = this.microMap.get(microClass);
        for (int i = 0; i < oldMicros.size(); ++i) {
            Microinstruction oldMicro = oldMicros.elementAt(i);
            if (newMicros.contains(oldMicro)) continue;
            this.removeAllOccurencesOf(oldMicro);
        }
        this.microMap.put(microClass, newMicros);
    }

    public void setDirty(boolean value) {
        this.isDirty = value;
    }

    public boolean contains(Microinstruction micro) {
        for (String microClass : MICRO_CLASSES) {
            Vector<Microinstruction> v = this.microMap.get(microClass);
            if (!v.contains(micro)) continue;
            return true;
        }
        return false;
    }

    public void resetAllChannels() {
        Vector<Microinstruction> ios = this.getMicros("io");
        for (int i = 0; i < ios.size(); ++i) {
            ((IO)ios.elementAt(i)).getConnection().reset();
        }
    }

    public void resetAllChannelsButConsole() {
        Vector<Microinstruction> ios = this.getMicros("io");
        for (int i = 0; i < ios.size(); ++i) {
            IOChannel channel = ((IO)ios.elementAt(i)).getConnection();
            if (channel == CONSOLE_CHANNEL) continue;
            channel.reset();
        }
    }

    public void clearAllRegisters() {
        Vector registers = this.getModule("registers");
        for (int i = 0; i < registers.size(); ++i) {
            ((Register)registers.elementAt(i)).clear();
        }
    }

    public void clearAllRegisterArrays() {
        for (int i = 0; i < this.getModule("registerArrays").size(); ++i) {
            ((RegisterArray)this.getModule("registerArrays").elementAt(i)).clear();
        }
    }

    public void clearAllRAMs() {
        for (int i = 0; i < this.getModule("rams").size(); ++i) {
            ((RAM)this.getModule("rams").elementAt(i)).clear();
        }
    }

    public Vector getInstructionsThatUse(Microinstruction m) {
        Vector<MachineInstruction> result = new Vector<MachineInstruction>();
        for (MachineInstruction instr : this.instructions) {
            if (!instr.usesMicro(m)) continue;
            result.addElement(instr);
        }
        if (this.fetchSequence.usesMicro(m)) {
            result.addElement(this.fetchSequence);
        }
        return result;
    }

    public List<MachineInstruction> getInstructionsThatUse(Field f) {
        ArrayList<MachineInstruction> result = new ArrayList<MachineInstruction>();
        for (MachineInstruction instr : this.instructions) {
            if (!instr.usesField(f)) continue;
            result.add(instr);
        }
        return result;
    }

    public void removeAllOccurencesOf(Microinstruction m) {
        for (MachineInstruction instr : this.instructions) {
            instr.removeMicro(m);
        }
        this.fetchSequence.removeMicro(m);
    }

    public ControlUnit getControlUnit() {
        return this.controlUnit;
    }

    public MachineInstruction getFetchSequence() {
        return this.fetchSequence;
    }

    public void setFetchSequence(MachineInstruction f) {
        this.fetchSequence = f;
    }

    public void setRunMode(int newRunMode) {
        this.runMode = newRunMode;
    }

    public int getRunMode() {
        return this.runMode;
    }

    public void interruptExecutionThread() {
        this.swingWorker.interrupt();
    }

    public void execute(final int mode) {
        this.setRunMode(mode);
        this.getChangeSupport().firePropertyChange("start of execute thread", true, false);
        this.swingWorker = new SwingWorker(){

            @Override
            public Object construct() {
                while (Machine.this.runMode != 4 && Machine.this.runMode != 5 && Machine.this.haltBitsThatAreSet().size() == 0) {
                    int currentIndex = Machine.this.controlUnit.getMicroIndex();
                    if (currentIndex < 0 || currentIndex >= Machine.this.controlUnit.getCurrentInstruction().getMicros().size()) {
                        Machine.this.getChangeSupport().firePropertyChange("exception thrown", null, "The step is out of range\nat step " + currentIndex + " of " + Machine.this.controlUnit.getCurrentInstruction() + ".\n");
                        break;
                    }
                    if (Machine.this.runMode != 0 && currentIndex == 0 && Machine.this.controlUnit.getCurrentInstruction() == Machine.this.getFetchSequence()) {
                        Machine.this.getChangeSupport().firePropertyChange("start of machine cycle", true, false);
                    }
                    MachineInstruction currentInstruction = Machine.this.controlUnit.getCurrentInstruction();
                    List<Microinstruction> microInstructions = currentInstruction.getMicros();
                    Microinstruction currentMicro = microInstructions.get(currentIndex);
                    if (currentIndex < microInstructions.size()) {
                        Machine.this.getChangeSupport().firePropertyChange("start of microinstruction", (Object)true, Machine.this.controlUnit.getCurrentState());
                    }
                    Machine.this.controlUnit.incrementMicroIndex(1);
                    try {
                        currentMicro.execute();
                    }
                    catch (ExecutionException e) {
                        Machine.this.getChangeSupport().firePropertyChange("exception thrown", null, e.getMessage());
                        Machine.this.controlUnit.setMicroIndex(currentIndex);
                        return null;
                    }
                    catch (BreakException e) {
                        Machine.this.getChangeSupport().firePropertyChange("break", null, e);
                        Machine.this.runMode = 4;
                    }
                    if (Machine.this.runMode == 1) {
                        Machine.this.runMode = 4;
                    }
                    if (Machine.this.runMode != 2 || currentMicro != Machine.this.getEnd()) continue;
                    Machine.this.runMode = 4;
                }
                Machine.this.getChangeSupport().firePropertyChange(Machine.this.runMode == 5 ? "execution aborted" : (mode == 1 ? "halted step by micro" : "execution halted"), true, false);
                return null;
            }
        };
        this.swingWorker.start();
    }

    public Vector haltBitsThatAreSet() {
        Vector<ConditionBit> result = new Vector<ConditionBit>();
        for (int i = 0; i < this.getModule("conditionBits").size(); ++i) {
            ConditionBit condBit = this.conditionBits.elementAt(i);
            if (!condBit.getHalt() || !condBit.isSet()) continue;
            result.addElement(condBit);
        }
        return result;
    }

    public Register getRegisterNamed(String name) {
        int i;
        for (i = 0; i < this.registers.size(); ++i) {
            Register r = this.registers.elementAt(i);
            if (!r.getName().equals(name)) continue;
            return r;
        }
        for (i = 0; i < this.registerArrays.size(); ++i) {
            RegisterArray array = this.registerArrays.elementAt(i);
            for (int j = 0; j < array.registers().length; ++j) {
                if (!array.registers()[j].getName().equals(name)) continue;
                return array.registers()[j];
            }
        }
        return null;
    }

    public ConditionBit getConditionBitNamed(String name) {
        for (int i = 0; i < this.getModule("conditionBits").size(); ++i) {
            ConditionBit b = this.conditionBits.elementAt(i);
            if (!b.getName().equals(name)) continue;
            return b;
        }
        return null;
    }

    public RAM getRamNamed(String name) {
        for (int i = 0; i < this.rams.size(); ++i) {
            RAM b = this.rams.elementAt(i);
            if (!b.getName().equals(name)) continue;
            return b;
        }
        return null;
    }

    @Override
    public Object clone() {
        return new Machine(this.getName());
    }

    @Override
    public void copyDataTo(Module newModule) {
        Assert.That(newModule instanceof Machine, "Passed non-Machine to Machine.copyDataTo()");
    }

    @Override
    public String getXMLDescription() {
        return this.getHTMLName();
    }

    @Override
    public String getHTMLDescription() {
        return this.getHTMLName();
    }

    public List<Comment> getCommentMicros() {
        ArrayList<Comment> result = new ArrayList<Comment>();
        for (MachineInstruction instr : this.instructions) {
            List<Microinstruction> micros = instr.getMicros();
            for (Microinstruction micro : micros) {
                if (!(micro instanceof Comment)) continue;
                result.add((Comment)micro);
            }
        }
        for (Microinstruction micro : this.fetchSequence.getMicros()) {
            if (!(micro instanceof Comment)) continue;
            result.add((Comment)micro);
        }
        return result;
    }
}

