/*
 * Decompiled with CFR 0.152.
 */
package cpusim.gui;

import cpusim.Machine;
import cpusim.assembler.AssembledInstructionCall;
import cpusim.assembler.Assembler;
import cpusim.gui.AssemblerWindow;
import cpusim.gui.Desktop;
import cpusim.gui.EQUDialog;
import cpusim.gui.FetchSequenceDialog;
import cpusim.gui.FieldDialog;
import cpusim.gui.FieldValuesDialog;
import cpusim.gui.FindDialog;
import cpusim.gui.HelpDialog;
import cpusim.gui.HighlightOptionsDialog;
import cpusim.gui.InstructionDialog;
import cpusim.gui.LangUnit;
import cpusim.gui.MicroDialog;
import cpusim.gui.ModuleDialog;
import cpusim.gui.RAMWindow;
import cpusim.gui.RegistersWindow;
import cpusim.module.Register;
import cpusim.scrollabledesktop.BaseInternalFrame;
import cpusim.util.Assert;
import cpusim.util.CPUSimConstants;
import cpusim.util.LoadException;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class ActionListenerFor
implements CPUSimConstants {
    private static Desktop desktop;
    private static Machine machine;
    private static Assembler assembler;

    public static void initialize(Desktop d, Machine m, Assembler a) {
        desktop = d;
        machine = m;
        assembler = a;
    }

    public static class StartOverButton
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            desktop.getDebugToolBar().startOverButton.doClick();
        }
    }

    public static class BackupOneMicroButton
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            desktop.getDebugToolBar().backupMicroInstrButton.doClick();
        }
    }

    public static class BackupOneInstrButton
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            desktop.getDebugToolBar().backupMachineInstrButton.doClick();
        }
    }

    public static class StepByMicroButton
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            desktop.getDebugToolBar().stepByMicroButton.doClick();
        }
    }

    public static class StepByInstrButton
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            desktop.getDebugToolBar().stepByInstrButton.doClick();
        }
    }

    public static class GoButton
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            desktop.getDebugToolBar().goButton.doClick();
        }
    }

    public static class HelpMenu
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            desktop.getJMenuBar().getMenu(6).doClick();
        }
    }

    public static class TextMenu
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            desktop.getJMenuBar().getMenu(5).doClick();
        }
    }

    public static class ViewMenu
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            desktop.getJMenuBar().getMenu(4).doClick();
        }
    }

    public static class ExecuteMenu
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            desktop.getJMenuBar().getMenu(3).doClick();
        }
    }

    public static class ModifyMenu
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            desktop.getJMenuBar().getMenu(2).doClick();
        }
    }

    public static class EditMenu
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            desktop.getJMenuBar().getMenu(1).doClick();
        }
    }

    public static class FileMenu
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            desktop.getJMenuBar().getMenu(0).doClick();
        }
    }

    public static class OpenMachine
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            desktop.getJMenuBar().getMenu(0).getItem(11).doClick();
        }
    }

    public static class NewMachine
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            desktop.getJMenuBar().getMenu(0).getItem(10).doClick();
        }
    }

    public static class Preferences
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            desktop.getJMenuBar().getMenu(1).getItem(12).doClick();
        }
    }

    public static class DebugMode
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            desktop.getJMenuBar().getMenu(3).getItem(0).doClick();
        }
    }

    public static class IOConnections
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            JMenu menu = desktop.getJMenuBar().getMenu(3);
            JMenu submenu = (JMenu)menu.getItem(14);
            submenu.getItem(2).doClick();
        }
    }

    public static class TextEdit
    implements ActionListener {
        private int type;

        public TextEdit(int t) {
            this.type = t;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JInternalFrame selectedFrame = desktop.getSelectedFrame();
            if (!(selectedFrame instanceof AssemblerWindow)) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                ((AssemblerWindow)selectedFrame).getTextArea().requestFocus();
                switch (this.type) {
                    case 0: {
                        ((AssemblerWindow)selectedFrame).getTextArea().copy();
                        break;
                    }
                    case 1: {
                        ((AssemblerWindow)selectedFrame).getTextArea().cut();
                        break;
                    }
                    case 2: {
                        ((AssemblerWindow)selectedFrame).getTextArea().paste();
                        break;
                    }
                    case 3: {
                        ((AssemblerWindow)selectedFrame).getTextArea().selectAll();
                        break;
                    }
                    default: {
                        Assert.That(false, "Error: invalid type for TextEdit");
                    }
                }
            }
        }
    }

    public static class LoadRam
    implements ActionListener {
        private boolean displayMessage = false;
        private int fileFormat;

        public LoadRam(int fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JInternalFrame selectedFrame = desktop.getSelectedFrame();
            if (!(selectedFrame instanceof RAMWindow)) {
                if (this.displayMessage) {
                    JOptionPane.showMessageDialog(desktop.getDesktopPane(), "You must select a RAM Window before you can use this menu item.", "Menu Error", 0);
                    this.displayMessage = false;
                } else {
                    Toolkit.getDefaultToolkit().beep();
                    this.displayMessage = true;
                }
                return;
            }
            FileDialog dialog = new FileDialog((Frame)desktop, "Open " + (this.fileFormat == 0 ? "RAM" : "Intel hex") + " file", 0);
            dialog.setDirectory(desktop.getCurrentTextDirectory().getAbsolutePath());
            dialog.setVisible(true);
            String fileName = dialog.getFile();
            if (fileName == null) {
                return;
            }
            String directoryName = dialog.getDirectory();
            desktop.setCurrentTextDirectory(new File(directoryName));
            ((RAMWindow)selectedFrame).load(new File(directoryName + fileName), this.fileFormat);
        }
    }

    public static class StoreRam
    implements ActionListener {
        private boolean displayMessage = false;
        private int fileFormat;

        public StoreRam(int fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JInternalFrame selectedFrame = desktop.getSelectedFrame();
            if (!(selectedFrame instanceof RAMWindow)) {
                if (this.displayMessage) {
                    JOptionPane.showMessageDialog(desktop.getDesktopPane(), "You must select a RAM Window before you can use this menu item.", "Menu Error", 0);
                    this.displayMessage = false;
                } else {
                    Toolkit.getDefaultToolkit().beep();
                    this.displayMessage = true;
                }
                return;
            }
            FileDialog chooser = new FileDialog((Frame)desktop, "Save RAM " + (this.fileFormat == 2 ? " in Intel hex format" : ""), 1);
            chooser.setDirectory(desktop.getCurrentTextDirectory().getAbsolutePath());
            ((RAMWindow)selectedFrame).store(chooser, this.fileFormat);
            desktop.setCurrentTextDirectory(new File(chooser.getDirectory()));
        }
    }

    public static class SavingText
    implements ActionListener {
        private int type;

        public SavingText(int t) {
            this.type = t;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JInternalFrame selectedFrame = desktop.getSelectedFrame();
            if (!(selectedFrame instanceof AssemblerWindow)) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                FileDialog chooser = new FileDialog((Frame)desktop, LangUnit.LU_SAVE_ASM.str(), 1);
                chooser.setDirectory(desktop.getCurrentTextDirectory().getAbsolutePath());
                switch (this.type) {
                    case 0: {
                        ((AssemblerWindow)selectedFrame).save(chooser);
                        break;
                    }
                    case 1: {
                        ((AssemblerWindow)selectedFrame).saveAs(chooser);
                    }
                }
                desktop.setCurrentTextDirectory(new File(chooser.getDirectory()));
            }
        }
    }

    public static class SavingMachine
    implements ActionListener {
        private int type;

        public SavingMachine(int t) {
            this.type = t;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String name;
            File file = null;
            switch (this.type) {
                case 0: {
                    file = machine.getFile();
                    if (file != null || (file = desktop.chooseFileToWriteTo()) != null) break;
                    return;
                }
                case 1: {
                    file = desktop.chooseFileToWriteTo();
                    if (file != null) break;
                    return;
                }
            }
            boolean success = desktop.saveMachineToFile(file);
            if (success) {
                machine.setName(file.getName());
                machine.setDirty(false);
                machine.setFile(file);
            }
            if ((name = file.getName()).endsWith(".xml") || name.endsWith(".cpu")) {
                name = name.substring(0, name.length() - 4);
            }
            machine.setName(name);
            desktop.setTitle(name);
        }
    }

    public static class Run
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            machine.getControlUnit().reset();
            machine.resetAllChannels();
            machine.execute(0);
        }
    }

    public static class Registers
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            HashMap<Object, BaseInternalFrame> moduleWindows = desktop.getModuleWindows();
            RegistersWindow w = (RegistersWindow)moduleWindows.get("Registers");
            if (w == null) {
                w = new RegistersWindow(machine.getModule("registers").toArray(new Register[0]), "Registers", desktop.getActivateNonAssemblerWindowListener(), desktop.getVetoSelectionListener());
                desktop.getDesktopPane().add(w);
                w.setTableFont(desktop.getFontData().tableFont);
                desktop.getModuleWindows().put("Registers", w);
            } else {
                w.setVisible(true);
            }
            desktop.bringWindowToFront(w);
        }
    }

    public static class PrintSetup
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            desktop.setPrintFormat(desktop.getPrintJob().pageDialog(desktop.getPrintFormat()));
        }
    }

    public static class PrintPreview
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            JInternalFrame selectedFrame = desktop.getSelectedFrame();
            if (!(selectedFrame instanceof AssemblerWindow)) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                ((AssemblerWindow)selectedFrame).printPreview(desktop.getPrintFormat(), desktop.getPrintJob());
            }
        }
    }

    public static class Print
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            JInternalFrame selectedFrame = desktop.getSelectedFrame();
            if (!(selectedFrame instanceof AssemblerWindow)) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                ((AssemblerWindow)selectedFrame).print(desktop.getPrintFormat(), desktop.getPrintJob());
                desktop.repaint();
            }
        }
    }

    public static class RedoListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                desktop.getUndoManager().redo();
            }
            catch (CannotRedoException ex) {
                Toolkit.getDefaultToolkit().beep();
            }
            desktop.updateUndo();
        }
    }

    public static class Undo
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                desktop.getUndoManager().undo();
            }
            catch (CannotUndoException ex) {
                Toolkit.getDefaultToolkit().beep();
            }
            desktop.updateUndo();
        }
    }

    public static class Highlighting
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            HighlightOptionsDialog d = new HighlightOptionsDialog(desktop);
            d.pack();
            Rectangle bounds = desktop.getDialogSizePrefs("HighlightOptionsDialog");
            if (bounds.x > 0) {
                d.setBounds(bounds);
            } else {
                Dimension d1 = d.getSize();
                Dimension d2 = desktop.getSize();
                int x = Math.max((d2.width - d1.width) / 2, 0);
                int y = Math.max((d2.height - d1.height) / 2, 0);
                d.setLocation(x + desktop.getX(), y + desktop.getY());
            }
            d.setVisible(true);
        }
    }

    public static class Microinstructions
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (machine.getModule("registers").size() == 0) {
                JOptionPane.showMessageDialog(desktop, "You need to create at least one register first.", "Error", 0);
                return;
            }
            MicroDialog d = new MicroDialog((Frame)desktop, machine);
            d.pack();
            Rectangle bounds = desktop.getDialogSizePrefs("MicroDialog");
            if (bounds.x > 0) {
                d.setBounds(bounds);
            } else {
                Dimension d1 = d.getSize();
                Dimension d2 = d.getOwner().getSize();
                int x = Math.max((d2.width - (d1.width + 50)) / 2, 0);
                int y = Math.max((d2.height - (d1.height + 30)) / 2, 0);
                bounds = new Rectangle(x + d.getOwner().getX(), y + d.getOwner().getY(), d1.width + 50, d1.height + 30);
                d.setBounds(bounds);
            }
            d.setVisible(true);
        }
    }

    public static class MachineInstructions
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            InstructionDialog d = new InstructionDialog((Frame)desktop, machine);
            d.pack();
            Rectangle bounds = desktop.getDialogSizePrefs("InstructionDialog");
            if (bounds.x > 0) {
                d.setBounds(bounds);
            } else {
                Dimension d1 = d.getSize();
                Dimension d2 = desktop.getSize();
                int x = Math.max((d2.width - d1.width) / 2, 0);
                int y = Math.max((d2.height - d1.height) / 2, 0);
                d.setLocation(x + desktop.getX(), y + desktop.getY());
            }
            d.setVisible(true);
        }
    }

    public static class HardwareModules
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            ModuleDialog d = new ModuleDialog(desktop, machine);
            d.pack();
            Rectangle bounds = desktop.getDialogSizePrefs("ModuleDialog");
            if (bounds.x > 0) {
                d.setBounds(bounds);
            } else {
                Dimension d1 = d.getSize();
                Dimension d2 = desktop.getSize();
                int x = Math.max((d2.width - d1.width) / 2, 0);
                int y = Math.max((d2.height - d1.height) / 2, 0);
                d.setLocation(x + desktop.getX(), y + desktop.getY());
            }
            d.setVisible(true);
        }
    }

    public static class EQUs
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            EQUDialog d = new EQUDialog((Frame)desktop, machine);
            Rectangle bounds = desktop.getDialogSizePrefs("EQUDialog");
            if (bounds.x > 0) {
                d.setBounds(bounds);
            } else {
                d.setSize(350, 200);
                Dimension d1 = d.getSize();
                Dimension d2 = desktop.getSize();
                int x = Math.max((d2.width - d1.width) / 2, 0);
                int y = Math.max((d2.height - d1.height) / 2, 0);
                d.setLocation(x + desktop.getX(), y + desktop.getY());
            }
            d.setVisible(true);
        }
    }

    public static class FieldValues
    implements ActionListener {
        FieldDialog parent;

        public FieldValues(FieldDialog parent) {
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FieldValuesDialog d = new FieldValuesDialog((Dialog)this.parent, machine, this.parent.getSelectedField());
            d.pack();
            Rectangle bounds = desktop.getDialogSizePrefs("FieldValuesDialog");
            if (bounds.x > 0) {
                d.setBounds(bounds);
            } else {
                Dimension d1 = d.getSize();
                Dimension d2 = this.parent.getSize();
                int x = Math.max((d2.width - d1.width) / 2, 0);
                int y = Math.max((d2.height - d1.height) / 2, 0);
                d.setLocation(x + this.parent.getX(), y + this.parent.getY());
            }
            d.setVisible(true);
        }
    }

    public static class Fields
    implements ActionListener {
        InstructionDialog parent;

        public Fields(InstructionDialog parent) {
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FieldDialog d = new FieldDialog(this.parent, machine);
            d.pack();
            Rectangle bounds = desktop.getDialogSizePrefs("FieldDialog");
            if (bounds.x > 0) {
                d.setBounds(bounds);
            } else {
                Dimension d1 = d.getSize();
                Dimension d2 = desktop.getSize();
                int x = Math.max((d2.width - d1.width) / 2, 0);
                int y = Math.max((d2.height - d1.height) / 2, 0);
                d.setLocation(x + desktop.getX(), y + desktop.getY());
            }
            d.setVisible(true);
        }
    }

    public static class GeneralCPUSimHelp
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            HelpDialog d = new HelpDialog(desktop);
            d.showPage("introduction");
        }
    }

    public static class FetchSequence
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            FetchSequenceDialog d = new FetchSequenceDialog((Frame)desktop, machine);
            d.pack();
            Dimension d1 = d.getSize();
            Dimension d2 = desktop.getSize();
            int x = Math.max((d2.width - d1.width) / 2, 0);
            int y = Math.max((d2.height - d1.height) / 2, 0);
            d.setBounds(x + desktop.getX(), y + desktop.getY(), d1.width, d1.height);
            d.setVisible(true);
        }
    }

    public static class Exit
    extends WindowAdapter
    implements ActionListener {
        @Override
        public void windowClosing(WindowEvent e) {
            if (desktop.userWantsToQuit()) {
                System.exit(0);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (desktop.userWantsToQuit()) {
                System.exit(0);
            }
        }
    }

    public static class Delete
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            JInternalFrame selectedFrame = desktop.getSelectedFrame();
            if (!(selectedFrame instanceof AssemblerWindow)) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                ((AssemblerWindow)selectedFrame).getTextArea().requestFocus();
                ((AssemblerWindow)selectedFrame).getTextArea().setSelectedText("");
            }
        }
    }

    public static class CloseInternalTextFrame
    extends InternalFrameAdapter
    implements ActionListener,
    VetoableChangeListener {
        @Override
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            String name = e.getPropertyName();
            if (name.equals("closed")) {
                Boolean oldValue = (Boolean)e.getOldValue();
                Boolean newValue = (Boolean)e.getNewValue();
                if (oldValue == Boolean.FALSE && newValue == Boolean.TRUE) {
                    AssemblerWindow frame = (AssemblerWindow)e.getSource();
                    boolean shouldCloseIt = desktop.doCloseAssemblerWindow(frame);
                    if (!shouldCloseIt) {
                        throw new PropertyVetoException("close cancelled", e);
                    }
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JInternalFrame internalFrame = desktop.getSelectedFrame();
            if (internalFrame != null && internalFrame instanceof AssemblerWindow) {
                internalFrame.doDefaultCloseAction();
            }
        }
    }

    public static class ResetEverything
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            for (BaseInternalFrame window : desktop.getModuleWindows().values()) {
                if (window instanceof RegistersWindow) {
                    ((RegistersWindow)window).cancelCurrentEditing();
                    continue;
                }
                if (!(window instanceof RAMWindow)) continue;
                ((RAMWindow)window).cancelCurrentEditing();
            }
            desktop.getBackupManager().flushBackups();
            machine.clearAllRegisters();
            machine.clearAllRegisterArrays();
            machine.clearAllRAMs();
            desktop.getUpdateDisplayManager().updateRegisterAndRAMWindows();
            machine.getControlUnit().reset();
            machine.resetAllChannels();
        }
    }

    public static class ClearAssembleLoadAndRun
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            boolean success = desktop.assembleCurrentProgram();
            if (!success) {
                return;
            }
            if (machine.getCodeStore() == null) {
                JOptionPane.showMessageDialog(desktop, "The machine has no RAM's and so there is no where to load the assembled code.", "Loading Error", 0);
                return;
            }
            List<AssembledInstructionCall> instrs = assembler.getAssembledInstructions();
            try {
                for (BaseInternalFrame frame : desktop.getModuleWindows().values()) {
                    if (frame instanceof RegistersWindow) {
                        ((RegistersWindow)frame).cancelCurrentEditing();
                        continue;
                    }
                    if (!(frame instanceof RAMWindow)) continue;
                    ((RAMWindow)frame).cancelCurrentEditing();
                }
                machine.clearAllRAMs();
                machine.getCodeStore().loadAssembledInstructions(instrs, machine.getStartingAddressForLoading());
            }
            catch (LoadException ex) {
                JOptionPane.showMessageDialog(desktop, ex.getMessage(), "Loading Error", 0);
                return;
            }
            desktop.getBackupManager().flushBackups();
            machine.clearAllRegisters();
            machine.clearAllRegisterArrays();
            desktop.getUpdateDisplayManager().updateRegisterWindows();
            desktop.getUpdateDisplayManager().updateRAMWindows();
            machine.getControlUnit().reset();
            machine.resetAllChannels();
            machine.execute(0);
        }
    }

    public static class AssembleLoadAndRun
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            boolean success = desktop.assembleCurrentProgram();
            if (!success) {
                return;
            }
            if (machine.getCodeStore() == null) {
                JOptionPane.showMessageDialog(desktop, "The machine has no RAM's and so there is no where to load the assembled code.", "Loading Error", 0);
                return;
            }
            List<AssembledInstructionCall> instrs = assembler.getAssembledInstructions();
            try {
                machine.getCodeStore().loadAssembledInstructions(instrs, machine.getStartingAddressForLoading());
            }
            catch (LoadException ex) {
                JOptionPane.showMessageDialog(desktop, ex.getMessage(), "Loading Error", 0);
                return;
            }
            machine.getControlUnit().reset();
            machine.resetAllChannels();
            machine.execute(0);
        }
    }

    public static class AssembleAndLoad
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            boolean success = desktop.assembleCurrentProgram();
            if (!success) {
                return;
            }
            if (desktop.getDebugToolBar().isVisible()) {
                desktop.getBackupManager().flushBackups();
                machine.getControlUnit().reset();
                machine.resetAllChannels();
                desktop.getDebugToolBar().updateDisplay();
            }
            if (machine.getCodeStore() == null) {
                JOptionPane.showMessageDialog(desktop, "The machine has no RAM's and so there is no where to load the assembled code.", "Loading Error", 0);
                return;
            }
            List<AssembledInstructionCall> instrs = assembler.getAssembledInstructions();
            try {
                machine.getCodeStore().loadAssembledInstructions(instrs, machine.getStartingAddressForLoading());
            }
            catch (LoadException ex) {
                JOptionPane.showMessageDialog(desktop, ex.getMessage(), "Loading Error", 0);
            }
        }
    }

    public static class Assemble
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            desktop.assembleCurrentProgram();
        }
    }

    public static class StopListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            machine.setRunMode(5);
            machine.interruptExecutionThread();
        }
    }

    public static class Replace
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            FindDialog findDialog = desktop.getFindDialog();
            if (findDialog == null) {
                desktop.setFindDialog(new FindDialog(desktop, 1));
                findDialog = desktop.getFindDialog();
            } else {
                findDialog.setSelectedIndex(1);
            }
            Dimension d1 = findDialog.getSize();
            Dimension d2 = desktop.getSize();
            int x = Math.max((d2.width - d1.width) / 2, 0);
            int y = Math.max((d2.height - d1.height) / 2, 0);
            findDialog.setBounds(x + desktop.getX(), y + desktop.getY(), d1.width, d1.height);
            findDialog.setVisible(true);
        }
    }

    public static class Find
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            FindDialog findDialog = desktop.getFindDialog();
            if (findDialog == null) {
                desktop.setFindDialog(new FindDialog(desktop, 0));
                findDialog = desktop.getFindDialog();
            } else {
                findDialog.setSelectedIndex(0);
            }
            Dimension d1 = findDialog.getSize();
            Dimension d2 = desktop.getSize();
            int x = Math.max((d2.width - d1.width) / 2, 0);
            int y = Math.max((d2.height - d1.height) / 2, 0);
            findDialog.setBounds(x + desktop.getX(), y + desktop.getY(), d1.width, d1.height);
            findDialog.setVisible(true);
        }
    }

    public static class OpenText
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            FileDialog dialog = new FileDialog((Frame)desktop, LangUnit.LU_SAVE_ASM.str(), 0);
            dialog.setDirectory(desktop.getCurrentTextDirectory().getAbsolutePath());
            dialog.setVisible(true);
            String fileName = dialog.getFile();
            if (fileName == null) {
                return;
            }
            String directoryName = dialog.getDirectory();
            desktop.setCurrentTextDirectory(new File(directoryName));
            desktop.openWindowForFile(new File(directoryName + fileName));
        }
    }

    public static class NewText
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            AssemblerWindow newAssemblerWindow = new AssemblerWindow("untitled " + desktop.getNumOpenedWindows(), desktop.findNextTextWindowLocation(), desktop.getCloseInternalFrameListener(), desktop.getActivateAssemblerWindowListener(), (VetoableChangeListener)desktop.getVetoSelectionListener());
            newAssemblerWindow.getTextArea().getSyntaxDocument().addUndoableEditListener(desktop.getUndoEditListener());
            newAssemblerWindow.setTextFont(desktop.getFontData().textWindowFont);
            desktop.getTextWindows().addElement(newAssemblerWindow);
            desktop.setNumOpenedWindows(desktop.getNumOpenedWindows() + 1);
            Rectangle bounds = newAssemblerWindow.getBounds(null);
            desktop.getDesktopPane().add(newAssemblerWindow, bounds.x, bounds.y);
            desktop.updateDocumentSyntaxOf(newAssemblerWindow);
            desktop.setToCurrentTheme(newAssemblerWindow);
            desktop.bringWindowToFront(newAssemblerWindow);
            newAssemblerWindow.setCaretPosition(0);
        }
    }
}

