/*
 * Decompiled with CFR 0.152.
 */
package cpusim.microinstruction;

import cpusim.ExecutionException;
import cpusim.Microinstruction;
import cpusim.Module;
import cpusim.module.ConditionBit;
import cpusim.module.Register;
import cpusim.util.Assert;
import cpusim.util.CPUSimConstants;
import java.math.BigInteger;

public class Arithmetic
extends Microinstruction
implements CPUSimConstants {
    public static final String[] OPERATIONS = new String[]{"ADD", "SUBTRACT", "MULTIPLY", "DIVIDE"};
    private Register source1;
    private Register source2;
    private Register destination;
    private ConditionBit overflowBit;
    private ConditionBit carryBit;
    private String type;

    public Arithmetic(String name, String type, Register source1, Register source2, Register destination, ConditionBit overflowBit, ConditionBit carryBit) {
        super(name);
        this.type = type;
        this.source1 = source1;
        this.source2 = source2;
        this.destination = destination;
        this.overflowBit = overflowBit;
        this.carryBit = carryBit;
    }

    public void setType(String newType) {
        this.type = newType;
    }

    public void setSource1(Register r) {
        this.source1 = r;
    }

    public void setSource2(Register r) {
        this.source2 = r;
    }

    public void setDestination(Register r) {
        this.destination = r;
    }

    public void setOverflowBit(ConditionBit b) {
        this.overflowBit = b;
    }

    public void setCarryBit(ConditionBit b) {
        this.carryBit = b;
    }

    public String getType() {
        return this.type;
    }

    public Register getSource1() {
        return this.source1;
    }

    public Register getSource2() {
        return this.source2;
    }

    public Register getDestination() {
        return this.destination;
    }

    public ConditionBit getOverflowBit() {
        return this.overflowBit;
    }

    public ConditionBit getCarryBit() {
        return this.carryBit;
    }

    @Override
    public Object clone() {
        return new Arithmetic(this.getName(), this.type, this.source1, this.source2, this.destination, this.overflowBit, this.carryBit);
    }

    @Override
    public void copyDataTo(Microinstruction newMicro) {
        Assert.That(newMicro instanceof Arithmetic, "Passed non-Arithmetic to Arithmetic.copyDataTo()");
        Arithmetic newArithmetic = (Arithmetic)newMicro;
        newArithmetic.setName(this.getName());
        newArithmetic.type = this.type;
        newArithmetic.source1 = this.source1;
        newArithmetic.source2 = this.source2;
        newArithmetic.destination = this.destination;
        newArithmetic.overflowBit = this.overflowBit;
        newArithmetic.carryBit = this.carryBit;
    }

    @Override
    public boolean uses(Module m) {
        return m == this.source1 || m == this.source2 || m == this.destination || m == this.carryBit || m == this.overflowBit;
    }

    @Override
    public void execute() {
        long value1 = this.source1.getValue();
        long value2 = this.source2.getValue();
        BigInteger op1 = BigInteger.valueOf(value1);
        BigInteger op2 = BigInteger.valueOf(value2);
        int width = this.destination.getWidth();
        BigInteger twoToWidthMinusOne = BigInteger.valueOf(2L).pow(width - 1);
        BigInteger result = null;
        if (this.type.equals("ADD")) {
            result = op1.add(op2);
        } else if (this.type.equals("SUBTRACT")) {
            result = op1.subtract(op2);
        } else if (this.type.equals("MULTIPLY")) {
            result = op1.multiply(op2);
        } else if (this.type.equals("DIVIDE")) {
            if (op2.compareTo(BigInteger.ZERO) == 0) {
                throw new ExecutionException("There was an attempt to divide by 0.");
            }
            result = op1.divide(op2);
        }
        if (result.compareTo(twoToWidthMinusOne) >= 0 || result.compareTo(twoToWidthMinusOne.negate()) < 0) {
            this.overflowBit.set(1);
        }
        if (this.type.equals("ADD") && (value1 < 0L && value2 < 0L || value1 < 0L && value2 > value1 || value2 < 0L && value1 > value2)) {
            this.carryBit.set(1);
        }
        long longResult = result.longValue();
        this.destination.setValue(longResult << 64 - width >> 64 - width);
    }

    @Override
    public String getXMLDescription() {
        return "<Arithmetic name=\"" + this.getHTMLName() + "\" type=\"" + this.getType() + "\" source1=\"" + this.getSource1().getID() + "\" source2=\"" + this.getSource2().getID() + "\" destination=\"" + this.getDestination().getID() + (this.overflowBit != CPUSimConstants.NO_CONDITIONBIT ? "\" overflowBit=\"" + this.getOverflowBit().getID() : "") + (this.carryBit != CPUSimConstants.NO_CONDITIONBIT ? "\" carryBit=\"" + this.getCarryBit().getID() : "") + "\" id=\"" + this.getID() + "\" />";
    }

    @Override
    public String getHTMLDescription() {
        return "<TR><TD>" + this.getHTMLName() + "</TD><TD>" + this.getType() + "</TD><TD>" + this.getSource1().getHTMLName() + "</TD><TD>" + this.getSource2().getHTMLName() + "</TD><TD>" + this.getDestination().getHTMLName() + "</TD><TD>" + this.getOverflowBit().getHTMLName() + "</TD><TD>" + this.getCarryBit().getHTMLName() + "</TD></TR>";
    }
}

