/*
 * Decompiled with CFR 0.152.
 */
package cpusim.microinstruction;

import cpusim.Machine;
import cpusim.Microinstruction;
import cpusim.microinstruction.MicroFactory;
import cpusim.microinstruction.Test;
import cpusim.module.Register;
import cpusim.util.DecimalTableCellRenderer;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;

public class TestFactory
extends MicroFactory {
    private Vector currentMicros;
    private Test prototype;

    public TestFactory(Machine machine) {
        super(machine);
        this.currentMicros = machine.getMicros("test");
        Register r = machine.getAllRegisters().size() == 0 ? null : (Register)machine.getAllRegisters().elementAt(0);
        this.prototype = new Test("???", r, 0, 0, "EQ", 0L, 0, machine.getControlUnit());
        this.clones = (Microinstruction[])this.createClones();
    }

    @Override
    public HashMap getCellRenderers() {
        HashMap<String, DecimalTableCellRenderer> renderers = new HashMap<String, DecimalTableCellRenderer>();
        renderers.put("value", new DecimalTableCellRenderer());
        return renderers;
    }

    @Override
    public HashMap getCellEditors() {
        HashMap<String, DefaultCellEditor> editors = new HashMap<String, DefaultCellEditor>();
        Vector registers = this.machine.getAllRegisters();
        JComboBox registersCombo = new JComboBox(registers);
        editors.put("register", new DefaultCellEditor(registersCombo));
        JComboBox<String> comparisonsCombo = new JComboBox<String>(Test.COMPARISONS);
        editors.put("comparison", new DefaultCellEditor(comparisonsCombo));
        return editors;
    }

    @Override
    Microinstruction getPrototype() {
        return this.prototype;
    }

    @Override
    Class getMicroClass() {
        return Test.class;
    }

    @Override
    public Vector getCurrentMicros() {
        return this.currentMicros;
    }

    @Override
    public String toString() {
        return "Test";
    }

    @Override
    public String[] getProperties() {
        return new String[]{"name", "register", "start", "numBits", "comparison", "value", "omission"};
    }

    @Override
    public void updateCurrentMicrosFromClones() {
        this.machine.setMicros("test", this.createNewMicroList(this.clones));
    }

    @Override
    public void setClones(Object[] newClones) {
        Test[] tests = new Test[newClones.length];
        for (int i = 0; i < newClones.length; ++i) {
            tests[i] = (Test)newClones[i];
        }
        this.clones = tests;
    }

    @Override
    public boolean checkValidity(Object[] micros) {
        Microinstruction[] tests = new Test[micros.length];
        for (int i = 0; i < micros.length; ++i) {
            tests[i] = (Test)micros[i];
        }
        return this.allNamesAreUnique(tests) && !this.someNamesAreEmpty(tests) && this.rangeInBound((Test[])tests);
    }

    public boolean rangeInBound(Test[] tests) {
        for (int i = 0; i < tests.length; ++i) {
            Test temp = tests[i];
            int start = temp.getStart();
            int numBits = temp.getNumBits();
            if (start < 0 || numBits < 0) {
                this.displayError("You cannot specify a negative value for the start bits,\nor the bitwise width of the test range\nin the microinstruction " + tests[i].getName() + ".");
                return false;
            }
            if (start >= temp.getRegister().getWidth()) {
                this.displayError("The start bit in the microinstruction " + tests[i].getName() + " is out of range.\n" + "It must be non-negative, and less than the " + "register's length.");
                return false;
            }
            if (start + numBits <= temp.getRegister().getWidth()) continue;
            this.displayError("The bits specified in the Test microinstruction " + tests[i].getName() + " are too large to fit in the register.");
            return false;
        }
        return true;
    }

    @Override
    public boolean newMicrosAreAllowed() {
        return this.machine.getModule("registers").size() > 0 || this.machine.getModule("registerArrays").size() > 0;
    }

    @Override
    public String getHelpPageID() {
        return "Test";
    }
}

