/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GArc;
import acm.graphics.GCanvas;
import acm.graphics.GDimension;
import acm.graphics.GFillable;
import acm.graphics.GMath;
import acm.graphics.GObject;
import acm.graphics.GRectangle;
import acm.graphics.GResizable;
import acm.graphics.GScalable;
import acm.util.Platform;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;

public class GOval
extends GObject
implements GFillable,
GResizable,
GScalable {
    private boolean useArcs = this.checkForArcRendering();
    private double frameWidth;
    private double frameHeight;
    private boolean isFilled;
    private Color fillColor;
    private GArc renderer;
    static final long serialVersionUID = 1L;

    public GOval(double width, double height) {
        this(0.0, 0.0, width, height);
    }

    public GOval(double x, double y, double width, double height) {
        this.frameWidth = width;
        this.frameHeight = height;
        this.setLocation(x, y);
        this.renderer = new GArc(this);
    }

    @Override
    public boolean contains(double x, double y) {
        double dy;
        double rx = this.frameWidth / 2.0;
        double ry = this.frameHeight / 2.0;
        if (rx == 0.0 || ry == 0.0) {
            return false;
        }
        double dx = x - (this.getX() + rx);
        return dx * dx / (rx * rx) + (dy = y - (this.getY() + ry)) * dy / (ry * ry) <= 1.0;
    }

    @Override
    public void paint(Graphics g) {
        Component comp = this.getComponent();
        if (comp instanceof GCanvas && !((GCanvas)comp).getNativeArcFlag()) {
            this.renderer.paint(g);
        } else {
            Rectangle r = this.getAWTBounds();
            if (this.useArcs) {
                if (this.isFilled()) {
                    g.setColor(this.getFillColor());
                    g.fillArc(r.x, r.y, r.width, r.height, 0, 360);
                    g.setColor(this.getColor());
                }
                g.drawArc(r.x, r.y, r.width, r.height, 0, 360);
            } else {
                if (this.isFilled()) {
                    g.setColor(this.getFillColor());
                    g.fillOval(r.x, r.y, r.width, r.height);
                    g.setColor(this.getColor());
                }
                g.drawOval(r.x, r.y, r.width, r.height);
            }
        }
    }

    @Override
    public void setFilled(boolean fill) {
        this.isFilled = fill;
        this.repaint();
    }

    @Override
    public boolean isFilled() {
        return this.isFilled;
    }

    @Override
    public void setFillColor(Color color) {
        this.fillColor = color;
        this.repaint();
    }

    @Override
    public Color getFillColor() {
        return this.fillColor == null ? this.getColor() : this.fillColor;
    }

    @Override
    public void setSize(double width, double height) {
        this.frameWidth = width;
        this.frameHeight = height;
        this.repaint();
    }

    @Override
    public final void setSize(GDimension size) {
        this.setSize(size.getWidth(), size.getHeight());
    }

    @Override
    public GDimension getSize() {
        return new GDimension(this.frameWidth, this.frameHeight);
    }

    @Override
    public void setBounds(double x, double y, double width, double height) {
        this.frameWidth = width;
        this.frameHeight = height;
        this.setLocation(x, y);
    }

    @Override
    public final void setBounds(GRectangle bounds) {
        this.setBounds(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    @Override
    public GRectangle getBounds() {
        return new GRectangle(this.getX(), this.getY(), this.frameWidth, this.frameHeight);
    }

    @Override
    public double getWidth() {
        return this.frameWidth;
    }

    @Override
    public double getHeight() {
        return this.frameHeight;
    }

    @Override
    public void scale(double sx, double sy) {
        this.frameWidth *= sx;
        this.frameHeight *= sy;
        this.repaint();
    }

    @Override
    public final void scale(double sf) {
        this.scale(sf, sf);
    }

    protected Rectangle getAWTBounds() {
        return new Rectangle(GMath.round(this.getX()), GMath.round(this.getY()), GMath.round(this.frameWidth), GMath.round(this.frameHeight));
    }

    private boolean checkForArcRendering() {
        return Platform.isMac() && Platform.compareVersion(System.getProperty("os.version"), "10.1") < 0;
    }
}

