/*
 * Decompiled with CFR 0.152.
 */
package cpusim;

import acm.io.IOConsole;
import acm.util.ErrorException;
import cpusim.ExecutionException;
import cpusim.IOChannel;
import cpusim.gui.Desktop;
import cpusim.util.Convert;
import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

public class ConsoleChannel
implements IOChannel {
    private Desktop desktop;
    private String name;
    private IOConsole io;

    public ConsoleChannel(String name) {
        this.name = name;
        this.desktop = null;
        this.io = new IOConsole();
    }

    public void setDesktop(Desktop desktop) {
        this.desktop = desktop;
        desktop.addConsoleToLowerPane(this.io);
    }

    @Override
    public long readLong(int numBits) {
        this.desktop.getUpdateDisplayManager().updateRegisterWindows();
        this.desktop.getUpdateDisplayManager().updateRAMWindows();
        this.io.setBackground(Color.yellow);
        while (true) {
            try {
                String input;
                while (true) {
                    if ((input = this.io.readLine("Enter an integer: ")) == null || input.equals("")) {
                        this.io.setBackground(Color.white);
                        throw new ExecutionException("Input cancelled.");
                    }
                    if (!input.equals("help")) break;
                    this.io.println("Type in a decimal, binary, or hexadecimal integer or type in a character surrounded by single quotes.  For binary, use a prefix of \"0b\" or \"-0b\"." + System.getProperty("line.separator") + "For hexadecimal, use " + "\"0x\" or \"-0x\".  " + "To halt execution, just press Enter/Return.");
                }
                long value = Convert.fromAnyBaseStringToLong(input);
                Convert.checkFitsInBits(value, numBits);
                this.io.setBackground(Color.white);
                this.desktop.requestFocus();
                return value;
            }
            catch (NumberFormatException e) {
                this.io.showErrorMessage("Invalid input: Please try again.");
                continue;
            }
            catch (ErrorException ioe) {
                this.io.showErrorMessage("Invalid input: Please try again.");
                continue;
            }
            break;
        }
    }

    @Override
    public char readAscii() {
        this.desktop.getUpdateDisplayManager().updateRegisterWindows();
        this.desktop.getUpdateDisplayManager().updateRAMWindows();
        this.io.setBackground(Color.yellow);
        while (true) {
            try {
                char c;
                while (true) {
                    String input;
                    if ((input = this.io.readLine("Enter an ASCII character: ")) == null || input.equals("")) {
                        this.io.setBackground(Color.white);
                        throw new ExecutionException("Input cancelled.");
                    }
                    if (input.equals("help")) {
                        this.io.println("Type in a character with no surrounding quotes and then press Enter/Return.  To halt execution, just press Enter/Return.");
                        continue;
                    }
                    c = input.charAt(0);
                    if (c <= '\u00ff') break;
                    this.io.println("Invalid input: The character '" + c + "' is not an ASCII value.");
                    this.io.println("Please try again.");
                }
                this.io.setBackground(Color.white);
                this.desktop.requestFocus();
                return c;
            }
            catch (ErrorException e) {
                this.io.println("Invalid input: Please try again.");
                continue;
            }
            break;
        }
    }

    @Override
    public char readUnicode() {
        this.desktop.getUpdateDisplayManager().updateRegisterWindows();
        this.desktop.getUpdateDisplayManager().updateRAMWindows();
        this.io.setBackground(Color.yellow);
        while (true) {
            try {
                char c;
                while (true) {
                    String input;
                    if ((input = this.io.readLine("Enter a Unicode character: ")) == null || input.equals("")) {
                        this.io.setBackground(Color.white);
                        throw new ExecutionException("Input cancelled.");
                    }
                    if (input.equals("help")) {
                        this.io.println("Type in a character with no surrounding quotes and then press Enter.  To halt execution, just press Enter/Return.");
                        continue;
                    }
                    c = input.charAt(0);
                    if (c <= '\uffff') break;
                    this.io.println("ERROR: The character '" + c + "' is not a Unicode value.");
                    this.io.println("Please try again.");
                }
                this.io.setBackground(Color.white);
                this.desktop.requestFocus();
                return c;
            }
            catch (ErrorException e) {
                this.io.println("ERROR: Please try again.");
                continue;
            }
            break;
        }
    }

    @Override
    public void writeLong(final long longValue) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ConsoleChannel.this.desktop.getUpdateDisplayManager().updateRegisterWindows();
                    ConsoleChannel.this.desktop.getUpdateDisplayManager().updateRAMWindows();
                    ConsoleChannel.this.io.println("Output: " + longValue);
                    ConsoleChannel.this.desktop.requestFocus();
                }
            });
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException e) {
            throw new ExecutionException("An InvocationTargetException was thrown when we \nattempted to write the value " + longValue + " to" + "the console.");
        }
    }

    @Override
    public void writeAscii(final long longValue) {
        if (longValue > 255L || longValue < 0L) {
            throw new ExecutionException("Attempt to output the value " + longValue + " as an ASCII value.");
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ConsoleChannel.this.desktop.getUpdateDisplayManager().updateRegisterWindows();
                    ConsoleChannel.this.desktop.getUpdateDisplayManager().updateRAMWindows();
                    ConsoleChannel.this.io.println("Output: " + (char)longValue);
                    ConsoleChannel.this.desktop.requestFocus();
                }
            });
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException e) {
            throw new ExecutionException("An InvocationTargetException was thrown when we \nattempted to write the value " + longValue + " to" + "the console.");
        }
    }

    @Override
    public void writeUnicode(final long longValue) {
        if (longValue > 65535L || longValue < 0L) {
            throw new ExecutionException("Attempt to output the value " + longValue + " as an Unicode value.");
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ConsoleChannel.this.desktop.getUpdateDisplayManager().updateRegisterWindows();
                    ConsoleChannel.this.desktop.getUpdateDisplayManager().updateRAMWindows();
                    ConsoleChannel.this.io.println("Output: " + (char)longValue);
                    ConsoleChannel.this.desktop.requestFocus();
                }
            });
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException e) {
            throw new ExecutionException("An InvocationTargetException was thrown when we \nattempted to write the value " + longValue + " to" + "the console.");
        }
    }

    @Override
    public void reset() {
        this.io.clear();
        this.io.setBackground(Color.white);
    }

    public String toString() {
        return this.name;
    }
}

