/*
 * Decompiled with CFR 0.152.
 */
package cpusim;

import cpusim.ExecutionException;
import cpusim.IOChannel;
import cpusim.gui.Desktop;
import cpusim.util.Convert;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class UserChannel
implements IOChannel {
    private Desktop desktop;
    private String name;
    private long result;

    public UserChannel(String name) {
        this.name = name;
        this.desktop = null;
        this.result = 1L;
    }

    public void setDesktop(Desktop desktop) {
        this.desktop = desktop;
    }

    @Override
    public long readLong(int numBits) {
        this.desktop.getUpdateDisplayManager().updateRegisterWindows();
        this.desktop.getUpdateDisplayManager().updateRAMWindows();
        long result = 0L;
        boolean done = false;
        while (!done) {
            String input = JOptionPane.showInputDialog(this.desktop, (Object)"Type in a decimal, binary, or hexadecimal integer\nor type in a character surrounded by single quotes.\nFor binary, use a prefix of \"0b\" or \"-0b\".\nFor hexadecimal, use \"0x\" or \"-0x\".");
            if (input == null) {
                throw new ExecutionException("Input cancelled.");
            }
            try {
                long inputLong = Convert.fromAnyBaseStringToLong(input);
                Convert.checkFitsInBits(inputLong, numBits);
                result = inputLong;
                done = true;
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this.desktop, e.getMessage() + "  Please try again.", "Error", 0);
            }
        }
        return result;
    }

    @Override
    public char readAscii() {
        char c;
        this.desktop.getUpdateDisplayManager().updateRegisterWindows();
        this.desktop.getUpdateDisplayManager().updateRAMWindows();
        while (true) {
            String input;
            if ((input = JOptionPane.showInputDialog(this.desktop, (Object)"Type in an ASCII character for input")) == null || input.equals("")) {
                throw new ExecutionException("Input cancelled.");
            }
            c = input.charAt(0);
            if (c <= '\u00ff') break;
            JOptionPane.showMessageDialog(this.desktop, "The character '" + c + "' is not an ASCII value.\n" + "Please try again.", "Error", 0);
        }
        return c;
    }

    @Override
    public char readUnicode() {
        char c;
        this.desktop.getUpdateDisplayManager().updateRegisterWindows();
        this.desktop.getUpdateDisplayManager().updateRAMWindows();
        while (true) {
            String input;
            if ((input = JOptionPane.showInputDialog(this.desktop, (Object)"Type in an Unicode character for input")) == null || input.equals("")) {
                throw new ExecutionException("Input cancelled.");
            }
            c = input.charAt(0);
            if (c <= '\uffff') break;
            JOptionPane.showMessageDialog(this.desktop, "The character '" + c + "' is not a Unicode value.\n" + "Please try again.", "Error", 0);
        }
        return c;
    }

    @Override
    public void writeLong(final long value) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    UserChannel.this.desktop.getUpdateDisplayManager().updateRegisterWindows();
                    UserChannel.this.desktop.getUpdateDisplayManager().updateRAMWindows();
                    UserChannel.this.result = JOptionPane.showOptionDialog(UserChannel.this.desktop, "next integer output value: " + value, "Integer output", 0, 1, null, new String[]{"OK", "Abort"}, "OK");
                }
            });
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException e) {
            throw new ExecutionException("An InvocationTargetException was thrown when we \nattempted to write the long value " + value + " to" + " the user in a dialog.");
        }
        if (this.result == 1L) {
            throw new ExecutionException("Abort requested.");
        }
    }

    @Override
    public void writeAscii(final long longValue) {
        if (longValue > 255L || longValue < 0L) {
            throw new ExecutionException("Attempt to output the value " + longValue + " as an ASCII value.");
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    UserChannel.this.desktop.getUpdateDisplayManager().updateRegisterWindows();
                    UserChannel.this.desktop.getUpdateDisplayManager().updateRAMWindows();
                    UserChannel.this.result = JOptionPane.showOptionDialog(UserChannel.this.desktop, "next ASCII output value: " + (char)longValue, "ASCII output", 0, 1, null, new String[]{"OK", "Abort"}, "OK");
                }
            });
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException e) {
            throw new ExecutionException("An InvocationTargetException was thrown when we \nattempted to write the ASCII value " + (char)longValue + " to the user in a dialog.");
        }
        if (this.result == 1L) {
            throw new ExecutionException("Abort requested.");
        }
    }

    @Override
    public void writeUnicode(final long longValue) {
        if (longValue > 65535L || longValue < 0L) {
            throw new ExecutionException("Attempt to output the value " + longValue + " as a Unicode value.");
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    UserChannel.this.desktop.getUpdateDisplayManager().updateRegisterWindows();
                    UserChannel.this.desktop.getUpdateDisplayManager().updateRAMWindows();
                    UserChannel.this.result = JOptionPane.showOptionDialog(UserChannel.this.desktop, "next Unicode output value: " + (char)longValue, "Unicode output", 0, 1, null, new String[]{"OK", "Abort"}, "OK");
                }
            });
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException e) {
            throw new ExecutionException("An InvocationTargetException was thrown when we \nattempted to write the Unicode value " + (char)longValue + " to the user in a dialog.");
        }
        if (this.result == 1L) {
            throw new ExecutionException("Abort requested.");
        }
    }

    @Override
    public void reset() {
    }

    public String toString() {
        return this.name;
    }
}

