/*
 * Decompiled with CFR 0.152.
 */
package cpusim.assembler;

import cpusim.Machine;
import cpusim.assembler.AssembledInstructionCall;
import cpusim.assembler.AssemblyException;
import cpusim.assembler.CodeGenerator;
import cpusim.assembler.InstructionCall;
import cpusim.assembler.Normalizer;
import cpusim.assembler.Parser;
import cpusim.assembler.Scanner;
import java.util.ArrayList;
import java.util.List;

public class Assembler {
    private Scanner scanner;
    private Parser parser;
    private Normalizer normalizer;
    private CodeGenerator generator;
    private List<AssembledInstructionCall> assembledInstructions;

    public Assembler(Machine machine) {
        this.scanner = new Scanner(machine);
        this.parser = new Parser(this.scanner, machine);
        this.normalizer = new Normalizer(machine);
        this.generator = new CodeGenerator(machine);
        this.assembledInstructions = new ArrayList<AssembledInstructionCall>();
    }

    public List<AssembledInstructionCall> getAssembledInstructions() {
        return this.assembledInstructions;
    }

    public void assemble(String programFileName, int startingAddress) throws AssemblyException {
        this.scanner.startScanning(programFileName);
        this.parser.initialize();
        this.parser.parse();
        List<InstructionCall> instructionsWithNoVars = this.normalizer.normalize(this.parser.getInstructions(), this.parser.getEqus(), startingAddress);
        this.assembledInstructions = this.generator.generateCode(instructionsWithNoVars);
    }

    public void updateScannerAndParser(Machine machine) {
        this.scanner = new Scanner(machine);
        this.parser = new Parser(this.scanner, machine);
    }
}

