/*
 * Decompiled with CFR 0.152.
 */
package cpusim.microinstruction;

import cpusim.Machine;
import cpusim.Microinstruction;
import cpusim.microinstruction.Decode;
import cpusim.microinstruction.MicroFactory;
import cpusim.module.Register;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;

public class DecodeFactory
extends MicroFactory {
    private Vector currentMicros;
    private Decode prototype;

    public DecodeFactory(Machine machine) {
        super(machine);
        this.currentMicros = machine.getMicros("decode");
        Register r = machine.getAllRegisters().size() == 0 ? null : (Register)machine.getAllRegisters().elementAt(0);
        this.prototype = new Decode("???", r, machine);
        this.clones = (Microinstruction[])this.createClones();
    }

    @Override
    public HashMap getCellEditors() {
        HashMap<String, DefaultCellEditor> editors = new HashMap<String, DefaultCellEditor>();
        Vector registers = this.machine.getAllRegisters();
        JComboBox irsCombo = new JComboBox(registers);
        editors.put("ir", new DefaultCellEditor(irsCombo));
        return editors;
    }

    @Override
    Microinstruction getPrototype() {
        return this.prototype;
    }

    @Override
    Class getMicroClass() {
        return Decode.class;
    }

    @Override
    public Vector getCurrentMicros() {
        return this.currentMicros;
    }

    @Override
    public String toString() {
        return "Decode";
    }

    @Override
    public String[] getProperties() {
        return new String[]{"name", "ir"};
    }

    @Override
    public boolean checkValidity(Object[] micros) {
        Microinstruction[] decodes = new Decode[micros.length];
        for (int i = 0; i < decodes.length; ++i) {
            decodes[i] = (Decode)micros[i];
        }
        return this.allNamesAreUnique(decodes) && !this.someNamesAreEmpty(decodes);
    }

    @Override
    public void updateCurrentMicrosFromClones() {
        this.machine.setMicros("decode", this.createNewMicroList(this.clones));
    }

    @Override
    public void setClones(Object[] newClones) {
        Decode[] decodes = new Decode[newClones.length];
        for (int i = 0; i < newClones.length; ++i) {
            decodes[i] = (Decode)newClones[i];
        }
        this.clones = decodes;
    }

    @Override
    public boolean newMicrosAreAllowed() {
        return this.machine.getModule("registers").size() > 0 || this.machine.getModule("registerArrays").size() > 0;
    }

    @Override
    public String getHelpPageID() {
        return "Decode";
    }
}

