/*
 * Decompiled with CFR 0.152.
 */
package cpusim.microinstruction;

import cpusim.Machine;
import cpusim.Microinstruction;
import cpusim.microinstruction.MicroFactory;
import cpusim.microinstruction.TransferRtoA;
import cpusim.module.Register;
import cpusim.module.RegisterArray;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;

public class TransferRtoAFactory
extends MicroFactory {
    private Vector currentMicros;
    private TransferRtoA prototype;

    public TransferRtoAFactory(Machine machine) {
        super(machine);
        this.currentMicros = machine.getMicros("transferRtoA");
        RegisterArray a = machine.getModule("registerArrays").size() == 0 ? null : (RegisterArray)machine.getModule("registerArrays").elementAt(0);
        Register r = a == null ? null : a.registers()[0];
        this.prototype = new TransferRtoA("???", r, 0, a, r, 0, 0);
        this.clones = (Microinstruction[])this.createClones();
    }

    @Override
    public HashMap getCellEditors() {
        HashMap<String, DefaultCellEditor> editors = new HashMap<String, DefaultCellEditor>();
        Vector registers = this.machine.getAllRegisters();
        JComboBox sourceCombo = new JComboBox(registers);
        editors.put("source", new DefaultCellEditor(sourceCombo));
        JComboBox destCombo = new JComboBox(this.machine.getModule("registerArrays"));
        editors.put("dest", new DefaultCellEditor(destCombo));
        JComboBox indexCombo = new JComboBox(registers);
        editors.put("index", new DefaultCellEditor(indexCombo));
        return editors;
    }

    @Override
    Microinstruction getPrototype() {
        return this.prototype;
    }

    @Override
    Class getMicroClass() {
        return TransferRtoA.class;
    }

    @Override
    public Vector getCurrentMicros() {
        return this.currentMicros;
    }

    @Override
    public String toString() {
        return "TransferRtoA";
    }

    @Override
    public String[] getProperties() {
        return new String[]{"name", "source", "srcStartBit", "dest", "destStartBit", "numBits", "index", "indexStart", "indexNumBits"};
    }

    @Override
    public void updateCurrentMicrosFromClones() {
        this.machine.setMicros("transferRtoA", this.createNewMicroList(this.clones));
    }

    @Override
    public void setClones(Object[] newClones) {
        TransferRtoA[] transferRtoAs = new TransferRtoA[newClones.length];
        for (int i = 0; i < newClones.length; ++i) {
            transferRtoAs[i] = (TransferRtoA)newClones[i];
        }
        this.clones = transferRtoAs;
    }

    @Override
    public boolean checkValidity(Object[] micros) {
        Microinstruction[] transferRtoAs = new TransferRtoA[micros.length];
        for (int i = 0; i < micros.length; ++i) {
            transferRtoAs[i] = (TransferRtoA)micros[i];
        }
        return this.allNamesAreUnique(transferRtoAs) && !this.someNamesAreEmpty(transferRtoAs) && this.rangesAreInBound((TransferRtoA[])transferRtoAs);
    }

    public boolean rangesAreInBound(TransferRtoA[] transferRtoAs) {
        boolean startProblem = false;
        String boundPhrase = "";
        for (int i = 0; i < transferRtoAs.length; ++i) {
            TransferRtoA temp = transferRtoAs[i];
            int srcStartBit = temp.getSrcStartBit();
            int destStartBit = temp.getDestStartBit();
            int numBits = temp.getNumBits();
            int indexNumBits = temp.getIndexNumBits();
            int indexStart = temp.getIndexStart();
            if (srcStartBit < 0 || destStartBit < 0 || numBits < 0 || indexStart < 0) {
                this.displayError("You have a negative value for one of the start bits or the number of bits\nin the microinstruction \"" + temp.getName() + "\".");
                return false;
            }
            if (srcStartBit > temp.getSource().getWidth()) {
                startProblem = true;
                boundPhrase = "srcStartBit";
            } else if (destStartBit > temp.getDest().getWidth()) {
                startProblem = true;
                boundPhrase = "destStartBit";
            } else if (indexStart > temp.getIndex().getWidth()) {
                startProblem = true;
                boundPhrase = "indexStart";
            }
            if (startProblem) {
                this.displayError(boundPhrase + " has an invalid value for the " + "specified register in instruction " + temp.getName() + ".\nIt must be non-negative, and less than the " + "register's length.");
                return false;
            }
            if (indexNumBits <= 0) {
                this.displayError("A positive number of bits must be specified for the index register.");
                return false;
            }
            if (srcStartBit + numBits > temp.getSource().getWidth() || destStartBit + numBits > temp.getDest().getWidth()) {
                this.displayError("The number of bits being transferred is too large to fit in the source register or the destination array.\nPlease specify a new start bit or a smaller number of bits to copy in the microinstruction \"" + temp.getName() + ".\"");
                return false;
            }
            if (indexStart + indexNumBits <= temp.getIndex().getWidth()) continue;
            this.displayError("The number of bits specified in the index register is too large to fit in the index register.\nPlease specify a new start bit or a smaller number of bits in the microinstruction \"" + temp.getName() + ".\"");
            return false;
        }
        return true;
    }

    @Override
    public boolean newMicrosAreAllowed() {
        return this.machine.getModule("registerArrays").size() > 0;
    }

    @Override
    public String getHelpPageID() {
        return "Transfer";
    }
}

