/*
 * Decompiled with CFR 0.152.
 */
package cpusim.util;

import cpusim.gui.Desktop;
import cpusim.gui.RAMWindow;
import cpusim.gui.RegistersWindow;
import cpusim.module.RAM;
import cpusim.module.Register;
import cpusim.module.RegisterArray;
import cpusim.scrollabledesktop.BaseInternalFrame;
import cpusim.util.BackupManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OutlineChangesManager {
    private Map<RAM, HashMap<Integer, Long>> ramMap;
    private Set<Register> registerSet;
    private Desktop desktop;
    private BackupManager backups;

    public OutlineChangesManager(BackupManager backups, Desktop desktop) {
        this.backups = backups;
        this.desktop = desktop;
        this.registerSet = new HashSet<Register>();
        this.ramMap = new HashMap<RAM, HashMap<Integer, Long>>();
    }

    public void updateOutlines() {
        this.ramMap.clear();
        this.registerSet.clear();
        this.getRamAndRegChangesFromBackupManager();
        this.updateRamAndRegOutlines();
    }

    public void clearAllOutlines() {
        this.ramMap.clear();
        this.registerSet.clear();
        this.updateRamAndRegOutlines();
    }

    private void getRamAndRegChangesFromBackupManager() {
        HashMap latestBackupTable = this.backups.getLatestBackup();
        for (Object module : latestBackupTable.keySet()) {
            if (module instanceof Register) {
                this.registerSet.add((Register)module);
                continue;
            }
            if (!(module instanceof RAM)) continue;
            RAM ram = (RAM)module;
            this.ramMap.put(ram, (HashMap)latestBackupTable.get(ram));
        }
    }

    private void updateRamAndRegOutlines() {
        for (Object key : this.desktop.getModuleWindows().keySet()) {
            BaseInternalFrame window;
            if (key instanceof RAM) {
                RAM ram = (RAM)key;
                window = (RAMWindow)this.desktop.getModuleWindows().get(ram);
                HashMap<Integer, Long> tempRam = this.ramMap.get(ram);
                if (tempRam != null) {
                    ((RAMWindow)window).outlineRows(tempRam.keySet());
                    continue;
                }
                ((RAMWindow)window).outlineRows(new HashSet<Integer>());
                continue;
            }
            if (key instanceof RegisterArray) {
                RegisterArray registerArray = (RegisterArray)key;
                window = (RegistersWindow)this.desktop.getModuleWindows().get(registerArray);
                ((RegistersWindow)window).outlineRows(this.registerSet);
                continue;
            }
            if (!key.equals("Registers")) continue;
            RegistersWindow window2 = (RegistersWindow)this.desktop.getModuleWindows().get(key);
            window2.outlineRows(this.registerSet);
        }
    }
}

