/*
 * Decompiled with CFR 0.152.
 */
package acm.gui;

import acm.gui.TableConstraints;
import acm.util.ErrorException;
import acm.util.OptionTable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.swing.JScrollBar;
import javax.swing.JSlider;

public class TableLayout
implements LayoutManager2,
Serializable {
    public static final int NONE = 0;
    public static final int HORIZONTAL = 2;
    public static final int VERTICAL = 3;
    public static final int BOTH = 1;
    public static final int CENTER = 10;
    public static final int LEFT = 11;
    public static final int RIGHT = 12;
    public static final int TOP = 13;
    public static final int BOTTOM = 14;
    public static final int FILL = 1;
    private static final int LAYOUT_CONTAINER_MODE = 0;
    private static final int MINIMUM_LAYOUT_SIZE_MODE = 1;
    private static final int PREFERRED_LAYOUT_SIZE_MODE = 2;
    private static final int MINIMUM_SCROLLBAR_SIZE = 100;
    private transient Container targetContainer;
    private HashMap<Component, GridBagConstraints> constraintTable;
    private HashMap<Component, TableConstraints> layoutTable;
    private HashMap<String, Object> propertyTable;
    private boolean useStrictGridBagModel;
    private int nRows;
    private int nColumns;
    private int horizontalAlignment;
    private int verticalAlignment;
    private int defaultFill;
    private int hGap;
    private int vGap;
    static final long serialVersionUID = 1L;

    public TableLayout() {
        this(0, 0);
    }

    public TableLayout(int rows, int columns) {
        this(rows, columns, 0, 0);
    }

    public TableLayout(int rows, int columns, int hgap, int vgap) {
        this.nRows = rows;
        this.nColumns = columns;
        this.hGap = hgap;
        this.vGap = vgap;
        this.horizontalAlignment = 10;
        this.verticalAlignment = 10;
        this.defaultFill = 1;
        this.constraintTable = new HashMap();
        this.propertyTable = new HashMap();
        this.layoutTable = null;
    }

    public void setColumnCount(int columns) {
        this.nColumns = columns;
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public int getColumnCount() {
        return this.nColumns;
    }

    public void setRowCount(int rows) {
        this.nRows = rows;
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public int getRowCount() {
        return this.nRows;
    }

    public void setHorizontalAlignment(int align) {
        this.horizontalAlignment = align;
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setVerticalAlignment(int align) {
        this.verticalAlignment = align;
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setDefaultFill(int fill) {
        this.defaultFill = fill;
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public int getDefaultFill() {
        return this.defaultFill;
    }

    public void setHgap(int pixels) {
        this.hGap = pixels;
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public int getHgap() {
        return this.hGap;
    }

    public void setVgap(int pixels) {
        this.vGap = pixels;
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public int getVgap() {
        return this.vGap;
    }

    public void setStrictGridBagModel(boolean flag) {
        this.useStrictGridBagModel = flag;
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public boolean isStrictGridBagModel() {
        return this.useStrictGridBagModel;
    }

    public void setConstraints(Component comp, GridBagConstraints constraints) {
        this.constraintTable.put(comp, (GridBagConstraints)constraints.clone());
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public void setConstraints(Component comp, String constraints) {
        this.setConstraints(comp, new TableConstraints(constraints));
    }

    public TableConstraints getConstraints(Component comp) {
        GridBagConstraints gbc = this.lookupConstraints(comp);
        return gbc == null ? null : new TableConstraints(gbc);
    }

    @Override
    public void addLayoutComponent(String constraints, Component comp) {
        this.addLayoutComponent(comp, constraints);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.constraintTable.remove(comp);
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        if (target.getComponentCount() == 0) {
            return new Dimension(0, 0);
        }
        return this.processLayout(target, 2);
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        if (target.getComponentCount() == 0) {
            return new Dimension(0, 0);
        }
        return this.processLayout(target, 1);
    }

    @Override
    public void layoutContainer(Container target) {
        this.targetContainer = target;
        this.processLayout(target, 0);
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints == null) {
            constraints = new TableConstraints("");
            ((TableConstraints)constraints).fill = this.defaultFill;
        } else if (constraints instanceof String) {
            OptionTable options = new OptionTable(((String)constraints).toLowerCase(), TableConstraints.LEGAL_KEYS);
            constraints = new TableConstraints(options.getMap());
            if (!options.isSpecified("fill")) {
                ((TableConstraints)constraints).fill = options.isSpecified("anchor") ? 0 : this.defaultFill;
            }
        } else if (!(constraints instanceof GridBagConstraints)) {
            throw new ErrorException("TableLayout: Illegal constraints");
        }
        this.constraintTable.put(comp, (GridBagConstraints)constraints);
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public synchronized void invalidateLayout(Container target) {
        this.layoutTable = null;
        for (String key : this.propertyTable.keySet()) {
            if (key.startsWith("width") && !key.equals("width")) {
                this.propertyTable.put(key, new Integer(0));
            }
            if (key.startsWith("height") && !key.equals("height")) {
                this.propertyTable.put(key, new Integer(0));
            }
            if (key.startsWith("weightx") && !key.equals("weightx")) {
                this.propertyTable.put(key, new Double(0.0));
            }
            if (!key.startsWith("weighty") || key.equals("weighty")) continue;
            this.propertyTable.put(key, new Double(0.0));
        }
    }

    public String toString() {
        String str = this.getClass().getName();
        str = str + "[rows=" + this.nRows + ",columns=" + this.nColumns;
        if (this.hGap != 0) {
            str = str + ",hgap=" + this.hGap;
        }
        if (this.vGap != 0) {
            str = str + ",vgap=" + this.vGap;
        }
        str = str + "]";
        return str;
    }

    protected GridBagConstraints lookupConstraints(Component comp) {
        return this.constraintTable.get(comp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TableConstraints lookupConstraints(Component comp, Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            if (this.layoutTable == null) {
                this.computeLayoutTable(target);
            }
            return this.layoutTable.get(comp);
        }
    }

    private Dimension getMinimumComponentSize(Component comp) {
        if (this.isScrollbar(comp)) {
            return this.getMinimumScrollbarSize(comp);
        }
        return comp.getMinimumSize();
    }

    private Dimension getPreferredComponentSize(Component comp) {
        if (this.isScrollbar(comp)) {
            return this.getMinimumScrollbarSize(comp);
        }
        return comp.getPreferredSize();
    }

    private boolean isScrollbar(Component comp) {
        return comp instanceof Scrollbar || comp instanceof JScrollBar || comp instanceof JSlider;
    }

    private Dimension getMinimumScrollbarSize(Component comp) {
        Dimension size = comp.getMinimumSize();
        try {
            Class<?> scrollbarClass = comp.getClass();
            Method getOrientation = scrollbarClass.getMethod("getOrientation", new Class[0]);
            int orientation = (Integer)getOrientation.invoke((Object)comp, new Object[0]);
            if (orientation == 0) {
                size.width = Math.max(size.width, 100);
            } else {
                size.height = Math.max(size.height, 100);
            }
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension processLayout(Container target, int caller) {
        Object object = target.getTreeLock();
        synchronized (object) {
            return this.lockedProcessLayout(target, caller);
        }
    }

    private synchronized Dimension lockedProcessLayout(Container target, int caller) {
        Dimension result = null;
        if (this.layoutTable == null) {
            this.computeLayoutTable(target);
        }
        int nr = this.getIntProperty("nRows");
        int nc = this.getIntProperty("nColumns");
        int[] heights = new int[nr];
        int[] widths = new int[nc];
        int nComponents = target.getComponentCount();
        for (int i = 0; i < nComponents; ++i) {
            Component comp = target.getComponent(i);
            TableConstraints tc = this.layoutTable.get(comp);
            int column = tc.gridx;
            int row = tc.gridy;
            int width = this.getIntProperty("width" + column);
            int height = this.getIntProperty("height" + row);
            if (width == 0) {
                width = caller == 1 || this.useStrictGridBagModel ? this.getMinimumComponentSize((Component)comp).width : this.getPreferredComponentSize((Component)comp).width;
                width += 2 * tc.ipadx + tc.insets.left + tc.insets.right;
            }
            if (height == 0) {
                height = caller == 1 || this.useStrictGridBagModel ? this.getMinimumComponentSize((Component)comp).height : this.getPreferredComponentSize((Component)comp).height;
                height += 2 * tc.ipady + tc.insets.top + tc.insets.bottom;
            }
            if (tc.gridwidth <= 1) {
                widths[column] = Math.max(widths[column], width);
            }
            if (tc.gridheight > 1) continue;
            heights[row] = Math.max(heights[row], height);
        }
        int width = this.hGap;
        int height = this.vGap;
        double[] weightX = new double[nc];
        double[] weightY = new double[nr];
        double totalX = 0.0;
        double totalY = 0.0;
        for (int column = 0; column < nc; ++column) {
            width += widths[column] + this.hGap;
            weightX[column] = this.getDoubleProperty("weightx" + column);
            totalX += weightX[column];
        }
        for (int row = 0; row < nr; ++row) {
            height += heights[row] + this.vGap;
            weightY[row] = this.getDoubleProperty("weighty" + row);
            totalY += weightY[row];
        }
        if (caller == 0) {
            Dimension size = target.getSize();
            Insets insets = target.getInsets();
            size.width -= insets.left + insets.right;
            size.height -= insets.top + insets.bottom;
            int extraX = size.width - width;
            int extraY = size.height - height;
            int startX = insets.left;
            int startY = insets.top;
            if (totalX == 0.0) {
                switch (this.horizontalAlignment) {
                    case 11: {
                        extraX = 0;
                        break;
                    }
                    case 10: {
                        startX += extraX / 2;
                        extraX = 0;
                        break;
                    }
                    case 12: {
                        startX += extraX;
                        extraX = 0;
                        break;
                    }
                    case 1: {
                        totalX = nc;
                        for (int column = 0; column < nc; ++column) {
                            weightX[column] = 1.0;
                        }
                        break;
                    }
                }
            }
            if (totalY == 0.0) {
                switch (this.verticalAlignment) {
                    case 13: {
                        extraY = 0;
                        break;
                    }
                    case 10: {
                        startY += extraY / 2;
                        extraY = 0;
                        break;
                    }
                    case 14: {
                        startY += extraY;
                        extraY = 0;
                        break;
                    }
                    case 1: {
                        totalY = nr;
                        for (int row = 0; row < nr; ++row) {
                            weightY[row] = 1.0;
                        }
                        break;
                    }
                }
            }
            int[] xc = new int[nc];
            int x = this.hGap + startX;
            for (int column = 0; column < nc; ++column) {
                xc[column] = x;
                if (extraX > 0) {
                    int pad = (int)Math.round((double)extraX * weightX[column] / totalX);
                    int n = column;
                    widths[n] = widths[n] + pad;
                    extraX -= pad;
                    totalX -= weightX[column];
                }
                x += widths[column] + this.hGap;
            }
            int[] yc = new int[nr];
            int y = this.vGap + startY;
            for (int row = 0; row < nr; ++row) {
                yc[row] = y;
                if (extraY > 0) {
                    int pad = (int)Math.round((double)extraY * weightY[row] / totalY);
                    int n = row;
                    heights[n] = heights[n] + pad;
                    extraY -= pad;
                    totalY -= weightY[row];
                }
                y += heights[row] + this.vGap;
            }
            for (int i = 0; i < nComponents; ++i) {
                Component comp = target.getComponent(i);
                TableConstraints tc = this.layoutTable.get(comp);
                int column = tc.gridx;
                int row = tc.gridy;
                int bx = xc[column] + tc.insets.left;
                int by = yc[row] + tc.insets.top;
                int bw = widths[column];
                for (int ix = 1; ix < tc.gridwidth && column + ix < nc; ++ix) {
                    bw += widths[column + ix] + this.hGap;
                }
                bw -= tc.insets.left + tc.insets.right;
                int bh = heights[row];
                for (int iy = 1; iy < tc.gridheight && row + iy < nr; ++iy) {
                    bh += heights[row + iy] + this.vGap;
                }
                Dimension pSize = this.useStrictGridBagModel ? this.getMinimumComponentSize(comp) : this.getPreferredComponentSize(comp);
                Rectangle bounds = this.computeCellBounds(new Rectangle(bx, by, bw, bh -= tc.insets.top + tc.insets.bottom), pSize, tc);
                comp.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
            }
        } else {
            result = new Dimension(width, height);
        }
        return result;
    }

    private void computeLayoutTable(Container target) {
        int[] unfinishedSpans = null;
        int row = 0;
        int column = 0;
        int layoutColumns = this.nColumns;
        int nComponents = target.getComponentCount();
        boolean nextEndRow = false;
        this.layoutTable = new HashMap();
        for (int i = 0; i < nComponents; ++i) {
            int c;
            Component comp = target.getComponent(i);
            TableConstraints tc = this.getConstraints(comp);
            if (tc.gridx != -1) {
                column = tc.gridx;
            }
            if (tc.gridy != -1) {
                row = tc.gridy;
            }
            if (this.nRows > 0 && row >= this.nRows) {
                throw new ErrorException("TableLayout: Too many rows specified");
            }
            while (unfinishedSpans != null && column < unfinishedSpans.length && unfinishedSpans[column] > 0) {
                if (layoutColumns <= 0 || ++column < layoutColumns) continue;
                for (int c2 = 0; c2 < unfinishedSpans.length; ++c2) {
                    if (unfinishedSpans[c2] <= 0) continue;
                    int n = c2;
                    unfinishedSpans[n] = unfinishedSpans[n] - true;
                }
                ++row;
                column = this.getFirstAvailableColumn(unfinishedSpans);
            }
            tc.gridx = column;
            tc.gridy = row;
            boolean endrow = nextEndRow;
            this.setMaxProperty("width" + column, tc.width);
            this.setMaxProperty("height" + row, tc.height);
            this.setMaxProperty("weightx" + column, tc.weightx);
            this.setMaxProperty("weighty" + row, tc.weighty);
            int colspan = 1;
            switch (tc.gridwidth) {
                case 0: {
                    endrow = true;
                    if (layoutColumns <= 0) break;
                    colspan = layoutColumns - column;
                    break;
                }
                case -1: {
                    if (layoutColumns <= 0) {
                        throw new ErrorException("TableLayout: Illegal to use gridwidth=RELATIVE in first row");
                    }
                    colspan = layoutColumns - column - 1;
                    nextEndRow = true;
                    break;
                }
                default: {
                    colspan = tc.gridwidth;
                    boolean bl = endrow = this.nColumns > 0 && column + tc.gridwidth >= this.nColumns;
                }
            }
            if (colspan > 1 && unfinishedSpans != null) {
                for (int c3 = column; c3 < Math.min(unfinishedSpans.length, column + colspan); ++c3) {
                    if (unfinishedSpans[c3] == false) continue;
                    throw new ErrorException("TableLayout: Overlapping cells");
                }
            }
            int rowspan = 1;
            switch (tc.gridheight) {
                case 0: {
                    rowspan = Integer.MAX_VALUE;
                    break;
                }
                case -1: {
                    throw new ErrorException("TableLayout: Illegal to use gridheight=RELATIVE");
                }
                default: {
                    rowspan = tc.gridheight;
                }
            }
            if (rowspan > 1) {
                if (unfinishedSpans == null) {
                    unfinishedSpans = new int[column + colspan];
                } else if (unfinishedSpans.length < column + colspan) {
                    int[] oldSpans = unfinishedSpans;
                    unfinishedSpans = new int[column + colspan];
                    System.arraycopy(oldSpans, 0, unfinishedSpans, 0, oldSpans.length);
                }
                for (c = column; c < column + colspan; ++c) {
                    unfinishedSpans[c] = rowspan;
                }
            }
            tc.gridwidth = colspan;
            tc.gridheight = rowspan;
            this.layoutTable.put(comp, tc);
            column += colspan;
            while (endrow || layoutColumns > 0 && column >= layoutColumns) {
                if (layoutColumns <= 0) {
                    layoutColumns = column;
                }
                if (unfinishedSpans != null) {
                    for (c = 0; c < unfinishedSpans.length; ++c) {
                        if (unfinishedSpans[c] <= 0) continue;
                        int n = c;
                        unfinishedSpans[n] = unfinishedSpans[n] - 1;
                    }
                }
                ++row;
                column = this.getFirstAvailableColumn(unfinishedSpans);
                endrow = false;
            }
        }
        if (layoutColumns <= 0) {
            layoutColumns = column;
        }
        this.setIntProperty("nColumns", layoutColumns);
        this.setIntProperty("nRows", row + 1);
    }

    private Rectangle computeCellBounds(Rectangle enclosure, Dimension psize, TableConstraints tc) {
        int x = enclosure.x;
        int y = enclosure.y;
        int width = enclosure.width;
        int height = enclosure.height;
        if (tc.fill == 0 || tc.fill == 3) {
            width = psize.width;
        }
        if (tc.fill == 0 || tc.fill == 2) {
            height = psize.height;
        }
        if (width != enclosure.width) {
            switch (tc.anchor) {
                case 10: 
                case 11: 
                case 15: {
                    x += (enclosure.width - width) / 2;
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    x += enclosure.width - width;
                }
            }
        }
        if (height != enclosure.height) {
            switch (tc.anchor) {
                case 10: 
                case 13: 
                case 17: {
                    y += (enclosure.height - height) / 2;
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    y += enclosure.height - height;
                }
            }
        }
        return new Rectangle(x, y, width, height);
    }

    private void setMaxProperty(String key, int value) {
        this.setIntProperty(key, Math.max(value, this.getIntProperty(key)));
    }

    private void setMaxProperty(String key, double value) {
        this.setDoubleProperty(key, Math.max(value, this.getDoubleProperty(key)));
    }

    private void setIntProperty(String key, int value) {
        this.propertyTable.put(key, new Integer(value));
    }

    private int getIntProperty(String key) {
        Object binding = this.propertyTable.get(key);
        if (binding == null) {
            return 0;
        }
        return (Integer)binding;
    }

    private void setDoubleProperty(String key, double value) {
        this.propertyTable.put(key, new Double(value));
    }

    private double getDoubleProperty(String key) {
        Object binding = this.propertyTable.get(key);
        if (binding == null) {
            return 0.0;
        }
        return (Double)binding;
    }

    private int getFirstAvailableColumn(int[] unfinishedSpans) {
        if (this.useStrictGridBagModel && unfinishedSpans != null) {
            for (int column = unfinishedSpans.length; column > 0; --column) {
                if (unfinishedSpans[column - 1] <= 0) continue;
                return column;
            }
        }
        return 0;
    }
}

