/*
 * Decompiled with CFR 0.152.
 */
package cpusim.assembler;

public class Token {
    public final String filename;
    public final String contents;
    public final int type;
    public final int lineNumber;
    public final int columnNumber;
    public final int offset;
    public final boolean isLegal;
    public static final int ERROR = -1;
    public static final int OPCODE = 0;
    public static final int DATA = 1;
    public static final int VAR = 2;
    public static final int EOL = 3;
    public static final int LABEL = 4;
    public static final int CONSTANT = 5;
    public static final int EQU = 6;
    public static final int COMMA = 7;
    public static final int EOF = 8;
    public static final int COMMENT = 9;
    public static final int MACRO = 10;
    public static final int ENDM = 11;
    public static final int LBRACKET = 12;
    public static final int RBRACKET = 13;
    public static final int INCLUDE = 14;
    public static final int ASCII = 15;
    public static final int QUOTEDSTRING = 16;
    public static final int LPARENTHESIS = 19;
    public static final int RPARENTHESIS = 20;
    public static final int PUNCTUATION = 21;
    public static final int ALIGN = 22;
    public static final int POS = 23;
    public static final int LONG = 24;
    public static final int SHORT = 25;

    public Token(String filename, int type, int line, int column, int offset, String contents, boolean isLegal) {
        this.filename = filename;
        this.type = type;
        this.contents = contents;
        this.lineNumber = line;
        this.columnNumber = column;
        this.offset = offset;
        this.isLegal = isLegal;
    }

    public String toString() {
        return this.contents;
    }

    public String getTokenTypeString() {
        if (this.type == -1) {
            return "ERROR";
        }
        if (this.type == 0) {
            return "OPCODE";
        }
        if (this.type == 1) {
            return "DATA";
        }
        if (this.type == 2) {
            return "VAR";
        }
        if (this.type == 3) {
            return "EOL";
        }
        if (this.type == 4) {
            return "LABEL";
        }
        if (this.type == 5) {
            return "CONSTANT";
        }
        if (this.type == 6) {
            return "EQU";
        }
        if (this.type == 7) {
            return "COMMA";
        }
        if (this.type == 8) {
            return "EOF";
        }
        if (this.type == 9) {
            return "COMMENT";
        }
        if (this.type == 10) {
            return "MACRO";
        }
        if (this.type == 11) {
            return "ENDM";
        }
        if (this.type == 12) {
            return "LBRACKET";
        }
        if (this.type == 13) {
            return "RBRACKET";
        }
        if (this.type == 16) {
            return "QUOTEDSTRING";
        }
        if (this.type == 15) {
            return "ASCII";
        }
        if (this.type == 14) {
            return "INCLUDE";
        }
        return "TOKEN TYPE UNKNOWN: " + this.type;
    }

    public boolean isLegal() {
        return this.isLegal;
    }

    public int hashCode() {
        return this.contents.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Token)) {
            return false;
        }
        Token t = (Token)o;
        return t.contents.equals(this.contents);
    }
}

