/*
 * Decompiled with CFR 0.152.
 */
package cpusim.gui;

import cpusim.Machine;
import cpusim.assembler.EQU;
import cpusim.gui.EQUFactory;
import cpusim.gui.EditDialog;
import cpusim.gui.LangUnit;
import cpusim.util.Assert;
import cpusim.util.Convert;
import cpusim.util.DecimalTableCellRenderer;
import cpusim.util.ExtendedJTable;
import cpusim.util.Factory;
import cpusim.util.OOTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class EQUDialog
extends EditDialog {
    private EQUFactory currentFactory;

    public EQUDialog(Frame parent, Machine machine) {
        super(parent, LangUnit.LU_GLOBAL_EQUS.str(), true);
        Container contentPane = this.getContentPane();
        this.machine = machine;
        this.currentFactory = new EQUFactory(machine);
        this.currentFactory.setParentFrame(this);
        contentPane.add((Component)this.createEQUPanel(), "Center");
        contentPane.add((Component)this.createBottomButtonPanel(), "South");
    }

    @Override
    protected Factory getCurrentFactory() {
        return this.currentFactory;
    }

    @Override
    protected void updateMachine() {
        Vector equVector = Convert.toVector(this.getObjectList());
        this.machine.setEQUs(equVector);
    }

    private ExtendedJTable createExtendedJTable() {
        ExtendedJTable equTable = null;
        OOTableModel model = null;
        Object[] clones = (EQU[])this.currentFactory.createClones();
        HashMap<String, DecimalTableCellRenderer> renderers = new HashMap<String, DecimalTableCellRenderer>();
        renderers.put("value", new DecimalTableCellRenderer());
        try {
            model = new OOTableModel(clones);
            model.setColumns(new String[]{"name", "value"});
        }
        catch (IntrospectionException e) {
            Assert.That(false, LangUnit.LU_EXCEPT_TAB_EQUS.str());
        }
        equTable = new ExtendedJTable((TableModel)model, null, renderers);
        equTable.setSelectionMode(0);
        equTable.getSelectionModel().addListSelectionListener(new ExtendedTableSelectionListener());
        return equTable;
    }

    private JPanel createNewDeleteDuplicateButtonPanel() {
        JPanel buttonPanel = new JPanel();
        this.newButton = new JButton(LangUnit.LU_NEW.str());
        this.newButton.setToolTipText(LangUnit.LU_CREATE_EQU.str());
        this.newButton.addActionListener(new EditDialog.NewButtonListener());
        buttonPanel.add(this.newButton);
        this.deleteButton = new JButton(LangUnit.LU_DELETE.str());
        this.deleteButton.setToolTipText(LangUnit.LU_EQU_DEL.str());
        this.deleteButton.addActionListener(new DeleteButtonListener());
        buttonPanel.add(this.deleteButton);
        this.duplicateButton = new JButton(LangUnit.LU_DUPLICATE.str());
        this.duplicateButton.setToolTipText(LangUnit.LU_EQU_DUP.str());
        this.duplicateButton.addActionListener(new EditDialog.DuplicateButtonListener());
        buttonPanel.add(this.duplicateButton);
        this.deleteButton.setEnabled(false);
        this.duplicateButton.setEnabled(false);
        return buttonPanel;
    }

    private JPanel createEQUPanel() {
        JPanel equPanel = new JPanel();
        equPanel.setLayout(new BorderLayout());
        equPanel.add((Component)this.createNewDeleteDuplicateButtonPanel(), "South");
        this.table = this.createExtendedJTable();
        Dimension tablePreferredSize = this.table.getPreferredScrollableViewportSize();
        equPanel.setPreferredSize(new Dimension(tablePreferredSize.width, 120));
        equPanel.add((Component)new JScrollPane(this.table), "Center");
        equPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        return equPanel;
    }

    class DeleteButtonListener
    implements ActionListener {
        DeleteButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TableCellEditor editor = EQUDialog.this.table.getCellEditor();
            if (editor != null && !editor.stopCellEditing()) {
                return;
            }
            if (EQUDialog.this.table.getSelectedRow() == -1) {
                Assert.That(false, LangUnit.LU_DEL_NONE.str());
                return;
            }
            EQUDialog.this.table.deleteSelectedRowWithoutWarning();
            EQUDialog.this.deleteButton.setEnabled(false);
            EQUDialog.this.duplicateButton.setEnabled(false);
        }
    }

    class ExtendedTableSelectionListener
    implements ListSelectionListener {
        ExtendedTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int selectedRow = EQUDialog.this.table.getSelectedRow();
            if (selectedRow == -1) {
                EQUDialog.this.deleteButton.setEnabled(false);
                EQUDialog.this.duplicateButton.setEnabled(false);
            } else {
                EQUDialog.this.deleteButton.setEnabled(true);
                EQUDialog.this.duplicateButton.setEnabled(true);
            }
        }
    }
}

