/*
 * Decompiled with CFR 0.152.
 */
package cpusim.microinstruction;

import cpusim.Machine;
import cpusim.Microinstruction;
import cpusim.microinstruction.Increment;
import cpusim.microinstruction.MicroFactory;
import cpusim.module.Register;
import cpusim.util.CPUSimConstants;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;

public class IncrementFactory
extends MicroFactory
implements CPUSimConstants {
    private Vector currentMicros;
    private Increment prototype;

    public IncrementFactory(Machine machine) {
        super(machine);
        this.currentMicros = machine.getMicros("increment");
        Register r = machine.getAllRegisters().size() == 0 ? null : (Register)machine.getAllRegisters().elementAt(0);
        this.prototype = new Increment("???", 1L, r, NO_CONDITIONBIT);
        this.clones = (Microinstruction[])this.createClones();
    }

    @Override
    public HashMap getCellEditors() {
        HashMap<String, DefaultCellEditor> editors = new HashMap<String, DefaultCellEditor>();
        Vector registers = this.machine.getAllRegisters();
        JComboBox registersCombo = new JComboBox(registers);
        editors.put("register", new DefaultCellEditor(registersCombo));
        Vector conditionBits = (Vector)this.machine.getModule("conditionBits").clone();
        conditionBits.addElement(NO_CONDITIONBIT);
        JComboBox conditionBitsCombo = new JComboBox(conditionBits);
        editors.put("overflowBit", new DefaultCellEditor(conditionBitsCombo));
        return editors;
    }

    @Override
    Microinstruction getPrototype() {
        return this.prototype;
    }

    @Override
    Class getMicroClass() {
        return Increment.class;
    }

    @Override
    public Vector getCurrentMicros() {
        return this.currentMicros;
    }

    @Override
    public String toString() {
        return "Increment";
    }

    @Override
    public String[] getProperties() {
        return new String[]{"name", "register", "overflowBit", "delta"};
    }

    @Override
    public void updateCurrentMicrosFromClones() {
        this.machine.setMicros("increment", this.createNewMicroList(this.clones));
    }

    @Override
    public void setClones(Object[] newClones) {
        Increment[] increments = new Increment[newClones.length];
        for (int i = 0; i < newClones.length; ++i) {
            increments[i] = (Increment)newClones[i];
        }
        this.clones = increments;
    }

    @Override
    public boolean checkValidity(Object[] micros) {
        Microinstruction[] increments = new Increment[micros.length];
        for (int i = 0; i < increments.length; ++i) {
            increments[i] = (Increment)micros[i];
        }
        return this.allNamesAreUnique(increments) && !this.someNamesAreEmpty(increments);
    }

    @Override
    public boolean newMicrosAreAllowed() {
        return this.machine.getModule("registers").size() > 0 || this.machine.getModule("registerArrays").size() > 0;
    }

    @Override
    public String getHelpPageID() {
        return "Increment";
    }
}

