/*
 * Decompiled with CFR 0.152.
 */
package cpusim.microinstruction;

import cpusim.Machine;
import cpusim.Microinstruction;
import cpusim.microinstruction.MicroFactory;
import cpusim.microinstruction.SetCondBit;
import cpusim.module.ConditionBit;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;

public class SetCondBitFactory
extends MicroFactory {
    private Vector currentMicros;
    private SetCondBit prototype;

    public SetCondBitFactory(Machine machine) {
        super(machine);
        this.currentMicros = machine.getMicros("setCondBit");
        ConditionBit cBit = machine.getModule("conditionBits").size() == 0 ? null : (ConditionBit)machine.getModule("conditionBits").elementAt(0);
        this.prototype = new SetCondBit("???", cBit, "0");
        this.clones = (Microinstruction[])this.createClones();
    }

    @Override
    public HashMap getCellEditors() {
        HashMap<String, DefaultCellEditor> editors = new HashMap<String, DefaultCellEditor>();
        Vector conditionBits = this.machine.getModule("conditionBits");
        JComboBox bitsCombo = new JComboBox(conditionBits);
        editors.put("bit", new DefaultCellEditor(bitsCombo));
        JComboBox<String> valueCombo = new JComboBox<String>(new String[]{"0", "1"});
        editors.put("value", new DefaultCellEditor(valueCombo));
        return editors;
    }

    @Override
    Microinstruction getPrototype() {
        return this.prototype;
    }

    @Override
    Class getMicroClass() {
        return SetCondBit.class;
    }

    @Override
    public Vector getCurrentMicros() {
        return this.currentMicros;
    }

    @Override
    public String toString() {
        return "SetCondBit";
    }

    @Override
    public String[] getProperties() {
        return new String[]{"name", "bit", "value"};
    }

    @Override
    public boolean checkValidity(Object[] micros) {
        Microinstruction[] setCondBits = new SetCondBit[micros.length];
        for (int i = 0; i < setCondBits.length; ++i) {
            setCondBits[i] = (SetCondBit)micros[i];
        }
        return this.allNamesAreUnique(setCondBits) && !this.someNamesAreEmpty(setCondBits);
    }

    @Override
    public void updateCurrentMicrosFromClones() {
        this.machine.setMicros("setCondBit", this.createNewMicroList(this.clones));
    }

    @Override
    public void setClones(Object[] newClones) {
        SetCondBit[] setCondBits = new SetCondBit[newClones.length];
        for (int i = 0; i < newClones.length; ++i) {
            setCondBits[i] = (SetCondBit)newClones[i];
        }
        this.clones = setCondBits;
    }

    @Override
    public boolean newMicrosAreAllowed() {
        return this.machine.getModule("conditionBits").size() > 0;
    }

    @Override
    public String getHelpPageID() {
        return "SetCondBit";
    }
}

