/*
 * Decompiled with CFR 0.152.
 */
package cpusim.microinstruction;

import cpusim.Microinstruction;
import cpusim.Module;
import cpusim.module.Register;
import cpusim.util.Assert;

public class TransferRtoR
extends Microinstruction {
    private Register source;
    private Register dest;
    private int srcStartBit;
    private int destStartBit;
    private int numBits;

    public TransferRtoR(String name, Register src, int fStart, Register dst, int tStart, int num) {
        super(name);
        this.source = src;
        this.srcStartBit = fStart;
        this.dest = dst;
        this.destStartBit = tStart;
        this.numBits = num;
    }

    public void setSource(Register r) {
        this.source = r;
    }

    public void setDest(Register r) {
        this.dest = r;
    }

    public void setSrcStartBit(int i) {
        this.srcStartBit = i;
    }

    public void setDestStartBit(int i) {
        this.destStartBit = i;
    }

    public void setNumBits(int i) {
        this.numBits = i;
    }

    public Register getSource() {
        return this.source;
    }

    public Register getDest() {
        return this.dest;
    }

    public int getSrcStartBit() {
        return this.srcStartBit;
    }

    public int getDestStartBit() {
        return this.destStartBit;
    }

    public int getNumBits() {
        return this.numBits;
    }

    @Override
    public Object clone() {
        return new TransferRtoR(this.getName(), this.source, this.srcStartBit, this.dest, this.destStartBit, this.numBits);
    }

    @Override
    public void copyDataTo(Microinstruction newMicro) {
        Assert.That(newMicro instanceof TransferRtoR, "Passed non-TransferRtoR to TransferRtoR.copyDataTo()");
        TransferRtoR newTransferRtoR = (TransferRtoR)newMicro;
        newTransferRtoR.setName(this.getName());
        newTransferRtoR.setSource(this.getSource());
        newTransferRtoR.setSrcStartBit(this.getSrcStartBit());
        newTransferRtoR.setDest(this.getDest());
        newTransferRtoR.setDestStartBit(this.getDestStartBit());
        newTransferRtoR.setNumBits(this.getNumBits());
    }

    @Override
    public boolean uses(Module m) {
        return m == this.source || m == this.dest;
    }

    @Override
    public void execute() {
        int sourceWidth = this.source.getWidth();
        int destWidth = this.dest.getWidth();
        long sourceValue = this.source.getValue() << 64 - sourceWidth;
        long destValue = this.dest.getValue() << 64 - destWidth;
        long leftDestPart = this.destStartBit == 0 ? 0L : destValue >>> 64 - this.destStartBit << 64 - this.destStartBit;
        long rightDestPart = this.destStartBit + this.numBits == 64 ? 0L : destValue << this.destStartBit + this.numBits >>> this.destStartBit + this.numBits;
        long middlePart = this.numBits == 0 ? 0L : sourceValue << this.srcStartBit >>> 64 - this.numBits << 64 - this.numBits >>> this.destStartBit;
        long result = leftDestPart | middlePart | rightDestPart;
        this.dest.setValue(result >>= 64 - destWidth);
    }

    @Override
    public String getXMLDescription() {
        return "<TransferRtoR name=\"" + this.getHTMLName() + "\" source=\"" + this.getSource().getID() + "\" srcStartBit=\"" + this.getSrcStartBit() + "\" dest=\"" + this.getDest().getID() + "\" destStartBit=\"" + this.getDestStartBit() + "\" numBits=\"" + this.getNumBits() + "\" id=\"" + this.getID() + "\" />";
    }

    @Override
    public String getHTMLDescription() {
        return "<TR><TD>" + this.getHTMLName() + "</TD><TD>" + this.getSource().getHTMLName() + "</TD><TD>" + this.getSrcStartBit() + "</TD><TD>" + this.getDest().getHTMLName() + "</TD><TD>" + this.getDestStartBit() + "</TD><TD>" + this.getNumBits() + "</TD></TR>";
    }
}

