/*
 * Decompiled with CFR 0.152.
 */
package cpusim.xml;

import cpusim.Field;
import cpusim.Machine;
import cpusim.MachineInstruction;
import cpusim.Microinstruction;
import cpusim.Module;
import cpusim.assembler.EQU;
import cpusim.assembler.PunctChar;
import java.io.PrintWriter;
import java.util.List;
import java.util.Vector;

public class MachineHTMLWriter {
    private final String HEADER_PREFIX = "<TR VALIGN=\"middle\"><TD bgcolor=\"#C08060\" COLSPAN=\"";
    private final String HEADER_MIDDLE = "\" HEIGHT=\"35\"><FONT  SIZE=\"+2\"><B>&nbsp;";
    private final String HEADER_SUFFIX = "</B></font></TD></TR>";
    private final String COL_HEADER_PREFIX = "<TR><TD><B>Name</B></TD><TD><B>";
    private final int[] MODULE_COLUMNS = new int[]{2, 3, 4, 2};
    private final int[] MICRO_COLUMNS = new int[]{5, 7, 4, 6, 5, 7, 2, 6, 9, 9, 2, 3, 5, 5};
    private String[] moduleHeaders = new String[]{"<TR VALIGN=\"middle\"><TD bgcolor=\"#C08060\" COLSPAN=\"2\" HEIGHT=\"35\"><FONT  SIZE=\"+2\"><B>&nbsp;Registers</B></font></TD></TR>", "<TR VALIGN=\"middle\"><TD bgcolor=\"#C08060\" COLSPAN=\"3\" HEIGHT=\"35\"><FONT  SIZE=\"+2\"><B>&nbsp;Register Arrays</B></font></TD></TR>", "<TR VALIGN=\"middle\"><TD bgcolor=\"#C08060\" COLSPAN=\"4\" HEIGHT=\"35\"><FONT  SIZE=\"+2\"><B>&nbsp;Condition Bits</B></font></TD></TR>", "<TR VALIGN=\"middle\"><TD bgcolor=\"#C08060\" COLSPAN=\"3\" HEIGHT=\"35\"><FONT  SIZE=\"+2\"><B>&nbsp;RAMs</B></font></TD></TR>"};
    private String[] moduleColumnHeaders = new String[]{"<TR><TD><B>Name</B></TD><TD><B>Width</B></TD></TR>", "<TR><TD><B>Name</B></TD><TD><B>Length</B></TD><TD><B>Width</B></TD></TR>", "<TR><TD><B>Name</B></TD><TD><B>Register</B></TD><TD><B>Bit</B></TD><TD><B>Halt</B></TD></TR>", "<TR><TD><B>Name</B></TD><TD><B>Length</B></TD><TD><B>Bits per Cell</B></TD></TR>"};
    private String[] microHeaders = new String[]{"<TR VALIGN=\"middle\"><TD bgcolor=\"#C08060\" COLSPAN=\"5\" HEIGHT=\"35\"><FONT  SIZE=\"+2\"><B>&nbsp;Set</B></font></TD></TR>", "<TR VALIGN=\"middle\"><TD bgcolor=\"#C08060\" COLSPAN=\"7\" HEIGHT=\"35\"><FONT  SIZE=\"+2\"><B>&nbsp;Test</B></font></TD></TR>", "<TR VALIGN=\"middle\"><TD bgcolor=\"#C08060\" COLSPAN=\"4\" HEIGHT=\"35\"><FONT  SIZE=\"+2\"><B>&nbsp;Increment</B></font></TD></TR>", "<TR VALIGN=\"middle\"><TD bgcolor=\"#C08060\" COLSPAN=\"6\" HEIGHT=\"35\"><FONT  SIZE=\"+2\"><B>&nbsp;Shift</B></font></TD></TR>", "<TR VALIGN=\"middle\"><TD bgcolor=\"#C08060\" COLSPAN=\"5\" HEIGHT=\"35\"><FONT  SIZE=\"+2\"><B>&nbsp;Logical</B></font></TD></TR>", "<TR VALIGN=\"middle\"><TD bgcolor=\"#C08060\" COLSPAN=\"7\" HEIGHT=\"35\"><FONT  SIZE=\"+2\"><B>&nbsp;Arithmetic</B></font></TD></TR>", "<TR VALIGN=\"middle\"><TD bgcolor=\"#C08060\" COLSPAN=\"2\" HEIGHT=\"35\"><FONT  SIZE=\"+2\"><B>&nbsp;Branch</B></font></TD></TR>", "<TR VALIGN=\"middle\"><TD bgcolor=\"#C08060\" COLSPAN=\"6\" HEIGHT=\"35\"><FONT  SIZE=\"+2\"><B>&nbsp;TransferRtoR</B></font></TD></TR>", "<TR VALIGN=\"middle\"><TD bgcolor=\"#C08060\" COLSPAN=\"9\" HEIGHT=\"35\"><FONT  SIZE=\"+2\"><B>&nbsp;TransferRtoA</B></font></TD></TR>", "<TR VALIGN=\"middle\"><TD bgcolor=\"#C08060\" COLSPAN=\"9\" HEIGHT=\"35\"><FONT  SIZE=\"+2\"><B>&nbsp;TransferAtoR</B></font></TD></TR>", "<TR VALIGN=\"middle\"><TD bgcolor=\"#C08060\" COLSPAN=\"2\" HEIGHT=\"35\"><FONT  SIZE=\"+2\"><B>&nbsp;Decode</B></font></TD></TR>", "<TR VALIGN=\"middle\"><TD bgcolor=\"#C08060\" COLSPAN=\"3\" HEIGHT=\"35\"><FONT  SIZE=\"+2\"><B>&nbsp;Set Condition Bit</B></font></TD></TR>", "<TR VALIGN=\"middle\"><TD bgcolor=\"#C08060\" COLSPAN=\"5\" HEIGHT=\"35\"><FONT  SIZE=\"+2\"><B>&nbsp;IO</B></font></TD></TR>", "<TR VALIGN=\"middle\"><TD bgcolor=\"#C08060\" COLSPAN=\"5\" HEIGHT=\"35\"><FONT  SIZE=\"+2\"><B>&nbsp;Memory Access</B></font></TD></TR>"};
    private String[] microColumnHeaders = new String[]{"<TR><TD><B>Name</B></TD><TD><B>Register</B></TD><TD><B>Start Bit</B></TD><TD><B>Number of Bits</B></TD><TD><B>Value</B></TD></TR>", "<TR><TD><B>Name</B></TD><TD><B>Register</B></TD><TD><B>Start Bit</B></TD><TD><B>Number of Bits</B></TD><TD><B>Comparison</B></TD><TD><B>Value</B></TD><TD><B>Omission</B></TD></TR>", "<TR><TD><B>Name</B></TD><TD><B>Register</B></TD><TD><B>Overflow Bit</B></TD><TD><B>Delta</B></TD></TR>", "<TR><TD><B>Name</B></TD><TD><B>Source</B></TD><TD><B>Destination</B></TD><TD><B>Type</B></TD><TD><B>Direction</B></TD><TD><B>Distance</B></TD></TR>", "<TR><TD><B>Name</B></TD><TD><B>Type</B></TD><TD><B>Source1</B></TD><TD><B>Source2</B></TD><TD><B>Destination</B></TD></TR>", "<TR><TD><B>Name</B></TD><TD><B>Type</B></TD><TD><B>Source1</B></TD><TD><B>Source2</B></TD><TD><B>Destination</B></TD><TD><B>Overflow Bit</B></TD><TD><B>Carry Bit</B></TD></TR>", "<TR><TD><B>Name</B></TD><TD><B>Amount</B></TD></TR>", "<TR><TD><B>Name</B></TD><TD><B>Source</B></TD><TD><B>Src Start Bit</B></TD><TD><B>Destination</B></TD><TD><B>Dest Start Bit</B></TD><TD><B>Number of Bits</B></TD></TR>", "<TR><TD><B>Name</B></TD><TD><B>Source</B></TD><TD><B>Src Start Bit</B></TD><TD><B>Destination</B></TD><TD><B>Dest Start Bit</B></TD><TD><B>Number of Bits</B></TD><TD><B>Index</B></TD><TD><B>Index Start Bit</B></TD><TD><B>Index Number of Bits</B></TD></TR>", "<TR><TD><B>Name</B></TD><TD><B>Source</B></TD><TD><B>Src Start Bit</B></TD><TD><B>Destination</B></TD><TD><B>Dest Start Bit</B></TD><TD><B>Number of Bits</B></TD><TD><B>Index</B></TD><TD><B>Index Start Bit</B></TD><TD><B>Index Number of Bits</B></TD></TR>", "<TR><TD><B>Name</B></TD><TD><B>IR</B></TD></TR>", "<TR><TD><B>Name</B></TD><TD><B>Bit</B></TD><TD><B>Value</B></TD></TR>", "<TR><TD><B>Name</B></TD><TD><B>Direction</B></TD><TD><B>Type</B></TD><TD><B>Buffer</B></TD><TD><B>Connection</B></TD></TR>", "<TR><TD><B>Name</B></TD><TD><B>Direction</B></TD><TD><B>Memory</B></TD><TD><B>Data</B></TD><TD><B>Address</B></TD></TR>"};

    public void writeMachineInHTML(Machine machine, PrintWriter out) {
        int j;
        int i;
        Vector[] moduleVectors = new Vector[]{machine.getModule("registers"), machine.getModule("registerArrays"), machine.getModule("conditionBits"), machine.getModule("rams")};
        Vector[] microVectors = new Vector[]{machine.getMicros("set"), machine.getMicros("test"), machine.getMicros("increment"), machine.getMicros("shift"), machine.getMicros("logical"), machine.getMicros("arithmetic"), machine.getMicros("branch"), machine.getMicros("transferRtoR"), machine.getMicros("transferRtoA"), machine.getMicros("transferAtoR"), machine.getMicros("decode"), machine.getMicros("setCondBit"), machine.getMicros("io"), machine.getMicros("memoryAccess")};
        out.println("<HTML><HEAD>");
        out.println("<TITLE>" + machine.getHTMLName() + "</TITLE></HEAD>");
        out.println("<BODY>");
        out.println("<CENTER><FONT COLOR=\"#804040\" SIZE=\"+3\"><B><I>");
        out.println(machine.getHTMLName());
        out.println("</I></B></FONT></CENTER>");
        out.println();
        out.println("<TABLE bgcolor=\"#FFC0A0\" BORDER=\"1\" CELLPADDING=\"0\" CELLSPACING=\"3\" WIDTH=\"100%\">");
        out.println("<TR VALIGN=\"middle\"><TD bgcolor=\"#C08060\" COLSPAN=\"2\" HEIGHT=\"35\"><FONT  SIZE=\"+2\"><B>&nbsp;Punctuation preferences</B></font></TD></TR>");
        out.println("<TR><TD><B>Character</B></TD><TD><B>Use</B></TD></TR>");
        PunctChar[] chars = machine.getPunctChars();
        if (chars.length == 0) {
            out.println("<TR VALIGN=\"middle\"><TD COLSPAN=\"2\"><CENTER>(none)</CENTER></TD></TR>");
        } else {
            for (PunctChar c : chars) {
                out.println(c.getHTMLDescription());
            }
        }
        out.println("</TABLE><P></P>");
        for (i = 0; i < moduleVectors.length; ++i) {
            out.println();
            out.println("<TABLE bgcolor=\"#FFC0A0\" BORDER=\"1\"CELLPADDING=\"0\" CELLSPACING=\"3\" WIDTH=\"100%\">");
            out.println(this.moduleHeaders[i]);
            out.println(this.moduleColumnHeaders[i]);
            if (moduleVectors[i].size() == 0) {
                out.println("<TR VALIGN=\"middle\"><TD COLSPAN=\"" + this.MODULE_COLUMNS[i] + "\"><CENTER>(none)</CENTER></TD></TR>");
            } else {
                for (j = 0; j < moduleVectors[i].size(); ++j) {
                    out.println(((Module)moduleVectors[i].elementAt(j)).getHTMLDescription());
                }
            }
            out.println("</TABLE><P></P>");
        }
        for (i = 0; i < microVectors.length; ++i) {
            out.println();
            out.println("<TABLE bgcolor=\"#FFC0A0\" BORDER=\"1\" CELLPADDING=\"0\" CELLSPACING=\"3\" WIDTH=\"100%\">");
            out.println(this.microHeaders[i]);
            out.println(this.microColumnHeaders[i]);
            if (microVectors[i].size() == 0) {
                out.println("<TR VALIGN=\"middle\"><TD COLSPAN=\"" + this.MICRO_COLUMNS[i] + "\"><CENTER>(none)</CENTER></TD></TR>");
            } else {
                for (j = 0; j < microVectors[i].size(); ++j) {
                    out.println(((Microinstruction)microVectors[i].elementAt(j)).getHTMLDescription());
                }
            }
            out.println("</TABLE><P></P>");
        }
        out.println();
        out.println("<TABLE bgcolor=\"#FFC0A0\" BORDER=\"1\" CELLPADDING=\"0\" CELLSPACING=\"3\" WIDTH=\"100%\">");
        out.println("<TR VALIGN=\"middle\"><TD bgcolor=\"#C08060\" COLSPAN=\"2\" HEIGHT=\"35\"><FONT  SIZE=\"+2\"><B>&nbsp;EQUs</B></font></TD></TR>");
        out.println("<TR><TD><B>Name</B></TD><TD><B>Value</B></TD></TR>");
        out.println();
        Vector EQUs2 = machine.getEQUs();
        if (EQUs2.size() == 0) {
            out.println("<TR VALIGN=\"middle\"><TD COLSPAN=\"2\"><CENTER>(none)</CENTER></TD></TR>");
        } else {
            for (j = 0; j < EQUs2.size(); ++j) {
                out.println(((EQU)EQUs2.elementAt(j)).getHTMLDescription());
            }
        }
        out.println("</TABLE><P></P>");
        out.println();
        out.println("<TABLE bgcolor=\"#FFC0A0\" BORDER=\"1\" CELLPADDING=\"0\" CELLSPACING=\"3\" WIDTH=\"100%\">");
        out.println("<TR VALIGN=\"middle\"><TD bgcolor=\"#C08060\" COLSPAN=\"7\" HEIGHT=\"35\"><FONT  SIZE=\"+2\"><B>&nbsp;Instruction Format Fields</B></font></TD></TR>");
        out.println("<TR><TD><B>Name</B></TD><TD><B>Type</B></TD><TD><B>Number of Bits</B></TD><TD><B>Relativity</B></TD><TD><B>Signed</B></TD><TD><B>Default Value</B></TD><TD><B>Values</B></TD></TR>");
        out.println();
        List<Field> fields = machine.getFields();
        if (fields.size() == 0) {
            out.println("<TR VALIGN=\"middle\"><TD COLSPAN=\"8\"><CENTER>(none)</CENTER></TD></TR>");
        } else {
            for (Field field : fields) {
                out.println(field.getHTMLDescription());
            }
        }
        out.println("</TABLE><P></P>");
        out.println();
        out.println("<TABLE bgcolor=\"#FFC0A0\" BORDER=\"1\" CELLPADDING=\"0\" CELLSPACING=\"3\" WIDTH=\"100%\">");
        out.println("<TR VALIGN=\"middle\"><TD bgcolor=\"#C08060\" COLSPAN=\"1\" HEIGHT=\"35\"><FONT  SIZE=\"+2\"><B>&nbsp;Fetch Sequence</B></font></TD></TR>");
        out.println("<TR><TD><B>Microinstructions</B></TD></TR>");
        MachineInstruction fetchSequence = machine.getFetchSequence();
        out.println("<TR><TD>");
        for (int i2 = 0; i2 < fetchSequence.getMicros().size(); ++i2) {
            out.println(fetchSequence.getMicros().get(i2).getHTMLName() + "<BR>");
        }
        out.println("</TD></TR>");
        out.println("</TABLE><P></P>");
        out.println();
        out.println("<TABLE bgcolor=\"#FFC0A0\" BORDER=\"1\" CELLPADDING=\"0\" CELLSPACING=\"3\" WIDTH=\"100%\">");
        out.println("<TR VALIGN=\"middle\"><TD bgcolor=\"#C08060\" COLSPAN=\"4\" HEIGHT=\"35\"><FONT  SIZE=\"+2\"><B>&nbsp;Machine Instructions</B></font></TD></TR>");
        out.println("<TR><TD><B>Name</B></TD><TD><B>Opcode (hex)</B></TD><TD><B>Format</B></TD><TD><B>Microinstructions</B></TD></TR>");
        List<MachineInstruction> instructions = machine.getInstructions();
        if (instructions.size() == 0) {
            out.println("<TR VALIGN=\"middle\"><TD COLSPAN=\"4\"><CENTER>(none)</CENTER></TD></TR>");
        } else {
            for (MachineInstruction instruction : instructions) {
                out.println();
                out.println(instruction.getHTMLDescription());
            }
        }
        out.println("</TABLE><P></P>");
        out.println("</BODY></HTML>");
        out.close();
    }
}

