/*
 * Decompiled with CFR 0.152.
 */
package cpusim.xml;

import cpusim.Field;
import cpusim.FileChannel;
import cpusim.IOChannel;
import cpusim.Machine;
import cpusim.MachineInstruction;
import cpusim.Microinstruction;
import cpusim.Module;
import cpusim.assembler.EQU;
import cpusim.assembler.PunctChar;
import cpusim.gui.RAMWindow;
import cpusim.gui.RegistersWindow;
import cpusim.microinstruction.Comment;
import cpusim.microinstruction.IO;
import cpusim.module.RAM;
import cpusim.module.RegisterArray;
import cpusim.scrollabledesktop.BaseInternalFrame;
import cpusim.util.Assert;
import cpusim.util.RegisterRAMPair;
import cpusim.xml.HtmlEncoder;
import java.awt.Rectangle;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;

public class MachineWriter {
    private String[] moduleHeaders;
    private String[] microHeaders;
    private String ls = System.getProperty("line.separator");
    private String internalDTD = "<!DOCTYPE Machine [" + this.ls + "<!ELEMENT Machine (PunctChar*," + " Field*, FileChannel*, Register*, RegisterArray*," + " ConditionBit*, RAM*, Set*, Test*, Increment*, Shift*, Logical*," + " Arithmetic*, Branch*, TransferRtoR*, TransferRtoA*, TransferAtoR*," + " Decode*, SetCondBit*, IO*, MemoryAccess*, End, Comment*, EQU*, FetchSequence," + " MachineInstruction*, HighlightingInfo?, LoadingInfo?," + " ModuleWindowsInfo?) >" + this.ls + "<!ATTLIST Machine name CDATA \"unnamed\">" + this.ls + "<!ELEMENT PunctChar EMPTY>" + this.ls + "<!ATTLIST PunctChar char CDATA #REQUIRED use " + " (symbol|token|label|comment|pseudo|illegal) #REQUIRED>" + this.ls + "<!ELEMENT Field (FieldValue*)>" + this.ls + "<!ATTLIST Field name CDATA #REQUIRED type " + " (required|optional|ignored) #REQUIRED numBits CDATA #REQUIRED" + " relativity (absolute|pcRelativePreIncr|pcRelativePostIncr)" + " #REQUIRED defaultValue CDATA #REQUIRED signed (true|false)" + " #REQUIRED offset CDATA #REQUIRED id ID #REQUIRED>" + this.ls + "<!ELEMENT FieldValue EMPTY>" + this.ls + "<!ATTLIST FieldValue name CDATA #REQUIRED value CDATA #REQUIRED>" + this.ls + "<!ELEMENT FileChannel EMPTY>" + this.ls + "<!ATTLIST FileChannel file CDATA #REQUIRED id ID #REQUIRED>" + this.ls + "<!ELEMENT Register EMPTY>" + this.ls + "<!ATTLIST Register name CDATA #REQUIRED width CDATA #REQUIRED id ID" + " #REQUIRED>" + this.ls + "<!ELEMENT RegisterArray (Register+)>" + this.ls + "<!ATTLIST RegisterArray name CDATA #REQUIRED width CDATA #REQUIRED length" + " CDATA #REQUIRED id ID #REQUIRED>" + this.ls + "<!ELEMENT ConditionBit EMPTY>" + this.ls + "<!ATTLIST ConditionBit name CDATA #REQUIRED bit CDATA #REQUIRED register" + " IDREF #REQUIRED halt (true|false) \"false\" id ID #REQUIRED>" + this.ls + "<!ELEMENT RAM EMPTY>" + this.ls + "<!ATTLIST RAM name CDATA #REQUIRED length CDATA #REQUIRED id ID" + " #REQUIRED cellSize CDATA \"8\">" + this.ls + "<!ELEMENT Increment EMPTY>" + this.ls + "<!ATTLIST Increment name CDATA #REQUIRED register IDREF #REQUIRED" + " overflowBit IDREF #IMPLIED delta CDATA #REQUIRED id ID #REQUIRED>" + this.ls + "<!ELEMENT Arithmetic EMPTY>" + this.ls + "<!ATTLIST Arithmetic name CDATA #REQUIRED type (ADD|SUBTRACT|MULTIPLY|" + "DIVIDE) #REQUIRED source1 IDREF #REQUIRED source2 IDREF #REQUIRED" + " destination IDREF #REQUIRED overflowBit IDREF #IMPLIED  carryBit IDREF" + " #IMPLIED  id ID #REQUIRED>" + this.ls + "<!ELEMENT TransferRtoR EMPTY>" + this.ls + "<!ATTLIST TransferRtoR name CDATA #REQUIRED source IDREF #REQUIRED" + " srcStartBit CDATA #REQUIRED dest IDREF #REQUIRED destStartBit CDATA" + " #REQUIRED numBits CDATA #REQUIRED id ID #REQUIRED>" + this.ls + "<!ELEMENT TransferRtoA EMPTY>" + this.ls + "<!ATTLIST TransferRtoA name CDATA #REQUIRED source IDREF #REQUIRED" + " srcStartBit CDATA #REQUIRED dest IDREF #REQUIRED destStartBit" + " CDATA #REQUIRED numBits CDATA #REQUIRED index IDREF #REQUIRED" + " indexStart CDATA #IMPLIED indexNumBits CDATA #IMPLIED id ID" + " #REQUIRED>" + this.ls + "<!ELEMENT TransferAtoR EMPTY>" + this.ls + "<!ATTLIST TransferAtoR name CDATA #REQUIRED source IDREF #REQUIRED" + " srcStartBit CDATA #REQUIRED dest IDREF #REQUIRED destStartBit" + " CDATA #REQUIRED numBits CDATA #REQUIRED index IDREF #REQUIRED" + " indexStart CDATA #IMPLIED indexNumBits CDATA #IMPLIED id ID" + " #REQUIRED>" + this.ls + "<!ELEMENT Shift EMPTY>" + this.ls + "<!ATTLIST Shift name CDATA #REQUIRED source IDREF #REQUIRED destination" + " IDREF #REQUIRED type (logical | arithmetic | cyclic) #REQUIRED" + " direction (right | left) #REQUIRED distance CDATA #REQUIRED id ID" + " #REQUIRED>" + this.ls + "<!ELEMENT Branch EMPTY>" + this.ls + "<!ATTLIST Branch name CDATA #REQUIRED amount CDATA #REQUIRED id ID" + " #REQUIRED>" + this.ls + "<!ELEMENT Logical EMPTY>" + this.ls + "<!ATTLIST Logical name CDATA #REQUIRED source1 IDREF #REQUIRED source2" + " IDREF #REQUIRED destination IDREF #REQUIRED type (AND | OR | NAND |" + " NOR | XOR | NOT) #REQUIRED id ID #REQUIRED>" + this.ls + "<!ELEMENT Set EMPTY>" + this.ls + "<!ATTLIST Set name CDATA #REQUIRED register IDREF #REQUIRED start" + " CDATA #REQUIRED numBits CDATA #REQUIRED value CDATA #REQUIRED id ID" + " #REQUIRED>" + this.ls + "<!ELEMENT Test EMPTY >" + this.ls + "<!ATTLIST Test name CDATA #REQUIRED" + " register IDREF #REQUIRED start CDATA #REQUIRED numBits" + " CDATA #REQUIRED comparison (EQ | NE | LT | GT | LE | GE ) #REQUIRED" + " value CDATA #REQUIRED omission CDATA #REQUIRED id ID #REQUIRED>" + this.ls + "<!ELEMENT Decode EMPTY >" + this.ls + "<!ATTLIST Decode name CDATA #REQUIRED ir IDREF #REQUIRED id ID" + " #REQUIRED>" + this.ls + "<!ELEMENT IO EMPTY >" + this.ls + "<!ATTLIST IO name CDATA #REQUIRED direction (input | output) #REQUIRED" + " type (integer | ascii | unicode) #REQUIRED buffer IDREF #REQUIRED" + " connection CDATA #IMPLIED id ID #REQUIRED>" + this.ls + "<!ELEMENT MemoryAccess EMPTY >" + this.ls + "<!ATTLIST MemoryAccess name CDATA #REQUIRED direction (read | write )" + " #REQUIRED memory IDREF #REQUIRED data IDREF #REQUIRED address IDREF" + " #REQUIRED id ID #REQUIRED>" + this.ls + "<!ELEMENT SetCondBit EMPTY >" + this.ls + "<!ATTLIST SetCondBit name CDATA #REQUIRED bit IDREF #REQUIRED value" + " (0 | 1) #REQUIRED id ID #REQUIRED>" + this.ls + "<!ELEMENT End EMPTY>" + this.ls + "<!ATTLIST End id ID #REQUIRED>" + this.ls + "<!ELEMENT Comment EMPTY>" + this.ls + "<!ATTLIST Comment name CDATA #REQUIRED id ID #REQUIRED>" + this.ls + "<!ELEMENT Microinstruction EMPTY>" + this.ls + "<!ATTLIST Microinstruction microRef IDREF #REQUIRED>" + this.ls + "<!ELEMENT MachineInstruction (Microinstruction*)>" + this.ls + "<!ATTLIST MachineInstruction name CDATA #REQUIRED opcode CDATA" + " #REQUIRED format CDATA #REQUIRED>" + this.ls + "<!ELEMENT FetchSequence (Microinstruction*) >" + this.ls + "<!ELEMENT EQU EMPTY>" + this.ls + "<!ATTLIST EQU name CDATA #REQUIRED value CDATA #REQUIRED>" + this.ls + "<!ELEMENT HighlightingInfo (RegisterRAMPair*)>" + this.ls + "<!ELEMENT RegisterRAMPair EMPTY>" + this.ls + "<!ATTLIST RegisterRAMPair register IDREF #REQUIRED ram IDREF #REQUIRED" + " dynamic (true|false) #REQUIRED>" + this.ls + "<!ELEMENT LoadingInfo EMPTY>" + this.ls + "<!ATTLIST LoadingInfo ram IDREF #IMPLIED startingAddress CDATA \"0\">" + this.ls + "<!ELEMENT ModuleWindowsInfo ((RegisterWindowInfo |" + " RegisterArrayWindowInfo | RAMWindowInfo)*) >" + this.ls + "<!ELEMENT RegisterWindowInfo EMPTY>" + this.ls + "<!ATTLIST RegisterWindowInfo top CDATA \"50\" left CDATA \"50\" width" + " CDATA \"300\" height CDATA \"150\" base (Decimal|Binary|Hexadecimal|Ascii|UnsignedDec|Unicode) " + " \"Decimal\">" + this.ls + "<!ELEMENT RegisterArrayWindowInfo EMPTY>" + this.ls + "<!ATTLIST RegisterArrayWindowInfo array IDREF #REQUIRED top CDATA" + " \"50\" left CDATA \"50\" width CDATA \"300\" height CDATA \"150\"" + " base (Decimal|Binary|Hexadecimal|Ascii|UnsignedDec|Unicode) \"Decimal\">" + this.ls + "<!ELEMENT RAMWindowInfo EMPTY>" + this.ls + "<!ATTLIST RAMWindowInfo ram IDREF #REQUIRED cellSize CDATA \"1\" top" + " CDATA \"50\" left CDATA \"50\" width CDATA \"450\" height CDATA" + " \"450\" contentsbase (Decimal|Binary|Hexadecimal|Ascii|UnsignedDec|Unicode) \"Decimal\"" + " addressbase (Decimal|Binary|Hexadecimal) \"Decimal\">" + this.ls + "]>";

    public MachineWriter() {
        this.moduleHeaders = new String[]{"<!--............. registers .....................-->", "<!--............. register arrays ...............-->", "<!--............. condition bits ................-->", "<!--............. rams ..........................-->"};
        this.microHeaders = new String[]{"<!--............. set ...........................-->", "<!--............. test ..........................-->", "<!--............. increment .....................-->", "<!--............. shift .........................-->", "<!--............. logical .......................-->", "<!--............. arithmetic ....................-->", "<!--............. branch ........................-->", "<!--............. transferRtoR ..................-->", "<!--............. transferRtoA ..................-->", "<!--............. transferAtoR ..................-->", "<!--............. decode ........................-->", "<!--............. set condition bit .............-->", "<!--............. io ............................-->", "<!--............. memory access .................-->"};
    }

    /*
     * WARNING - void declaration
     */
    public void writeMachine(Machine machine, String name, HashMap moduleWindows, Vector rrPairs, PrintWriter out) {
        int i;
        Vector[] moduleVectors = new Vector[]{machine.getModule("registers"), machine.getModule("registerArrays"), machine.getModule("conditionBits"), machine.getModule("rams")};
        Vector[] microVectors = new Vector[]{machine.getMicros("set"), machine.getMicros("test"), machine.getMicros("increment"), machine.getMicros("shift"), machine.getMicros("logical"), machine.getMicros("arithmetic"), machine.getMicros("branch"), machine.getMicros("transferRtoR"), machine.getMicros("transferRtoA"), machine.getMicros("transferAtoR"), machine.getMicros("decode"), machine.getMicros("setCondBit"), machine.getMicros("io"), machine.getMicros("memoryAccess")};
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println(this.internalDTD);
        out.println();
        out.println("<Machine name=\"" + HtmlEncoder.sEncode(name) + "\" >");
        out.println("\t<!--............. Punctuation Options .............-->");
        PunctChar[] chars = machine.getPunctChars();
        if (chars.length == 0) {
            out.println("\t<!-- none -->");
        } else {
            for (PunctChar c : chars) {
                out.println(c.getXMLDescription("\t"));
            }
        }
        out.println();
        out.println("\t<!--......... machine instruction fields ............-->");
        List<Field> fields = machine.getFields();
        if (fields.size() == 0) {
            out.println("\t<!-- none -->");
        } else {
            for (Field field : fields) {
                out.println(field.getXMLDescription("\t"));
            }
        }
        HashSet<FileChannel> fileChannelSet = new HashSet<FileChannel>();
        out.println();
        out.println("\t<!--............. FileChannels .................-->");
        Vector<Microinstruction> ios = machine.getMicros("io");
        for (int i2 = 0; i2 < ios.size(); ++i2) {
            IOChannel iOChannel = ((IO)ios.elementAt(i2)).getConnection();
            if (!(iOChannel instanceof FileChannel)) continue;
            fileChannelSet.add((FileChannel)iOChannel);
        }
        if (fileChannelSet.size() == 0) {
            out.println("\t<!-- none -->");
        } else {
            for (FileChannel fileChannel : fileChannelSet) {
                out.println("\t<FileChannel file=\"" + HtmlEncoder.sEncode(fileChannel.getFile().toString()) + "\" id=\"" + fileChannel.getID() + "\" />");
            }
        }
        for (i = 0; i < moduleVectors.length; ++i) {
            void var13_25;
            out.println();
            out.println("\t" + this.moduleHeaders[i]);
            if (moduleVectors[i].size() == 0) {
                out.println("\t<!-- none -->");
                continue;
            }
            boolean bl = false;
            while (var13_25 < moduleVectors[i].size()) {
                out.println("\t" + ((Module)moduleVectors[i].elementAt((int)var13_25)).getXMLDescription());
                ++var13_25;
            }
        }
        for (i = 0; i < microVectors.length; ++i) {
            out.println();
            out.println("\t" + this.microHeaders[i]);
            if (microVectors[i].size() == 0) {
                out.println("\t<!-- none -->");
                continue;
            }
            for (int j = 0; j < microVectors[i].size(); ++j) {
                out.println("\t" + ((Microinstruction)microVectors[i].elementAt(j)).getXMLDescription());
            }
        }
        out.println();
        out.println("\t<!--............. end ...........................-->");
        out.println("\t<End id=\"" + machine.getEnd().getID() + "\" />");
        out.println();
        out.println("\t<!--............. comment ...........................-->");
        List<Comment> comments = machine.getCommentMicros();
        if (comments.size() == 0) {
            out.println("\t<!-- none -->");
        } else {
            for (Comment comment : comments) {
                out.println("\t" + comment.getXMLDescription());
            }
        }
        out.println();
        out.println("\t<!--............. global equs ..................-->");
        Vector vector = machine.getEQUs();
        if (vector.size() == 0) {
            out.println("\t<!-- none -->");
        } else {
            for (int j = 0; j < vector.size(); ++j) {
                out.println("\t" + ((EQU)vector.elementAt(j)).getXMLDescription());
            }
        }
        out.println();
        out.println("\t<!--............. fetch sequence ................-->");
        out.println("\t<FetchSequence>");
        MachineInstruction fetchSequence = machine.getFetchSequence();
        for (int i3 = 0; i3 < fetchSequence.getMicros().size(); ++i3) {
            out.println("\t\t<Microinstruction microRef=\"" + fetchSequence.getMicros().get(i3).getID() + "\" />");
        }
        out.println("\t</FetchSequence>");
        out.println();
        out.println("\t<!--............. machine instructions ..........-->");
        List<MachineInstruction> instructions = machine.getInstructions();
        if (instructions.size() == 0) {
            out.println("\t<!-- none -->");
        } else {
            for (MachineInstruction instruction : instructions) {
                out.println();
                out.println(instruction.getXMLDescription("\t"));
            }
        }
        out.println();
        out.println("\t<!--............. highlighting info .............-->");
        out.println("\t<HighlightingInfo>");
        for (int i4 = 0; i4 < rrPairs.size(); ++i4) {
            out.println("\t\t" + ((RegisterRAMPair)rrPairs.elementAt(i4)).getXMLDescription());
        }
        out.println("\t</HighlightingInfo>");
        out.println();
        out.println("\t<!--............. loading info ..................-->");
        if (machine.getCodeStore() != null) {
            out.println("\t<LoadingInfo ram=\"" + machine.getCodeStore().getID() + "\" startingAddress=\"" + machine.getStartingAddressForLoading() + "\" />");
        }
        out.println();
        out.println("\t<!--............. module window info ............-->");
        out.println("\t<ModuleWindowsInfo>");
        for (Object key : moduleWindows.keySet()) {
            BaseInternalFrame frame = (BaseInternalFrame)moduleWindows.get(key);
            Rectangle r = frame.getNormalBounds();
            if (key instanceof RAM) {
                out.println("\t\t<RAMWindowInfo ram=\"" + ((RAM)key).getID() + "\" cellSize=\"" + ((RAMWindow)frame).getNumMemCellsPerTableCell() + "\" contentsbase=\"" + ((RAMWindow)frame).getContentBaseString().replace(" ", "") + "\" addressbase=\"" + ((RAMWindow)frame).getAddressBaseString() + "\" ");
            } else if (key instanceof RegisterArray) {
                out.println("\t\t<RegisterArrayWindowInfo array=\"" + ((RegisterArray)key).getID() + "\" base=\"" + ((RegistersWindow)frame).getBaseString().replace(" ", "") + "\" ");
            } else if (key instanceof String) {
                out.println("\t\t<RegisterWindowInfo base=\"" + ((RegistersWindow)frame).getBaseString().replace(" ", "") + "\" ");
            } else {
                Assert.That(false, "Illegal key: " + key + " in " + "desktop.moduleWindows.");
            }
            out.println("\t\t\ttop=\"" + (r.y < 0 ? 0 : r.y) + "\" left=\"" + (r.x < 0 ? 0 : r.x) + "\" width=\"" + r.width + "\" height=\"" + r.height + "\" />");
        }
        out.println("\t</ModuleWindowsInfo>");
        out.println();
        out.println("</Machine>");
        out.close();
    }
}

