/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.Language;
import org.languagetool.rules.Category;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.RuleMatch;

public abstract class Rule {
    protected final ResourceBundle messages;
    private List<String> correctExamples;
    private List<IncorrectExample> incorrectExamples;
    private String locQualityIssueType = "uncategorized";
    private Category category;
    private URL url;
    private boolean defaultOff;
    private boolean paragraphBackTrack;
    private List<RuleMatch> previousMatches;
    private List<RuleMatch> removedMatches;

    public Rule() {
        this.messages = null;
    }

    public Rule(ResourceBundle messages) {
        this.messages = messages;
    }

    public abstract String getId();

    public abstract String getDescription();

    public abstract RuleMatch[] match(AnalyzedSentence var1) throws IOException;

    public abstract void reset();

    public final boolean supportsLanguage(Language language) {
        List<Class<? extends Rule>> relevantRuleClasses = language.getRelevantRules();
        return relevantRuleClasses != null && relevantRuleClasses.contains(this.getClass());
    }

    public boolean isSpellingRule() {
        return false;
    }

    public final void setCorrectExamples(List<String> correctExamples) {
        this.correctExamples = correctExamples;
    }

    public final List<String> getCorrectExamples() {
        return this.correctExamples;
    }

    public final void setIncorrectExamples(List<IncorrectExample> incorrectExamples) {
        this.incorrectExamples = incorrectExamples;
    }

    public final List<IncorrectExample> getIncorrectExamples() {
        return this.incorrectExamples;
    }

    public final Category getCategory() {
        return this.category;
    }

    public final void setCategory(Category category) {
        this.category = category;
    }

    protected final RuleMatch[] toRuleMatchArray(List<RuleMatch> ruleMatches) {
        return ruleMatches.toArray(new RuleMatch[ruleMatches.size()]);
    }

    public final boolean isParagraphBackTrack() {
        return this.paragraphBackTrack;
    }

    public final void setParagraphBackTrack(boolean backTrack) {
        this.paragraphBackTrack = backTrack;
    }

    public final void addRuleMatch(RuleMatch ruleMatch) {
        if (this.previousMatches == null) {
            this.previousMatches = new ArrayList<RuleMatch>();
        }
        this.previousMatches.add(ruleMatch);
    }

    public final void setAsDeleted(int index) {
        if (this.removedMatches == null) {
            this.removedMatches = new ArrayList<RuleMatch>();
        }
        this.removedMatches.add(this.previousMatches.get(index));
    }

    public final boolean isInRemoved(RuleMatch ruleMatch) {
        if (this.removedMatches == null) {
            return false;
        }
        return this.removedMatches.contains(ruleMatch);
    }

    public final boolean isInMatches(int index) {
        if (this.previousMatches == null) {
            return false;
        }
        if (this.previousMatches.size() > index) {
            return this.previousMatches.get(index) != null;
        }
        return false;
    }

    public final void clearMatches() {
        if (this.previousMatches != null) {
            this.previousMatches.clear();
        }
    }

    public final int getMatchesIndex() {
        if (this.previousMatches == null) {
            return 0;
        }
        return this.previousMatches.size();
    }

    public final List<RuleMatch> getMatches() {
        return this.previousMatches;
    }

    public final boolean isDefaultOff() {
        return this.defaultOff;
    }

    public final void setDefaultOff() {
        this.defaultOff = true;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public String getLocQualityIssueType() {
        return this.locQualityIssueType;
    }

    public void setLocQualityIssueType(String locQualityIssueType) {
        this.locQualityIssueType = locQualityIssueType;
    }
}

