/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.patterns.Match;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tools.StringTools;

public class Element {
    public static final String UNKNOWN_TAG = "UNKNOWN";
    private static final String CASE_INSENSITIVE = "(?iu)";
    private final boolean caseSensitive;
    private final boolean stringRegExp;
    private String stringToken;
    private String posToken;
    private boolean posRegExp;
    private boolean negation;
    private boolean posNegation;
    private boolean inflected;
    private boolean testWhitespace;
    private boolean whitespaceBefore;
    private List<Element> exceptionList;
    private boolean exceptionValidNext;
    private boolean exceptionSet;
    private boolean exceptionValidPrevious;
    private List<Element> previousExceptionList;
    private List<Element> andGroupList;
    private boolean andGroupSet;
    private boolean[] andGroupCheck;
    private int skip;
    private Pattern p;
    private Pattern pPos;
    private Matcher m;
    private Matcher mPos;
    private Match tokenReference;
    private boolean containsMatches;
    private String referenceString;
    private String phraseName;
    private boolean testString;
    private boolean unified;
    private boolean uniNegation;
    private Map<String, List<String>> unificationFeatures;
    private boolean posUnknown;
    private boolean isLastUnified;

    public Element(String token, boolean caseSensitive, boolean regExp, boolean inflected) {
        this.caseSensitive = caseSensitive;
        this.stringRegExp = regExp;
        this.inflected = inflected;
        this.setStringElement(token);
    }

    public final boolean isMatched(AnalyzedToken token) {
        boolean matched;
        if (this.testWhitespace && !this.isWhitespaceBefore(token)) {
            return false;
        }
        if (this.testString) {
            matched = this.isStringTokenMatched(token) ^ this.negation && this.isPosTokenMatched(token) ^ this.posNegation;
        } else {
            boolean bl = matched = !this.negation && this.isPosTokenMatched(token) ^ this.posNegation;
        }
        if (this.andGroupSet) {
            this.andGroupCheck[0] = this.andGroupCheck[0] | matched;
        }
        return matched;
    }

    public final boolean isExceptionMatched(AnalyzedToken token) {
        if (this.exceptionSet) {
            for (Element testException : this.exceptionList) {
                if (testException.exceptionValidNext || !testException.isMatched(token)) continue;
                return true;
            }
        }
        return false;
    }

    public final void addMemberAndGroup(AnalyzedToken token) {
        if (this.andGroupSet) {
            for (int i = 0; i < this.andGroupList.size(); ++i) {
                Element testAndGroup;
                if (this.andGroupCheck[i + 1] || !(testAndGroup = this.andGroupList.get(i)).isMatched(token)) continue;
                this.andGroupCheck[i + 1] = true;
            }
        }
    }

    public final void setupAndGroup() {
        if (this.andGroupSet) {
            this.andGroupCheck = new boolean[this.andGroupList.size() + 1];
            Arrays.fill(this.andGroupCheck, false);
        }
    }

    public final boolean checkAndGroup(boolean previousValue) {
        if (this.andGroupSet) {
            boolean allConditionsMatch = true;
            for (boolean testValue : this.andGroupCheck) {
                allConditionsMatch &= testValue;
            }
            return allConditionsMatch;
        }
        return previousValue;
    }

    public final boolean isAndExceptionGroupMatched(AnalyzedToken token) {
        if (this.andGroupSet) {
            for (Element testAndGroup : this.andGroupList) {
                if (!testAndGroup.isExceptionMatched(token)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isExceptionMatchedCompletely(AnalyzedToken token) {
        return this.isExceptionMatched(token) || this.isAndExceptionGroupMatched(token);
    }

    public final void setAndGroupElement(Element andToken) {
        if (andToken != null) {
            if (this.andGroupList == null) {
                this.andGroupList = new ArrayList<Element>();
            }
            if (!this.andGroupSet) {
                this.andGroupSet = true;
            }
            this.andGroupList.add(andToken);
        }
    }

    public final boolean hasAndGroup() {
        return this.andGroupSet;
    }

    public final List<Element> getAndGroup() {
        return this.andGroupList;
    }

    public final boolean isMatchedByScopeNextException(AnalyzedToken token) {
        if (this.exceptionSet) {
            for (Element testException : this.exceptionList) {
                if (!testException.exceptionValidNext || !testException.isMatched(token)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isMatchedByPreviousException(AnalyzedToken token) {
        if (this.exceptionValidPrevious) {
            for (Element testException : this.previousExceptionList) {
                if (testException.exceptionValidNext || !testException.isMatched(token)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isMatchedByPreviousException(AnalyzedTokenReadings prevToken) {
        int numReadings = prevToken.getReadingsLength();
        for (int i = 0; i < numReadings; ++i) {
            if (!this.isMatchedByPreviousException(prevToken.getAnalyzedToken(i))) continue;
            return true;
        }
        return false;
    }

    public final boolean isSentStart() {
        return "SENT_START".equals(this.posToken) && !this.posNegation;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.negation) {
            sb.append('!');
        }
        sb.append(this.stringToken);
        if (this.phraseName != null) {
            sb.append(" {");
            sb.append(this.phraseName);
            sb.append('}');
        }
        if (this.posToken != null) {
            sb.append('/');
            sb.append(this.posToken);
        }
        if (this.exceptionList != null) {
            sb.append("/exceptions=");
            sb.append(this.exceptionList);
        }
        return sb.toString();
    }

    public final void setPosElement(String posToken, boolean regExp, boolean negation) {
        this.posToken = posToken;
        this.posNegation = negation;
        this.posRegExp = regExp;
        if (this.posRegExp) {
            this.pPos = Pattern.compile(posToken);
            if (this.mPos == null) {
                this.mPos = this.pPos.matcher(UNKNOWN_TAG);
            } else {
                this.mPos.reset(UNKNOWN_TAG);
            }
            this.posUnknown = this.mPos.matches();
        } else {
            this.posUnknown = UNKNOWN_TAG.equals(posToken);
        }
    }

    public final String getString() {
        return this.stringToken;
    }

    public final void setStringElement(String token) {
        this.stringToken = token;
        boolean bl = this.testString = !StringTools.isEmpty(this.stringToken);
        if (this.testString && this.stringRegExp) {
            String regToken = this.stringToken;
            if (!this.caseSensitive) {
                regToken = CASE_INSENSITIVE + this.stringToken;
            }
            if (!"\\0".equals(token)) {
                this.p = Pattern.compile(regToken);
            }
        }
    }

    public final void setStringPosException(String token, boolean regExp, boolean inflected, boolean negation, boolean scopeNext, boolean scopePrevious, String posToken, boolean posRegExp, boolean posNegation) {
        Element exception = new Element(token, this.caseSensitive, regExp, inflected);
        exception.setNegation(negation);
        exception.setPosElement(posToken, posRegExp, posNegation);
        exception.exceptionValidNext = scopeNext;
        this.setException(exception, scopePrevious);
    }

    private void setException(Element elem, boolean scopePrevious) {
        this.exceptionValidPrevious |= scopePrevious;
        if (this.exceptionList == null && !scopePrevious) {
            this.exceptionList = new ArrayList<Element>();
        }
        if (this.previousExceptionList == null && scopePrevious) {
            this.previousExceptionList = new ArrayList<Element>();
        }
        if (scopePrevious) {
            this.previousExceptionList.add(elem);
        } else {
            if (!this.exceptionSet) {
                this.exceptionSet = true;
            }
            this.exceptionList.add(elem);
        }
    }

    private boolean isPosTokenMatched(AnalyzedToken token) {
        boolean match;
        if (this.posToken == null) {
            return true;
        }
        if (token.getPOSTag() == null) {
            if (this.posUnknown) {
                return token.hasNoTag();
            }
            return false;
        }
        if (this.posRegExp) {
            if (this.mPos == null) {
                this.mPos = this.pPos.matcher(token.getPOSTag());
            } else {
                this.mPos.reset(token.getPOSTag());
            }
            match = this.mPos.matches();
        } else {
            match = this.posToken.equals(token.getPOSTag());
        }
        if (!match && this.posUnknown) {
            match = token.hasNoTag();
        }
        return match;
    }

    private boolean isStringTokenMatched(AnalyzedToken token) {
        String testToken = this.getTestToken(token);
        if (this.stringRegExp) {
            if (this.m == null) {
                this.m = this.p.matcher(testToken);
            } else {
                this.m.reset(testToken);
            }
            return this.m.matches();
        }
        if (this.caseSensitive) {
            return this.stringToken.equals(testToken);
        }
        return this.stringToken.equalsIgnoreCase(testToken);
    }

    private String getTestToken(AnalyzedToken token) {
        if (this.inflected) {
            return token.getTokenInflected();
        }
        return token.getToken();
    }

    public final int getSkipNext() {
        return this.skip;
    }

    public final void setSkipNext(int i) {
        this.skip = i;
    }

    public final boolean hasPreviousException() {
        return this.exceptionValidPrevious;
    }

    public final boolean hasNextException() {
        return this.exceptionValidNext;
    }

    public final void setNegation(boolean negation) {
        this.negation = negation;
    }

    public final boolean getNegation() {
        return this.negation;
    }

    public final boolean isReferenceElement() {
        return this.containsMatches;
    }

    public final void setMatch(Match match) {
        this.tokenReference = match;
        this.containsMatches = true;
    }

    public final Match getMatch() {
        return this.tokenReference;
    }

    public final void compile(AnalyzedTokenReadings token, Synthesizer synth) throws IOException {
        this.m = null;
        this.p = null;
        this.tokenReference.setToken(token);
        this.tokenReference.setSynthesizer(synth);
        if (StringTools.isEmpty(this.referenceString)) {
            this.referenceString = this.stringToken;
        }
        if (this.tokenReference.setsPos()) {
            String posReference = this.tokenReference.getTargetPosTag();
            if (posReference != null) {
                if (this.mPos != null) {
                    this.mPos = null;
                }
                this.setPosElement(posReference, this.tokenReference.posRegExp(), this.negation);
            }
            this.setStringElement(this.referenceString.replace("\\" + this.tokenReference.getTokenRef(), ""));
            this.inflected = true;
        } else {
            this.setStringElement(this.referenceString.replace("\\" + this.tokenReference.getTokenRef(), this.tokenReference.toTokenString()));
        }
    }

    public final void setPhraseName(String s) {
        this.phraseName = s;
    }

    public final boolean isPartOfPhrase() {
        return this.phraseName != null;
    }

    public final boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public final boolean isRegularExpression() {
        return this.stringRegExp;
    }

    public final boolean isPOStagRegularExpression() {
        return this.posRegExp;
    }

    public final String getPOStag() {
        return this.posToken;
    }

    public final boolean getPOSNegation() {
        return this.posNegation;
    }

    public final boolean isInflected() {
        return this.inflected;
    }

    public final String getPhraseName() {
        return this.phraseName;
    }

    public final boolean isUnified() {
        return this.unified;
    }

    public final void setUnification(Map<String, List<String>> uniFeatures) {
        this.unificationFeatures = uniFeatures;
        this.unified = true;
    }

    public final Map<String, List<String>> getUniFeatures() {
        return this.unificationFeatures;
    }

    public final void setUniNegation() {
        this.uniNegation = true;
    }

    public final boolean isUniNegated() {
        return this.uniNegation;
    }

    public final boolean isLastInUnification() {
        return this.isLastUnified;
    }

    public final void setLastInUnification() {
        this.isLastUnified = true;
    }

    public final void setWhitespaceBefore(boolean isWhite) {
        this.whitespaceBefore = isWhite;
        this.testWhitespace = true;
    }

    public final void setExceptionSpaceBefore(boolean isWhite) {
        if (this.previousExceptionList != null && this.exceptionValidPrevious) {
            this.previousExceptionList.get(this.previousExceptionList.size() - 1).setWhitespaceBefore(isWhite);
        } else if (this.exceptionList != null) {
            this.exceptionList.get(this.exceptionList.size() - 1).setWhitespaceBefore(isWhite);
        }
    }

    public final boolean isWhitespaceBefore(AnalyzedToken token) {
        return this.whitespaceBefore == token.isWhitespaceBefore();
    }

    public final List<Element> getExceptionList() {
        return this.exceptionList;
    }

    public final List<Element> getPreviousExceptionList() {
        return this.previousExceptionList;
    }

    public final boolean hasExceptionList() {
        return this.exceptionList != null || this.previousExceptionList != null;
    }

    public final boolean testWhitespace() {
        return this.testWhitespace;
    }
}

