/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.ExternalTMX;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.ProjectTMX;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.statistics.StatisticsInfo;
import org.omegat.core.team.IRemoteRepository;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.Language;

public interface IProject {
    public void saveProjectProperties() throws Exception;

    public void saveProject();

    public void saveProject(boolean var1);

    public void closeProject();

    public void compileProject(String var1) throws Exception;

    public ProjectProperties getProjectProperties();

    public IRemoteRepository getRepository();

    public boolean isProjectLoaded();

    public boolean isProjectModified();

    public ITokenizer getSourceTokenizer();

    public ITokenizer getTargetTokenizer();

    public List<SourceTextEntry> getAllEntries();

    public void setTranslation(SourceTextEntry var1, PrepareTMXEntry var2, boolean var3, TMXEntry.ExternalLinked var4);

    public void setNote(SourceTextEntry var1, TMXEntry var2, String var3);

    public StatisticsInfo getStatistics();

    public TMXEntry getTranslationInfo(SourceTextEntry var1);

    public void iterateByDefaultTranslations(DefaultTranslationsIterator var1);

    public void iterateByMultipleTranslations(MultipleTranslationsIterator var1);

    public boolean isOrphaned(String var1);

    public boolean isOrphaned(EntryKey var1);

    public Map<String, ExternalTMX> getTransMemories();

    public Map<Language, ProjectTMX> getOtherTargetLanguageTMs();

    public List<FileInfo> getProjectFiles();

    public String getTargetPathForSourceFile(String var1);

    public List<String> getSourceFilesOrder();

    public void setSourceFilesOrder(List<String> var1);

    public static interface MultipleTranslationsIterator {
        public void iterate(EntryKey var1, TMXEntry var2);
    }

    public static interface DefaultTranslationsIterator {
        public void iterate(String var1, TMXEntry var2);
    }

    public static class FileInfo {
        public String filePath;
        public Class<?> filterClass;
        public String filterFileFormatName;
        public String fileEncoding;
        public List<SourceTextEntry> entries = new ArrayList<SourceTextEntry>();
    }
}

