/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.dictionaries;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.omegat.core.dictionaries.IDictionary;

public class LingvoDSL
implements IDictionary {
    protected static final String CHARSET = "UTF-16";
    protected static final Pattern RE_SKIP = Pattern.compile("\\[.+?\\]");
    protected final File file;

    public LingvoDSL(File file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> readHeader() throws Exception {
        BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), CHARSET));
        try {
            String s;
            HashMap<String, Object> result = new HashMap<String, Object>();
            StringBuilder word = new StringBuilder();
            StringBuilder trans = new StringBuilder();
            while ((s = rd.readLine()) != null) {
                if (s.isEmpty() || s.codePointAt(0) == 35) continue;
                if (Character.isWhitespace((s = RE_SKIP.matcher(s).replaceAll("")).codePointAt(0))) {
                    trans.append(s.trim()).append('\n');
                    continue;
                }
                if (word.length() > 0) {
                    result.put(word.toString(), trans.toString());
                    word.setLength(0);
                    trans.setLength(0);
                }
                word.append(s);
            }
            if (word.length() > 0) {
                result.put(word.toString(), trans.toString());
            }
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        finally {
            rd.close();
        }
    }

    @Override
    public String readArticle(String word, Object articleData) throws Exception {
        return (String)articleData;
    }
}

