/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.machinetranslators;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.machinetranslators.BaseTranslate;
import org.omegat.util.Language;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;
import org.omegat.util.WikiGet;

public class ApertiumTranslate
extends BaseTranslate {
    protected static String GT_URL = "http://api.apertium.org/json/translate?q=";
    protected static String GT_URL2 = "&markUnknown=no&format=omegat&langpair=#sourceLang#|#targetLang#&key=bwuxb5jS+VwSJ8mLz1qMfmMrDGA";
    protected static String MARK_BEG = "{\"translatedText\":\"";
    protected static String MARK_END = "\"}";
    protected static Pattern RE_UNICODE = Pattern.compile("\\\\u([0-9A-Fa-f]{4})");
    protected static Pattern RE_HTML = Pattern.compile("&#([0-9]+);");
    protected static Pattern RE_DETAILS = Pattern.compile("\"responseDetails\":\"([^\"]+)");
    protected static Pattern RE_STATUS = Pattern.compile("\"responseStatus\":([0-9]+)");

    @Override
    protected String getPreferenceName() {
        return "allow_apertium_translate";
    }

    @Override
    public String getName() {
        return OStrings.getString("MT_ENGINE_APERTIUM");
    }

    private String apertiumCode(Language language) {
        String lCode = language.getLanguageCode().toLowerCase();
        String locale = language.getLocaleCode();
        if (!StringUtil.isEmpty(language.getCountryCode())) {
            if (locale.equalsIgnoreCase("en_us") || locale.equalsIgnoreCase("pt_br")) {
                return locale;
            }
            if (locale.equalsIgnoreCase("oc_ar")) {
                return "oc_aran";
            }
            if (locale.equalsIgnoreCase("ca_va")) {
                return "ca_valencia";
            }
        }
        return lCode;
    }

    @Override
    protected String translate(Language sLang, Language tLang, String text) throws Exception {
        char c;
        String g;
        Matcher m;
        String v;
        String prev = this.getFromCache(sLang, tLang, text);
        if (prev != null) {
            return prev;
        }
        String trText = text;
        String sourceLang = this.apertiumCode(sLang);
        String targetLang = this.apertiumCode(tLang);
        String url2 = GT_URL2.replace("#sourceLang#", sourceLang).replace("#targetLang#", targetLang);
        String url = GT_URL + URLEncoder.encode(trText, "UTF-8") + url2;
        try {
            v = WikiGet.getURL(url);
        }
        catch (IOException e) {
            return e.getLocalizedMessage();
        }
        while ((m = RE_UNICODE.matcher(v)).find()) {
            g = m.group();
            c = (char)Integer.parseInt(m.group(1), 16);
            v = v.replace(g, Character.toString(c));
        }
        v = v.replace("&quot;", "&#34;");
        v = v.replace("&nbsp;", "&#160;");
        v = v.replace("&amp;", "&#38;");
        v = v.replace("\\\"", "\"");
        while ((m = RE_HTML.matcher(v)).find()) {
            g = m.group();
            c = (char)Integer.parseInt(m.group(1));
            v = v.replace(g, Character.toString(c));
        }
        int beg = v.indexOf(MARK_BEG) + MARK_BEG.length();
        int end = v.indexOf(MARK_END, beg);
        if (end < 0) {
            Matcher m2 = RE_DETAILS.matcher(v);
            if (!m2.find()) {
                return "";
            }
            String details = m2.group(1);
            String code = "";
            m2 = RE_STATUS.matcher(v);
            if (m2.find()) {
                code = m2.group(1);
            }
            return StringUtil.format(OStrings.getString("APERTIUM_ERROR"), code, details);
        }
        String tr = v.substring(beg, end - 2);
        this.putToCache(sLang, tLang, trText, tr);
        return tr;
    }
}

