/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.machinetranslators;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import org.omegat.core.Core;
import org.omegat.core.machinetranslators.BaseTranslate;
import org.omegat.util.LFileCopy;
import org.omegat.util.Language;
import org.omegat.util.OStrings;

public class BelazarTranslate
extends BaseTranslate {
    protected static final String CHARSET = "Cp1251";

    public static void loadPlugins() {
        Core.registerMachineTranslationClass(BelazarTranslate.class);
    }

    public static void unloadPlugins() {
    }

    @Override
    protected String getPreferenceName() {
        return "allow_belazar_translate";
    }

    @Override
    public String getName() {
        return OStrings.getString("MT_ENGINE_BELAZAR");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String translate(Language sLang, Language tLang, String text) throws Exception {
        String mode;
        String prev = this.getFromCache(sLang, tLang, text);
        if (prev != null) {
            return prev;
        }
        if ("be".equalsIgnoreCase(sLang.getLanguageCode()) && "ru".equalsIgnoreCase(tLang.getLanguageCode())) {
            mode = "br";
        } else if ("ru".equalsIgnoreCase(sLang.getLanguageCode()) && "be".equalsIgnoreCase(tLang.getLanguageCode())) {
            mode = "rb";
        } else {
            return null;
        }
        String data = "td=" + mode + "&addtags=0&txt=" + URLEncoder.encode(text, CHARSET);
        byte[] db = data.getBytes(CHARSET);
        HttpURLConnection conn = (HttpURLConnection)new URL("http://localhost:48762").openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("Content-Length", Integer.toString(db.length));
        conn.setUseCaches(false);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        OutputStream out = conn.getOutputStream();
        try {
            out.write(db);
            out.flush();
        }
        finally {
            out.close();
        }
        StringWriter result = new StringWriter();
        InputStream in = conn.getInputStream();
        try {
            InputStreamReader rd = new InputStreamReader(in, CHARSET);
            LFileCopy.copy(rd, result);
        }
        finally {
            in.close();
        }
        this.putToCache(sLang, tLang, text, result.toString());
        return result.toString();
    }
}

