/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.search;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.Core;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.ExternalTMX;
import org.omegat.core.data.IProject;
import org.omegat.core.data.ParseEntry;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.ProjectTMX;
import org.omegat.core.data.ProtectedPart;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.search.SearchExpression;
import org.omegat.core.search.SearchMatch;
import org.omegat.core.search.SearchResultEntry;
import org.omegat.core.threads.LongProcessThread;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.IParseCallback;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.util.Language;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;

public class Searcher {
    private volatile List<SearchResultEntry> m_searchResults;
    private boolean m_preprocessResults;
    private IProject m_project;
    private Map<String, Integer> m_tmxMap;
    private Map<String, Integer> m_entryMap;
    private List<Matcher> m_matchers;
    private Matcher m_author;
    private int m_numFinds;
    private SearchExpression m_searchExpression;
    private final SearchExpression expression;
    private LongProcessThread checkStop;
    private final List<SearchMatch> foundMatches = new ArrayList<SearchMatch>();
    private final int ENTRY_ORIGIN_PROJECT_MEMORY = 0;
    private final int ENTRY_ORIGIN_TRANSLATION_MEMORY = -1;
    private final int ENTRY_ORIGIN_ORPHAN = -2;
    private final int ENTRY_ORIGIN_ALTERNATIVE = -3;
    private final int ENTRY_ORIGIN_GLOSSARY = -4;
    private final int ENTRY_ORIGIN_TEXT = -5;

    public Searcher(IProject project, SearchExpression expression) {
        this.m_project = project;
        this.expression = expression;
    }

    public void setThread(LongProcessThread thread) {
        this.checkStop = thread;
    }

    public SearchExpression getExpression() {
        return this.expression;
    }

    public List<SearchResultEntry> getSearchResults() {
        if (this.m_preprocessResults) {
            this.m_preprocessResults = false;
            if (!this.expression.allResults) {
                for (SearchResultEntry entry : this.m_searchResults) {
                    String newPreamble;
                    String key = entry.getSrcText() + entry.getTranslation();
                    if (entry.getEntryNum() == -1) {
                        if (!this.m_tmxMap.containsKey(key) || this.m_tmxMap.get(key) <= 0) continue;
                        newPreamble = StringUtil.format(OStrings.getString("SW_FILE_AND_NR_OF_MORE"), entry.getPreamble(), this.m_tmxMap.get(key));
                        entry.setPreamble(newPreamble);
                        continue;
                    }
                    if (entry.getEntryNum() <= 0 || !this.m_entryMap.containsKey(key) || this.m_entryMap.get(key) <= 0) continue;
                    newPreamble = StringUtil.isEmpty(entry.getPreamble()) ? StringUtil.format(OStrings.getString("SW_NR_OF_MORE"), this.m_entryMap.get(key)) : StringUtil.format(OStrings.getString("SW_FILE_AND_NR_OF_MORE"), entry.getPreamble(), this.m_entryMap.get(key));
                    entry.setPreamble(newPreamble);
                }
            }
        }
        return this.m_searchResults;
    }

    public void search() throws Exception {
        this.m_searchExpression = this.expression;
        String text = this.expression.text;
        String author = this.expression.author;
        this.m_searchResults = new ArrayList<SearchResultEntry>();
        this.m_numFinds = 0;
        this.m_preprocessResults = true;
        this.m_entryMap = null;
        this.m_entryMap = new HashMap<String, Integer>();
        this.m_tmxMap = new HashMap<String, Integer>();
        this.m_matchers = new ArrayList<Matcher>();
        int flags = this.expression.caseSensitive ? 0 : 66;
        switch (this.expression.searchExpressionType) {
            default: {
                text = StaticUtils.escapeNonRegex(text, false);
                if (this.expression.spaceMatchNbsp) {
                    text = text.replaceAll(" ", "( |\u00a0)");
                }
                this.m_matchers.add(Pattern.compile(text, flags).matcher(""));
                break;
            }
            case KEYWORD: {
                text = text.trim();
                if (text.isEmpty()) break;
                int wordStart = 0;
                while (wordStart < text.length()) {
                    String word;
                    int spacePos = text.indexOf(32, wordStart);
                    String string = word = spacePos == -1 ? text.substring(wordStart, text.length()).trim() : text.substring(wordStart, spacePos).trim();
                    if (!word.isEmpty()) {
                        word = StaticUtils.escapeNonRegex(word, false);
                        this.m_matchers.add(Pattern.compile(word, flags).matcher(""));
                    }
                    wordStart = spacePos == -1 ? text.length() : spacePos + 1;
                }
                break;
            }
            case REGEXP: {
                if (this.expression.spaceMatchNbsp) {
                    text = text.replaceAll(" ", "( |\u00a0)");
                    text = text.replaceAll("\\\\s", "(\\\\s|\u00a0)");
                }
                this.m_matchers.add(Pattern.compile(text, flags).matcher(""));
            }
        }
        if (this.expression.searchExpressionType != SearchExpression.SearchExpressionType.REGEXP) {
            author = StaticUtils.escapeNonRegex(author, false);
        }
        this.m_author = Pattern.compile(author, flags).matcher("");
        if (this.expression.rootDir == null) {
            this.searchProject();
        } else {
            this.searchFiles();
        }
    }

    private void addEntry(int num, String preamble, String srcPrefix, String src, String target, String note, SearchMatch[] srcMatch, SearchMatch[] targetMatch, SearchMatch[] noteMatch) {
        SearchResultEntry entry = new SearchResultEntry(num, preamble, srcPrefix, src, target, note, srcMatch, targetMatch, noteMatch);
        this.m_searchResults.add(entry);
        ++this.m_numFinds;
    }

    private void foundString(int entryNum, String intro, String src, String target, String note, SearchMatch[] srcMatches, SearchMatch[] targetMatches, SearchMatch[] noteMatches) {
        if (this.m_numFinds >= this.expression.numberOfResults) {
            return;
        }
        String key = src + target;
        if (entryNum >= 0) {
            if (!this.m_entryMap.containsKey(key) || this.expression.allResults) {
                String file = this.expression.fileNames ? this.getFileForEntry(entryNum + 1) : null;
                this.addEntry(entryNum + 1, file, entryNum + 1 + "> ", src, target, note, srcMatches, targetMatches, noteMatches);
                if (!this.expression.allResults) {
                    this.m_entryMap.put(key, 0);
                }
            } else if (!this.expression.allResults) {
                this.m_entryMap.put(key, this.m_entryMap.get(key) + 1);
            }
        } else if (entryNum == -1) {
            if (!this.m_tmxMap.containsKey(key) || this.expression.allResults) {
                this.addEntry(entryNum, intro, null, src, target, note, srcMatches, targetMatches, noteMatches);
                if (!this.expression.allResults) {
                    this.m_tmxMap.put(key, 0);
                }
            } else if (!this.expression.allResults) {
                this.m_tmxMap.put(key, this.m_tmxMap.get(key) + 1);
            }
        } else {
            this.addEntry(entryNum, intro, null, src, target, note, srcMatches, targetMatches, noteMatches);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void searchProject() {
        this.m_numFinds = 0;
        if (this.m_searchExpression.memory) {
            void var2_3;
            IProject dataEngine = this.m_project;
            boolean bl = false;
            while (var2_3 < this.m_project.getAllEntries().size()) {
                if (this.m_numFinds >= this.expression.numberOfResults) {
                    return;
                }
                SourceTextEntry ste = dataEngine.getAllEntries().get((int)var2_3);
                TMXEntry te = this.m_project.getTranslationInfo(ste);
                this.checkEntry(ste.getSrcText(), te.translation, te.note, ste.getComment(), te, (int)var2_3, null);
                this.checkStop.checkInterrupted();
                ++var2_3;
            }
            if (!this.m_searchExpression.excludeOrphans) {
                this.m_project.iterateByDefaultTranslations(new IProject.DefaultTranslationsIterator(){
                    final String file = OStrings.getString("CT_ORPHAN_STRINGS");

                    @Override
                    public void iterate(String source, TMXEntry en) {
                        if (Searcher.this.m_numFinds >= ((Searcher)Searcher.this).expression.numberOfResults) {
                            return;
                        }
                        Searcher.this.checkStop.checkInterrupted();
                        if (Searcher.this.m_project.isOrphaned(source)) {
                            Searcher.this.checkEntry(en.source, en.translation, en.note, null, en, -2, this.file);
                        }
                    }
                });
            }
            this.m_project.iterateByMultipleTranslations(new IProject.MultipleTranslationsIterator(){
                final String file = OStrings.getString("CT_ORPHAN_STRINGS");

                @Override
                public void iterate(EntryKey source, TMXEntry en) {
                    if (Searcher.this.m_numFinds >= ((Searcher)Searcher.this).expression.numberOfResults) {
                        return;
                    }
                    Searcher.this.checkStop.checkInterrupted();
                    if (Searcher.this.m_project.isOrphaned(source)) {
                        Searcher.this.checkEntry(en.source, en.translation, en.note, null, en, -2, this.file);
                    }
                }
            });
        }
        if (this.m_searchExpression.tm && !this.expression.searchAuthor && !this.expression.searchDateAfter && !this.expression.searchDateBefore) {
            for (Map.Entry<String, ExternalTMX> entry : this.m_project.getTransMemories().entrySet()) {
                String fileTM = entry.getKey();
                if (!this.searchEntries(entry.getValue().getEntries(), fileTM)) {
                    return;
                }
                this.checkStop.checkInterrupted();
            }
            for (Map.Entry<Object, Object> entry : this.m_project.getOtherTargetLanguageTMs().entrySet()) {
                Language langTM = (Language)entry.getKey();
                if (!this.searchEntriesAlternative(((ProjectTMX)entry.getValue()).getDefaults(), langTM.getLanguage())) {
                    return;
                }
                if (!this.searchEntriesAlternative(((ProjectTMX)entry.getValue()).getAlternatives(), langTM.getLanguage())) {
                    return;
                }
                this.checkStop.checkInterrupted();
            }
        }
        if (this.m_searchExpression.glossary) {
            String intro = OStrings.getString("SW_GLOSSARY_RESULT");
            List<GlossaryEntry> list = Core.getGlossaryManager().search(this.m_searchExpression.text);
            for (GlossaryEntry en : list) {
                this.checkEntry(en.getSrcText(), en.getLocText(), null, null, null, -4, intro);
                if (this.m_numFinds >= this.expression.numberOfResults) {
                    return;
                }
                this.checkStop.checkInterrupted();
            }
        }
    }

    private String getFileForEntry(int i) {
        List<IProject.FileInfo> fileList = Core.getProject().getProjectFiles();
        for (IProject.FileInfo fi : fileList) {
            int first = fi.entries.get(0).entryNum();
            int last = fi.entries.get(fi.entries.size() - 1).entryNum();
            if (i < first || i > last) continue;
            return fi.filePath;
        }
        return null;
    }

    private boolean searchEntries(Collection<PrepareTMXEntry> tmEn, String tmxID) {
        for (PrepareTMXEntry tm : tmEn) {
            if (this.m_numFinds >= this.expression.numberOfResults) {
                return false;
            }
            this.checkEntry(tm.source, tm.translation, tm.note, null, null, -1, tmxID);
            this.checkStop.checkInterrupted();
        }
        return true;
    }

    private boolean searchEntriesAlternative(Collection<TMXEntry> tmEn, String tmxID) {
        for (TMXEntry tm : tmEn) {
            if (this.m_numFinds >= this.expression.numberOfResults) {
                return false;
            }
            this.checkEntry(tm.source, tm.translation, tm.note, null, null, -3, tmxID);
            this.checkStop.checkInterrupted();
        }
        return true;
    }

    protected void checkEntry(String srcText, String locText, String note, String comment, TMXEntry entry, int entryNum, String intro) {
        SearchMatch[] srcMatches = null;
        SearchMatch[] targetMatches = null;
        SearchMatch[] noteMatches = null;
        SearchMatch[] commentMatches = null;
        switch (this.m_searchExpression.mode) {
            case SEARCH: {
                if (locText != null ? !this.expression.searchTranslated : !this.expression.searchUntranslated) {
                    return;
                }
                if (this.expression.searchSource && this.searchString(srcText)) {
                    srcMatches = this.foundMatches.toArray(new SearchMatch[this.foundMatches.size()]);
                }
                if (this.expression.searchTarget && this.searchString(locText)) {
                    targetMatches = this.foundMatches.toArray(new SearchMatch[this.foundMatches.size()]);
                }
                if (this.expression.searchNotes && note != null && this.searchString(note)) {
                    noteMatches = this.foundMatches.toArray(new SearchMatch[this.foundMatches.size()]);
                }
                if (!this.expression.searchComments || comment == null || !this.searchString(comment)) break;
                commentMatches = this.foundMatches.toArray(new SearchMatch[this.foundMatches.size()]);
                break;
            }
            case REPLACE: {
                if (this.m_searchExpression.replaceTranslated && locText != null) {
                    if (!this.searchString(locText)) break;
                    targetMatches = this.foundMatches.toArray(new SearchMatch[this.foundMatches.size()]);
                    break;
                }
                if (!this.m_searchExpression.replaceUntranslated || locText != null || !this.searchString(srcText)) break;
                srcMatches = this.foundMatches.toArray(new SearchMatch[this.foundMatches.size()]);
            }
        }
        if (!(srcMatches == null && targetMatches == null && noteMatches == null && commentMatches == null || this.expression.searchAuthor && (entry == null || !this.searchAuthor(entry)) || this.expression.searchDateBefore && (entry == null || entry.changeDate == 0L || entry.changeDate >= this.expression.dateBefore) || this.expression.searchDateAfter && (entry == null || entry.changeDate == 0L || entry.changeDate <= this.expression.dateAfter))) {
            this.foundString(entryNum, intro, srcText, locText, note, srcMatches, targetMatches, noteMatches);
        }
    }

    private void searchFiles() throws Exception {
        if (!this.expression.rootDir.endsWith(File.separator)) {
            this.expression.rootDir = this.expression.rootDir + File.separator;
        }
        final FilterMaster fm = Core.getFilterMaster();
        final SearchCallback searchCallback = new SearchCallback(this.m_project.getProjectProperties());
        StaticUtils.iterateFileTree(new File(this.expression.rootDir), this.expression.recursive, new StaticUtils.ITreeIteratorCallback(){

            @Override
            public void processFile(File file) throws Exception {
                String filename = file.getPath();
                IProject.FileInfo fi = new IProject.FileInfo();
                fi.filePath = filename.substring(((Searcher)Searcher.this).expression.rootDir.length());
                searchCallback.setCurrentFile(fi);
                fm.loadFile(filename, new FilterContext(Searcher.this.m_project.getProjectProperties()), searchCallback);
                searchCallback.fileFinished();
                Searcher.this.checkStop.checkInterrupted();
            }
        });
    }

    public boolean searchString(String text) {
        if (text == null || this.m_matchers == null || this.m_matchers.isEmpty()) {
            return false;
        }
        this.foundMatches.clear();
        for (Matcher matcher : this.m_matchers) {
            int pos;
            matcher.reset(text);
            if (!matcher.find()) {
                return false;
            }
            do {
                this.foundMatches.add(new SearchMatch(matcher.start(), matcher.end()));
            } while ((pos = matcher.start()) < text.length() && matcher.find(pos + 1));
        }
        Collections.sort(this.foundMatches);
        int i = 1;
        while (i < this.foundMatches.size()) {
            SearchMatch pr = this.foundMatches.get(i - 1);
            SearchMatch cu = this.foundMatches.get(i);
            if (pr.getStart() <= cu.getStart() && pr.getEnd() >= cu.getStart()) {
                int end = Math.max(cu.getEnd(), pr.getEnd());
                pr = new SearchMatch(pr.getStart(), end);
                this.foundMatches.set(i - 1, pr);
                this.foundMatches.remove(i);
                continue;
            }
            ++i;
        }
        return true;
    }

    public List<SearchMatch> getFoundMatches() {
        return this.foundMatches;
    }

    private boolean searchAuthor(TMXEntry te) {
        if (te == null || this.m_author == null) {
            return false;
        }
        if (this.m_author.pattern().pattern().equals("")) {
            return te.changer == null && te.creator == null;
        }
        if (te.changer != null) {
            this.m_author.reset(te.changer);
            if (this.m_author.find()) {
                return true;
            }
        }
        if (te.creator != null) {
            this.m_author.reset(te.creator);
            if (this.m_author.find()) {
                return true;
            }
        }
        return false;
    }

    public void searchText(String seg, String translation, String filename) {
        if (this.m_numFinds >= this.expression.numberOfResults) {
            return;
        }
        this.checkStop.checkInterrupted();
        if (!this.m_searchExpression.searchTranslated && translation == null) {
            return;
        }
        if (this.searchString(seg)) {
            SearchMatch[] matches = this.foundMatches.toArray(new SearchMatch[this.foundMatches.size()]);
            this.foundString(-5, filename, seg, null, null, matches, null, null);
        }
    }

    public static interface ISearchCheckStop {
        public boolean isStopped();
    }

    protected class SearchCallback
    extends ParseEntry
    implements IParseCallback {
        private String filename;

        public SearchCallback(ProjectProperties config) {
            super(config);
        }

        @Override
        public void setCurrentFile(IProject.FileInfo fi) {
            super.setCurrentFile(fi);
            this.filename = fi.filePath;
        }

        @Override
        protected void fileFinished() {
            super.fileFinished();
        }

        @Override
        protected void addSegment(String id, short segmentIndex, String segmentSource, List<ProtectedPart> protectedParts, String segmentTranslation, boolean segmentTranslationFuzzy, String comment, String prevSegment, String nextSegment, String path) {
            Searcher.this.searchText(segmentSource, segmentTranslation, this.filename);
        }
    }
}

