/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.segmentation.datamodels;

import java.beans.ExceptionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.table.AbstractTableModel;
import org.omegat.core.segmentation.Rule;
import org.omegat.util.OStrings;

public class SegmentationRulesModel
extends AbstractTableModel {
    private List<Rule> rules;
    private static String[] COLUMN_NAMES = new String[]{OStrings.getString("CORE_SRX_TABLE_COLUMN_Break"), OStrings.getString("CORE_SRX_TABLE_COLUMN_Before_Break"), OStrings.getString("CORE_SRX_TABLE_COLUMN_After_Break")};
    protected List<ExceptionListener> listeners = new ArrayList<ExceptionListener>();

    public SegmentationRulesModel(List<Rule> rules) {
        this.rules = rules;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Rule rule = this.rules.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return rule.isBreakRule();
            }
            case 1: {
                return rule.getBeforebreak();
            }
            case 2: {
                return rule.getAfterbreak();
            }
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.rules.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Rule rule = this.rules.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                rule.setBreakRule((Boolean)aValue);
                break;
            }
            case 1: {
                try {
                    rule.setBeforebreak((String)aValue);
                }
                catch (PatternSyntaxException pse) {
                    this.fireException(pse);
                }
                break;
            }
            case 2: {
                try {
                    rule.setAfterbreak((String)aValue);
                    break;
                }
                catch (PatternSyntaxException pse) {
                    this.fireException(pse);
                }
            }
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    public int addRow() {
        int rows = this.rules.size();
        this.rules.add(new Rule(false, "\\.", "\\s"));
        this.fireTableRowsInserted(rows, rows);
        return rows;
    }

    public void removeRow(int row) {
        this.rules.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public void moveRowUp(int row) {
        Rule rulePrev = this.rules.get(row - 1);
        Rule rule = this.rules.get(row);
        this.rules.remove(row - 1);
        this.rules.add(row, rulePrev);
        this.fireTableRowsUpdated(row - 1, row);
    }

    public void moveRowDown(int row) {
        Rule ruleNext = this.rules.get(row + 1);
        Rule rule = this.rules.get(row);
        this.rules.remove(row + 1);
        this.rules.add(row, ruleNext);
        this.fireTableRowsUpdated(row, row + 1);
    }

    public void addExceptionListener(ExceptionListener l) {
        this.listeners.add(l);
    }

    public void removeTableModelListener(ExceptionListener l) {
        this.listeners.remove(l);
    }

    public void fireException(Exception e) {
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ExceptionListener l = this.listeners.get(i);
            l.exceptionThrown(e);
        }
    }
}

