/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.statistics;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.BreakIterator;
import java.text.DateFormat;
import java.util.Date;
import org.omegat.tokenizer.DefaultTokenizer;
import org.omegat.util.Log;
import org.omegat.util.PatternConsts;

public class Statistics {
    protected static final int PERCENT_EXACT_MATCH = 101;
    protected static final int PERCENT_REPETITIONS = 102;

    public static int numberOfCharactersWithoutSpaces(String str) {
        int cp;
        int chars = 0;
        for (int i = 0; i < str.length(); i += Character.charCount(cp)) {
            cp = str.codePointAt(i);
            if (cp == 8 || Character.isSpaceChar(cp)) continue;
            ++chars;
        }
        return chars;
    }

    public static int numberOfCharactersWithSpaces(String str) {
        int cp;
        int chars = 0;
        for (int i = 0; i < str.length(); i += Character.charCount(cp)) {
            cp = str.codePointAt(i);
            if (cp == 8) continue;
            ++chars;
        }
        return chars;
    }

    public static int numberOfWords(String str) {
        int len = str.length();
        if (len == 0) {
            return 0;
        }
        int nTokens = 0;
        BreakIterator breaker = DefaultTokenizer.getWordBreaker();
        breaker.setText(str);
        String tokenStr = "";
        int start = breaker.first();
        int end = breaker.next();
        while (end != -1) {
            int cp;
            tokenStr = str.substring(start, end);
            boolean word = false;
            for (int i = 0; i < tokenStr.length(); i += Character.charCount(cp)) {
                cp = tokenStr.codePointAt(i);
                if (!Character.isLetterOrDigit(cp)) continue;
                word = true;
                break;
            }
            if (word && !PatternConsts.OMEGAT_TAG.matcher(tokenStr).matches()) {
                ++nTokens;
            }
            start = end;
            end = breaker.next();
        }
        return nTokens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStat(String filename, String text) {
        try {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8");
            try {
                out.write(DateFormat.getInstance().format(new Date()) + "\n");
                out.write(text);
                out.flush();
            }
            finally {
                out.close();
            }
        }
        catch (Exception ex) {
            Log.log(ex);
        }
    }
}

