/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.tagvalidation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.tagvalidation.ErrorReport;
import org.omegat.util.PatternConsts;
import org.omegat.util.Preferences;
import org.omegat.util.TagUtil;

public class TagValidation {
    public static void inspectJavaMessageFormat(ErrorReport report) {
        Pattern pattern = PatternConsts.SIMPLE_JAVA_MESSAGEFORMAT_PATTERN_VARS;
        ArrayList<TagUtil.Tag> srcTags = new ArrayList<TagUtil.Tag>();
        ArrayList<TagUtil.Tag> locTags = new ArrayList<TagUtil.Tag>();
        Matcher javaMessageFormatMatcher = pattern.matcher(report.source);
        while (javaMessageFormatMatcher.find()) {
            srcTags.add(new TagUtil.Tag(javaMessageFormatMatcher.start(), javaMessageFormatMatcher.group(0)));
        }
        javaMessageFormatMatcher = pattern.matcher(report.translation);
        while (javaMessageFormatMatcher.find()) {
            locTags.add(new TagUtil.Tag(javaMessageFormatMatcher.start(), javaMessageFormatMatcher.group(0)));
        }
        TagValidation.inspectUnorderedTags(srcTags, locTags, report);
    }

    public static void inspectPrintfVariables(boolean simpleCheckOnly, ErrorReport report) {
        Pattern printfPattern = simpleCheckOnly ? PatternConsts.SIMPLE_PRINTF_VARS : PatternConsts.PRINTF_VARS;
        Map<String, TagUtil.Tag> srcTags = TagValidation.extractPrintfVars(printfPattern, report.source);
        Map<String, TagUtil.Tag> locTags = TagValidation.extractPrintfVars(printfPattern, report.translation);
        if (!((Object)srcTags.keySet()).equals(locTags.keySet())) {
            for (Map.Entry<String, TagUtil.Tag> e : srcTags.entrySet()) {
                report.srcErrors.put(e.getValue(), ErrorReport.TagError.UNSPECIFIED);
            }
            for (Map.Entry<String, TagUtil.Tag> e : locTags.entrySet()) {
                report.transErrors.put(e.getValue(), ErrorReport.TagError.UNSPECIFIED);
            }
        }
    }

    public static Map<String, TagUtil.Tag> extractPrintfVars(Pattern printfPattern, String translation) {
        Matcher printfMatcher = printfPattern.matcher(translation);
        HashMap<String, TagUtil.Tag> nameMapping = new HashMap<String, TagUtil.Tag>();
        int index = 1;
        while (printfMatcher.find()) {
            String normalized;
            String printfVariable = printfMatcher.group(0);
            String argumentswapspecifier = printfMatcher.group(1);
            if (argumentswapspecifier != null && argumentswapspecifier.endsWith("$")) {
                normalized = "" + argumentswapspecifier.substring(0, argumentswapspecifier.length() - 1) + printfVariable.substring(printfVariable.length() - 1, printfVariable.length());
                nameMapping.put(normalized, new TagUtil.Tag(printfMatcher.start(), printfVariable));
                continue;
            }
            normalized = "" + index + printfVariable.substring(printfVariable.length() - 1, printfVariable.length());
            nameMapping.put(normalized, new TagUtil.Tag(printfMatcher.start(), printfVariable));
            ++index;
        }
        return nameMapping;
    }

    public static void inspectPOWhitespace(ErrorReport report) {
        boolean srcStartsWith = report.source.startsWith("\n");
        boolean trgStartsWith = report.translation.startsWith("\n");
        if (srcStartsWith && !trgStartsWith) {
            report.srcErrors.put(new TagUtil.Tag(0, "\n"), ErrorReport.TagError.WHITESPACE);
        }
        if (!srcStartsWith && trgStartsWith) {
            report.transErrors.put(new TagUtil.Tag(0, "\n"), ErrorReport.TagError.WHITESPACE);
        }
        boolean srcEndsWith = report.source.endsWith("\n");
        boolean trgEndsWith = report.translation.endsWith("\n");
        if (srcEndsWith && !trgEndsWith) {
            report.srcErrors.put(new TagUtil.Tag(report.source.length() - 1, "\n"), ErrorReport.TagError.WHITESPACE);
        }
        if (!srcEndsWith && trgEndsWith) {
            report.transErrors.put(new TagUtil.Tag(report.translation.length() - 1, "\n"), ErrorReport.TagError.WHITESPACE);
        }
    }

    public static void inspectOmegaTTags(SourceTextEntry ste, ErrorReport report) {
        List<TagUtil.Tag> srcTags = TagUtil.buildTagList(report.source, ste.getProtectedParts());
        List<TagUtil.Tag> locTags = TagUtil.buildTagList(report.translation, ste.getProtectedParts());
        TagValidation.inspectOrderedTags(srcTags, locTags, Preferences.isPreference("loose_tag_ordering"), report);
    }

    public static void inspectRemovePattern(ErrorReport report) {
        Pattern removePattern = PatternConsts.getRemovePattern();
        if (removePattern == null) {
            return;
        }
        Matcher removeMatcher = removePattern.matcher(report.translation);
        while (removeMatcher.find()) {
            report.transErrors.put(new TagUtil.Tag(removeMatcher.start(), removeMatcher.group()), ErrorReport.TagError.EXTRANEOUS);
        }
    }

    protected static void inspectUnorderedTags(List<TagUtil.Tag> srcTags, List<TagUtil.Tag> locTags, ErrorReport report) {
        for (TagUtil.Tag tag : srcTags) {
            if (TagValidation.containsTag(locTags, tag.tag)) continue;
            report.srcErrors.put(tag, ErrorReport.TagError.MISSING);
        }
        for (TagUtil.Tag tag : locTags) {
            if (TagValidation.containsTag(srcTags, tag.tag)) continue;
            report.transErrors.put(tag, ErrorReport.TagError.EXTRANEOUS);
        }
    }

    protected static void inspectOrderedTags(List<TagUtil.Tag> srcTags, List<TagUtil.Tag> locTags, boolean looseOrdering, ErrorReport report) {
        if (!looseOrdering) {
            List<TagUtil.Tag> commonTagsSrc = TagValidation.getCommonTags(srcTags, locTags);
            List<TagUtil.Tag> commonTagsLoc = TagValidation.getCommonTags(locTags, srcTags);
            for (int i = 0; i < commonTagsSrc.size(); ++i) {
                TagUtil.Tag tag = commonTagsLoc.get(i);
                if (tag.tag.equals(commonTagsSrc.get((int)i).tag)) continue;
                report.transErrors.put(tag, ErrorReport.TagError.ORDER);
                commonTagsSrc.remove(i);
                commonTagsLoc.remove(i);
                --i;
            }
        }
        ArrayList<TagUtil.Tag> expectedTags = new ArrayList<TagUtil.Tag>(srcTags);
        Stack<TagUtil.Tag> tagStack = new Stack<TagUtil.Tag>();
        block5: for (TagUtil.Tag tag : locTags) {
            if (!TagValidation.containsTag(srcTags, tag.tag)) {
                report.transErrors.put(tag, ErrorReport.TagError.EXTRANEOUS);
                continue;
            }
            TagUtil.Tag expected = TagValidation.removeTag(expectedTags, tag.tag);
            if (expected == null) {
                report.transErrors.put(tag, ErrorReport.TagError.DUPLICATE);
                continue;
            }
            switch (tag.getType()) {
                case START: {
                    tagStack.push(tag);
                    break;
                }
                case END: {
                    if (!tagStack.isEmpty() && ((TagUtil.Tag)tagStack.peek()).getName().equals(tag.getName())) {
                        tagStack.pop();
                        break;
                    }
                    while (!tagStack.isEmpty()) {
                        TagUtil.Tag last = (TagUtil.Tag)tagStack.pop();
                        report.transErrors.put(last, ErrorReport.TagError.MALFORMED);
                        if (!last.getName().equals(tag.getName())) continue;
                        break;
                    }
                    if (!tagStack.isEmpty()) break;
                    String pair = tag.getPairedTag();
                    if (!TagValidation.containsTag(srcTags, pair)) continue block5;
                    report.transErrors.put(tag, TagValidation.containsTag(locTags, pair) ? ErrorReport.TagError.MALFORMED : ErrorReport.TagError.ORPHANED);
                    break;
                }
            }
        }
        for (TagUtil.Tag tag : expectedTags) {
            report.srcErrors.put(tag, ErrorReport.TagError.MISSING);
        }
        while (!tagStack.isEmpty()) {
            TagUtil.Tag tag = (TagUtil.Tag)tagStack.pop();
            String pair = tag.getPairedTag();
            if (!TagValidation.containsTag(srcTags, pair)) continue;
            report.transErrors.put(tag, TagValidation.containsTag(locTags, pair) ? ErrorReport.TagError.MALFORMED : ErrorReport.TagError.ORPHANED);
        }
    }

    private static List<TagUtil.Tag> getCommonTags(List<TagUtil.Tag> orig, List<TagUtil.Tag> compare) {
        ArrayList<TagUtil.Tag> result = new ArrayList<TagUtil.Tag>();
        ArrayList<TagUtil.Tag> uninspected = new ArrayList<TagUtil.Tag>(compare);
        block0: for (TagUtil.Tag oTag : orig) {
            for (TagUtil.Tag cTag : uninspected) {
                if (!oTag.tag.equals(cTag.tag)) continue;
                result.add(oTag);
                uninspected.remove(cTag);
                continue block0;
            }
        }
        return result;
    }

    private static boolean containsTag(List<TagUtil.Tag> tags, String tag) {
        if (tag == null) {
            return false;
        }
        for (TagUtil.Tag t : tags) {
            if (!t.tag.equals(tag)) continue;
            return true;
        }
        return false;
    }

    private static TagUtil.Tag removeTag(List<TagUtil.Tag> tags, String tag) {
        for (int i = 0; i < tags.size(); ++i) {
            TagUtil.Tag t = tags.get(i);
            if (!t.tag.equals(tag)) continue;
            tags.remove(i);
            return t;
        }
        return null;
    }
}

