/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2;

import org.omegat.core.data.ProjectProperties;
import org.omegat.util.Language;

public class FilterContext {
    private final ProjectProperties props;
    private final Language sourceLang;
    private final Language targetLang;
    private String inEncoding;
    private String outEncoding;
    private final boolean sentenceSegmentingEnabled;

    public FilterContext(ProjectProperties props) {
        this.props = props;
        this.sourceLang = props.getSourceLanguage();
        this.targetLang = props.getTargetLanguage();
        this.sentenceSegmentingEnabled = props.isSentenceSegmentingEnabled();
    }

    public FilterContext(Language sourceLang, Language targetLang, boolean sentenceSegmentingEnabled) {
        this.props = null;
        this.sourceLang = sourceLang;
        this.targetLang = targetLang;
        this.sentenceSegmentingEnabled = sentenceSegmentingEnabled;
    }

    public Language getSourceLang() {
        return this.sourceLang;
    }

    public Language getTargetLang() {
        return this.targetLang;
    }

    public String getInEncoding() {
        return this.inEncoding;
    }

    public void setInEncoding(String inEncoding) {
        this.inEncoding = inEncoding;
    }

    public String getOutEncoding() {
        return this.outEncoding;
    }

    public void setOutEncoding(String outEncoding) {
        this.outEncoding = outEncoding;
    }

    public boolean isSentenceSegmentingEnabled() {
        return this.sentenceSegmentingEnabled;
    }

    public ProjectProperties getProjectProperties() {
        return this.props;
    }
}

