/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.text.bundles;

import java.awt.Dialog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.omegat.core.data.ProtectedPart;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.Instance;
import org.omegat.filters2.TranslationException;
import org.omegat.filters2.text.bundles.ResourceBundleOptionsDialog;
import org.omegat.util.LinebreakPreservingReader;
import org.omegat.util.Log;
import org.omegat.util.NullBufferedWriter;
import org.omegat.util.OStrings;
import org.omegat.util.PatternConsts;
import org.omegat.util.StringUtil;
import org.omegat.util.TagUtil;

public class ResourceBundleFilter
extends AbstractFilter {
    public static final String DO_NOT_TRANSLATE_COMMENT = "NOI18N";
    public static final String OPTION_REMOVE_STRINGS_UNTRANSLATED = "unremoveStringsUntranslated";
    public static final String OPTION_DONT_UNESCAPE_U_LITERALS = "dontUnescapeULiterals";
    public static final String DEFAULT_TARGET_ENCODING = "US-ASCII";
    protected Map<String, String> align;
    private String targetEncoding = "US-ASCII";
    private boolean removeStringsUntranslated = false;
    private boolean dontUnescapeULiterals = false;

    @Override
    public String getFileFormatName() {
        return OStrings.getString("RBFILTER_FILTER_NAME");
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return true;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return true;
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.properties", DEFAULT_TARGET_ENCODING, DEFAULT_TARGET_ENCODING, "${nameOnly}_${targetLocale}.${extension}")};
    }

    @Override
    public BufferedWriter createWriter(File outfile, String encoding) throws UnsupportedEncodingException, IOException {
        if (encoding != null) {
            this.targetEncoding = encoding;
        }
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outfile), this.targetEncoding));
    }

    @Override
    protected String getOutputEncoding(FilterContext fc) {
        String encoding = fc.getOutEncoding();
        return encoding == null ? DEFAULT_TARGET_ENCODING : encoding;
    }

    protected String getNextLine(LinebreakPreservingReader reader) throws IOException, TranslationException {
        int cp;
        String ascii = reader.readLine();
        if (ascii == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int len = ascii.length();
        for (int i = 0; i < len; i += Character.charCount(cp)) {
            cp = ascii.codePointAt(i);
            if (cp == 92 && ascii.codePointCount(i, len) > 1) {
                if ((cp = ascii.codePointAt(i += Character.charCount(cp))) != 117) {
                    if (cp == 110) {
                        cp = 10;
                    } else if (cp == 114) {
                        cp = 13;
                    } else if (cp == 116) {
                        cp = 9;
                    } else {
                        result.append('\\');
                    }
                } else if (this.dontUnescapeULiterals) {
                    result.append('\\');
                } else {
                    if (ascii.codePointCount(i, len) < 5) {
                        throw new TranslationException(OStrings.getString("RBFH_ERROR_ILLEGAL_U_SEQUENCE"));
                    }
                    int uStart = ascii.offsetByCodePoints(i, 1);
                    int uEnd = ascii.offsetByCodePoints(uStart, 4);
                    String uStr = ascii.substring(uStart, uEnd);
                    try {
                        cp = Integer.parseInt(uStr, 16);
                        if (!Character.isValidCodePoint(cp)) {
                            throw new TranslationException(OStrings.getString("RBFH_ERROR_ILLEGAL_U_SEQUENCE"));
                        }
                        i = uEnd - Character.charCount(cp);
                    }
                    catch (NumberFormatException ex) {
                        throw new TranslationException(OStrings.getString("RBFH_ERROR_ILLEGAL_U_SEQUENCE"), ex);
                    }
                }
            }
            result.appendCodePoint(cp);
        }
        return result.toString();
    }

    private String toAscii(String text, boolean key) {
        int cp;
        CharsetEncoder charsetEncoder = Charset.forName(this.targetEncoding).newEncoder();
        StringBuilder result = new StringBuilder();
        int len = text.length();
        for (int i = 0; i < len; i += Character.charCount(cp)) {
            cp = text.codePointAt(i);
            if (cp == 92) {
                if (this.dontUnescapeULiterals && ResourceBundleFilter.containsUEscapeAt(text, i)) {
                    result.append("\\");
                    continue;
                }
                result.append("\\\\");
                continue;
            }
            if (cp == 10) {
                result.append("\\n");
                continue;
            }
            if (cp == 13) {
                result.append("\\r");
                continue;
            }
            if (cp == 9) {
                result.append("\\t");
                continue;
            }
            if (key && cp == 32) {
                result.append("\\ ");
                continue;
            }
            if (key && cp == 61) {
                result.append("\\=");
                continue;
            }
            if (key && cp == 58) {
                result.append("\\:");
                continue;
            }
            if (cp >= 32 && cp < 127 || charsetEncoder.canEncode(text.substring(i, i + Character.charCount(cp)))) {
                result.appendCodePoint(cp);
                continue;
            }
            for (char c : Character.toChars(cp)) {
                String code = Integer.toString(c, 16);
                while (code.codePointCount(0, code.length()) < 4) {
                    code = '0' + code;
                }
                result.append("\\u" + code);
            }
        }
        return result.toString();
    }

    private static boolean containsUEscapeAt(String text, int offset) {
        if (text.codePointCount(offset, text.length()) < 6) {
            return false;
        }
        if (text.codePointAt(text.offsetByCodePoints(offset, 1)) != 117) {
            return false;
        }
        int uStart = text.offsetByCodePoints(offset, 2);
        int uEnd = text.offsetByCodePoints(uStart, 4);
        String uStr = text.substring(uStart, uEnd);
        try {
            int uChr = Integer.parseInt(uStr, 16);
            return Character.isValidCodePoint(uChr);
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    private String removeExtraSlashes(String string) {
        int cp;
        StringBuilder result = new StringBuilder(string.length());
        int len = string.length();
        for (int i = 0; i < len; i += Character.charCount(cp)) {
            cp = string.codePointAt(i);
            if (!(cp != 92 || this.dontUnescapeULiterals && ResourceBundleFilter.containsUEscapeAt(string, i))) {
                if (string.codePointCount(i, len) > 1) {
                    i += Character.charCount(cp);
                    cp = string.codePointAt(i);
                } else {
                    cp = 32;
                }
            }
            result.appendCodePoint(cp);
        }
        return result.toString();
    }

    private String leftTrim(String s) {
        int i;
        int cp;
        for (i = 0; i < s.length() && ((cp = s.codePointAt(i)) == 32 || cp == 9); i += Character.charCount(cp)) {
        }
        s = s.replaceAll("\\\\ ", " ");
        return s.substring(i, s.length());
    }

    @Override
    public void processFile(BufferedReader reader, BufferedWriter outfile, FilterContext fc) throws IOException, TranslationException {
        String str;
        LinebreakPreservingReader lbpr = new LinebreakPreservingReader(reader);
        boolean noi18n = false;
        this.removeStringsUntranslated = this.processOptions != null && "true".equalsIgnoreCase((String)this.processOptions.get(OPTION_REMOVE_STRINGS_UNTRANSLATED));
        this.dontUnescapeULiterals = this.processOptions != null && "true".equalsIgnoreCase((String)this.processOptions.get(OPTION_DONT_UNESCAPE_U_LITERALS));
        String comments = null;
        while ((str = this.getNextLine(lbpr)) != null) {
            int equalsEnd;
            int cp;
            boolean translatedSegment = true;
            String trimmed = str.trim();
            if (trimmed.isEmpty()) {
                outfile.write(str + lbpr.getLinebreak());
                comments = null;
                continue;
            }
            int firstCp = trimmed.codePointAt(0);
            if (firstCp == 35 || firstCp == 33) {
                outfile.write(this.toAscii(str, false) + lbpr.getLinebreak());
                String string = comments = comments == null ? str : comments + "\n" + str;
                if (!trimmed.contains(DO_NOT_TRANSLATE_COMMENT)) continue;
                noi18n = true;
                continue;
            }
            while (str.codePointBefore(str.length()) == 92) {
                String next = this.getNextLine(lbpr);
                if (next == null) {
                    next = "";
                }
                str = str.substring(0, str.offsetByCodePoints(str.length(), -1)) + this.leftTrim(next);
            }
            int equalsPos = this.searchEquals(str);
            String key = equalsPos >= 0 ? str.substring(0, equalsPos).trim() : str.trim();
            key = this.removeExtraSlashes(key);
            if (equalsPos < 0) continue;
            for (equalsEnd = str.offsetByCodePoints(equalsPos, 1); equalsEnd < str.length() && ((cp = str.codePointAt(equalsEnd)) == 32 || cp == 9); equalsEnd += Character.charCount(cp)) {
            }
            String equals = str.substring(equalsPos, equalsEnd);
            String value = equalsEnd < str.length() ? this.removeExtraSlashes(str.substring(equalsEnd)) : "";
            if (noi18n) {
                outfile.write(this.toAscii(key, true));
                outfile.write(equals);
                outfile.write(value);
                outfile.write(lbpr.getLinebreak());
                noi18n = false;
                continue;
            }
            value = value.replaceAll("\\n\\n", "\n \n");
            String trans = this.process(key, value, comments);
            comments = null;
            if ("--untranslated_yet--".equals(trans)) {
                translatedSegment = false;
                trans = value;
            }
            trans = trans.replaceAll("\\n\\s\\n", "\n\n");
            if (!(trans = this.toAscii(trans, false)).isEmpty() && trans.codePointAt(0) == 32) {
                trans = '\\' + trans;
            }
            if (!translatedSegment && this.removeStringsUntranslated) continue;
            outfile.write(this.toAscii(key, true));
            outfile.write(equals);
            outfile.write(trans);
            outfile.write(lbpr.getLinebreak());
        }
    }

    private int searchEquals(String str) {
        int cp;
        int prevCp = 97;
        for (int i = 0; i < str.length(); i += Character.charCount(cp)) {
            cp = str.codePointAt(i);
            if (prevCp != 92) {
                if (cp == 61 || cp == 58) {
                    return i;
                }
                if (cp == 32 || cp == 9) {
                    int cp2;
                    for (int j = str.offsetByCodePoints(i, 1); j < str.length(); j += Character.charCount(cp2)) {
                        cp2 = str.codePointAt(j);
                        if (cp2 == 58 || cp2 == 61) {
                            return j;
                        }
                        if (cp2 == 32 || cp2 == 9) continue;
                        return i;
                    }
                    return i;
                }
            }
            prevCp = cp;
        }
        return -1;
    }

    protected String process(String key, String value, String c) {
        if (this.entryParseCallback != null) {
            List<ProtectedPart> protectedParts = TagUtil.applyCustomProtectedParts(value, PatternConsts.SIMPLE_JAVA_MESSAGEFORMAT_PATTERN_VARS, null);
            this.entryParseCallback.addEntry(key, value, null, false, c, null, this, protectedParts);
            return value;
        }
        if (this.entryTranslateCallback != null) {
            String trans = this.entryTranslateCallback.getTranslation(key, value, null);
            return trans != null ? trans : "--untranslated_yet--";
        }
        if (this.entryAlignCallback != null) {
            this.align.put(key, value);
        }
        return value;
    }

    @Override
    protected void alignFile(BufferedReader sourceFile, BufferedReader translatedFile, FilterContext fc) throws Exception {
        HashMap<String, String> source = new HashMap<String, String>();
        HashMap<String, String> translated = new HashMap<String, String>();
        this.align = source;
        this.processFile(sourceFile, new NullBufferedWriter(), fc);
        this.align = translated;
        this.processFile(translatedFile, new NullBufferedWriter(), fc);
        for (Map.Entry en : source.entrySet()) {
            String tr = (String)translated.get(en.getKey());
            if (StringUtil.isEmpty(tr)) continue;
            this.entryAlignCallback.addTranslation((String)en.getKey(), (String)en.getValue(), tr, false, null, this);
        }
    }

    @Override
    public Map<String, String> changeOptions(Dialog parent, Map<String, String> config) {
        try {
            ResourceBundleOptionsDialog dialog = new ResourceBundleOptionsDialog(parent, config);
            dialog.setVisible(true);
            if (1 == dialog.getReturnStatus()) {
                return dialog.getOptions();
            }
            return null;
        }
        catch (Exception e) {
            Log.log(OStrings.getString("RB_FILTER_EXCEPTION"));
            Log.log(e);
            return null;
        }
    }

    @Override
    public boolean hasOptions() {
        return true;
    }
}

