/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.omegat.core.spellchecker.DictionaryManager;
import org.omegat.util.OStrings;
import org.omegat.util.gui.DockingUI;
import org.omegat.util.gui.StaticUIUtils;
import org.openide.awt.Mnemonics;

public class DictionaryInstallerDialog
extends JDialog {
    private final DictionaryManager dicMan;
    private final DefaultListModel listModel = new DefaultListModel();
    private SwingWorker<List<String>, Object> loader = null;
    private InstallerWorker installer = null;
    private JButton closeButton;
    private JList dictionaryList;
    private JTextArea infoTextArea;
    private JButton installButton;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane2;
    private JLabel listLabel;
    private JProgressBar progressBar;

    public DictionaryInstallerDialog(JDialog parent, DictionaryManager dicMan) {
        super((Dialog)parent, true);
        StaticUIUtils.setEscapeClosable(this);
        this.dicMan = dicMan;
        this.initComponents();
        DockingUI.displayCentered(this);
        this.dictionaryListValueChanged(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                DictionaryInstallerDialog.this.loader = new LoaderWorker();
                DictionaryInstallerDialog.this.loader.execute();
            }
        });
    }

    private void initComponents() {
        this.infoTextArea = new JTextArea();
        this.jPanel1 = new JPanel();
        this.listLabel = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.dictionaryList = new JList();
        this.jPanel2 = new JPanel();
        this.installButton = new JButton();
        this.jPanel3 = new JPanel();
        this.progressBar = new JProgressBar();
        this.jPanel4 = new JPanel();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(OStrings.getString("GUI_DICTIONARY_INSTALLER_TITLE"));
        this.setPreferredSize(new Dimension(400, 500));
        this.infoTextArea.setEditable(false);
        this.infoTextArea.setFont(new JLabel().getFont());
        this.infoTextArea.setLineWrap(true);
        this.infoTextArea.setText(OStrings.getString("GUI_DICTIONARY_INSTALLER_TEXT_GO"));
        this.infoTextArea.setWrapStyleWord(true);
        this.infoTextArea.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.infoTextArea.setOpaque(false);
        this.getContentPane().add((Component)this.infoTextArea, "North");
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.jPanel1.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText(this.listLabel, OStrings.getString("GUI_DICTIONARY_INSTALLER_AVAILABLE"));
        this.jPanel1.add((Component)this.listLabel, "North");
        this.dictionaryList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                DictionaryInstallerDialog.this.dictionaryListValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.dictionaryList);
        this.jPanel1.add((Component)this.jScrollPane2, "Center");
        this.jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.jPanel2.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText(this.installButton, OStrings.getString("GUI_DICTIONARY_INSTALLER_INSTALL"));
        this.installButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DictionaryInstallerDialog.this.installButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this.installButton, "North");
        this.jPanel1.add((Component)this.jPanel2, "East");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.jPanel3.setLayout(new BorderLayout());
        this.progressBar.setIndeterminate(true);
        this.jPanel3.add((Component)this.progressBar, "Center");
        this.jPanel4.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.jPanel4.setLayout(new BoxLayout(this.jPanel4, 2));
        Mnemonics.setLocalizedText(this.closeButton, OStrings.getString("BUTTON_CLOSE"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DictionaryInstallerDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.closeButton);
        this.jPanel3.add((Component)this.jPanel4, "East");
        this.getContentPane().add((Component)this.jPanel3, "South");
        this.pack();
    }

    private void installButtonActionPerformed(ActionEvent evt) {
        if (this.installer != null) {
            this.installer.cancel(true);
        }
        this.progressBar.setVisible(true);
        this.installButton.setEnabled(false);
        this.closeButton.setEnabled(false);
        this.installer = new InstallerWorker();
        this.installer.execute();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        if (this.installer != null) {
            this.installer.cancel(true);
        }
        if (this.loader != null) {
            this.loader.cancel(true);
        }
        this.setVisible(false);
        this.dispose();
    }

    private void dictionaryListValueChanged(ListSelectionEvent evt) {
        this.installButton.setEnabled(this.dictionaryList.getSelectedValues().length > 0);
    }

    private class InstallerWorker
    extends SwingWorker<List<String>, Object> {
        private final Cursor HOURGLASS_CURSOR = new Cursor(3);
        private Cursor oldCursor;

        private InstallerWorker() {
        }

        @Override
        protected List<String> doInBackground() throws Exception {
            this.oldCursor = DictionaryInstallerDialog.this.getCursor();
            DictionaryInstallerDialog.this.setCursor(this.HOURGLASS_CURSOR);
            Object[] selection = DictionaryInstallerDialog.this.dictionaryList.getSelectedValues();
            ArrayList<String> completed = new ArrayList<String>();
            for (Object o : selection) {
                String item = (String)o;
                String langCode = item.substring(0, item.indexOf(" "));
                try {
                    DictionaryInstallerDialog.this.dicMan.installRemoteDictionary(langCode);
                    completed.add(item);
                    this.publish(item);
                }
                catch (Exception ex) {
                    DictionaryInstallerDialog.this.setCursor(this.oldCursor);
                    JOptionPane.showMessageDialog(DictionaryInstallerDialog.this, ex.getLocalizedMessage(), "Error", 0);
                    DictionaryInstallerDialog.this.setCursor(this.HOURGLASS_CURSOR);
                }
            }
            return completed;
        }

        @Override
        protected void process(List<Object> chunks) {
            for (Object o : chunks) {
                DictionaryInstallerDialog.this.listModel.removeElement(o);
            }
        }

        @Override
        protected void done() {
            try {
                for (String o : (List)this.get()) {
                    DictionaryInstallerDialog.this.listModel.removeElement(o);
                }
            }
            catch (InterruptedException e) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
            DictionaryInstallerDialog.this.setCursor(this.oldCursor);
            DictionaryInstallerDialog.this.progressBar.setVisible(false);
            DictionaryInstallerDialog.this.installButton.setEnabled(true);
            DictionaryInstallerDialog.this.closeButton.setEnabled(true);
        }
    }

    private class LoaderWorker
    extends SwingWorker<List<String>, Object> {
        private LoaderWorker() {
        }

        @Override
        protected List<String> doInBackground() throws Exception {
            DictionaryInstallerDialog.this.progressBar.setVisible(true);
            return DictionaryInstallerDialog.this.dicMan.getInstallableDictionaryNameList();
        }

        @Override
        protected void done() {
            try {
                List list = (List)this.get();
                for (String str : list) {
                    DictionaryInstallerDialog.this.listModel.addElement(str);
                }
                DictionaryInstallerDialog.this.dictionaryList.setModel(DictionaryInstallerDialog.this.listModel);
                DictionaryInstallerDialog.this.dictionaryList.setEnabled(true);
                if (list.isEmpty()) {
                    DictionaryInstallerDialog.this.installButton.setEnabled(false);
                    DictionaryInstallerDialog.this.infoTextArea.setText(OStrings.getString("GUI_DICTIONARY_INSTALLER_TEXT_NOTHING"));
                }
                DictionaryInstallerDialog.this.progressBar.setVisible(false);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DictionaryInstallerDialog.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DictionaryInstallerDialog.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

