/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.omegat.core.matching.NearString;
import org.omegat.gui.matches.MatchesVarExpansion;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.gui.DelegatingComboBoxRenderer;
import org.omegat.util.gui.DockingUI;
import org.omegat.util.gui.StaticUIUtils;
import org.openide.awt.Mnemonics;

public class ExternalTMXMatchesDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private JButton cancelButton;
    private JCheckBox displayLevel2Tags;
    private JButton insertButton;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JScrollPane jScrollPane1;
    private JTextArea matchesTemplate;
    private JButton okButton;
    private JLabel sortMatchesLabel;
    private JComboBox sortMatchesList;
    private JLabel tagHandlingLabel;
    private JLabel templateLabel;
    private JCheckBox useSlash;
    private JLabel variablesLabel;
    private JComboBox variablesList;
    private int returnStatus = 0;

    public ExternalTMXMatchesDialog(Frame parent) {
        super(parent, true);
        StaticUIUtils.setEscapeClosable(this);
        this.initComponents();
        this.sortMatchesList.setModel(new DefaultComboBoxModel<NearString.SORT_KEY>(new NearString.SORT_KEY[]{NearString.SORT_KEY.SCORE, NearString.SORT_KEY.SCORE_NO_STEM, NearString.SORT_KEY.ADJUSTED_SCORE}));
        this.sortMatchesList.setRenderer(new DelegatingComboBoxRenderer<NearString.SORT_KEY>(){

            @Override
            protected Object getDisplayText(NearString.SORT_KEY value) {
                return OStrings.getString("EXT_TMX_SORT_KEY_" + value.toString());
            }
        });
        this.getRootPane().setDefaultButton(this.okButton);
        this.sortMatchesList.setSelectedItem((Object)Preferences.getPreferenceEnumDefault("ext_tmx_sort_key", NearString.SORT_KEY.SCORE));
        this.displayLevel2Tags.setSelected(Preferences.isPreference("ext_tmx_show_level2"));
        this.useSlash.setSelected(Preferences.isPreference("ext_tmx_use_slash"));
        this.matchesTemplate.setText(Preferences.getPreferenceDefault("ext_tmx_match_template", "${id}. ${fuzzyFlag}${sourceText}\n${targetText}\n<${score}/${noStemScore}/${adjustedScore}% ${filePath}>"));
        this.matchesTemplate.setCaretPosition(0);
        this.invalidate();
        this.pack();
        DockingUI.displayCentered(this);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.sortMatchesLabel = new JLabel();
        this.sortMatchesList = new JComboBox();
        this.jPanel7 = new JPanel();
        this.tagHandlingLabel = new JLabel();
        this.displayLevel2Tags = new JCheckBox();
        this.useSlash = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.templateLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.matchesTemplate = new JTextArea();
        this.jPanel4 = new JPanel();
        this.variablesLabel = new JLabel();
        this.variablesList = new JComboBox();
        this.insertButton = new JButton();
        this.jPanel5 = new JPanel();
        this.jPanel6 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setTitle(OStrings.getString("EXT_TMX_TITLE"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ExternalTMXMatchesDialog.this.closeDialog(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 2));
        Mnemonics.setLocalizedText(this.sortMatchesLabel, OStrings.getString("EXT_TMX_SORT_KEY"));
        this.jPanel1.add(this.sortMatchesLabel);
        this.jPanel1.add(this.sortMatchesList);
        this.jPanel2.add((Component)this.jPanel1, "North");
        this.jPanel7.setLayout(new BoxLayout(this.jPanel7, 1));
        Mnemonics.setLocalizedText(this.tagHandlingLabel, OStrings.getString("EXT_TMX_DESCRIPTION"));
        this.jPanel7.add(this.tagHandlingLabel);
        this.displayLevel2Tags.setSelected(true);
        Mnemonics.setLocalizedText(this.displayLevel2Tags, OStrings.getString("EXT_TMX_SHOW_LEVEL2"));
        this.jPanel7.add(this.displayLevel2Tags);
        this.useSlash.setSelected(true);
        Mnemonics.setLocalizedText(this.useSlash, OStrings.getString("EXT_TMX_USE_XML"));
        this.jPanel7.add(this.useSlash);
        this.jPanel2.add((Component)this.jPanel7, "Last");
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.jPanel3.setLayout(new BorderLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/omegat/Bundle");
        Mnemonics.setLocalizedText(this.templateLabel, bundle.getString("EXT_TMX_MATCHES_TEMPLATE"));
        this.jPanel3.add((Component)this.templateLabel, "North");
        this.jScrollPane1.setCursor(new Cursor(0));
        this.jScrollPane1.setMinimumSize(new Dimension(525, 25));
        this.jScrollPane1.setPreferredSize(new Dimension(446, 96));
        this.matchesTemplate.setColumns(30);
        this.matchesTemplate.setRows(5);
        this.jScrollPane1.setViewportView(this.matchesTemplate);
        this.jPanel3.add((Component)this.jScrollPane1, "Center");
        this.jPanel4.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText(this.variablesLabel, bundle.getString("EXT_TMX_MATCHES_TEMPLATE_VARIABLES"));
        this.jPanel4.add((Component)this.variablesLabel, "West");
        this.variablesList.setModel(new DefaultComboBoxModel<String>(MatchesVarExpansion.MATCHES_VARIABLES));
        this.jPanel4.add((Component)this.variablesList, "Center");
        Mnemonics.setLocalizedText(this.insertButton, bundle.getString("BUTTON_INSERT"));
        this.insertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExternalTMXMatchesDialog.this.insertButtonActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.insertButton, "East");
        this.jPanel3.add((Component)this.jPanel4, "Last");
        this.getContentPane().add((Component)this.jPanel3, "Center");
        this.jPanel5.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.jPanel5.setLayout(new BorderLayout());
        this.jPanel6.setLayout(new BoxLayout(this.jPanel6, 2));
        Mnemonics.setLocalizedText(this.okButton, OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExternalTMXMatchesDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.okButton);
        Mnemonics.setLocalizedText(this.cancelButton, OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExternalTMXMatchesDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.cancelButton);
        this.jPanel5.add((Component)this.jPanel6, "East");
        this.getContentPane().add((Component)this.jPanel5, "South");
    }

    private void insertButtonActionPerformed(ActionEvent evt) {
        this.matchesTemplate.replaceSelection(this.variablesList.getSelectedItem().toString());
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        Preferences.setPreference("ext_tmx_sort_key", (NearString.SORT_KEY)((Object)this.sortMatchesList.getSelectedItem()));
        Preferences.setPreference("ext_tmx_show_level2", this.displayLevel2Tags.isSelected());
        Preferences.setPreference("ext_tmx_use_slash", this.useSlash.isSelected());
        Preferences.setPreference("ext_tmx_match_template", this.matchesTemplate.getText());
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }
}

