/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dictionaries;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTMLDocument;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.IProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.dictionaries.DictionariesManager;
import org.omegat.core.dictionaries.DictionaryEntry;
import org.omegat.core.events.IEditorEventListener;
import org.omegat.core.events.IFontChangedEventListener;
import org.omegat.gui.common.EntryInfoSearchThread;
import org.omegat.gui.common.EntryInfoThreadPane;
import org.omegat.gui.dictionaries.IDictionaries;
import org.omegat.gui.main.DockableScrollPane;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.AlwaysVisibleCaret;
import org.omegat.util.gui.Styles;
import org.omegat.util.gui.UIThreadsUtil;

public class DictionariesTextArea
extends EntryInfoThreadPane<List<DictionaryEntry>>
implements IDictionaries {
    private static final String EXPLANATION = OStrings.getString("GUI_DICTIONARYWINDOW_explanation");
    protected final DictionariesManager manager = new DictionariesManager(this);
    protected final List<String> displayedWords = new ArrayList<String>();
    protected ITokenizer tokenizer;
    protected final MouseAdapter mouseCallback = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger() || e.getButton() == 3) {
                UIThreadsUtil.mustBeSwingThread();
                JPopupMenu popup = new JPopupMenu();
                int mousepos = DictionariesTextArea.this.viewToModel(e.getPoint());
                HTMLDocument doc = (HTMLDocument)DictionariesTextArea.this.getDocument();
                for (int i = 0; i < DictionariesTextArea.this.displayedWords.size(); ++i) {
                    Element el = doc.getElement(Integer.toString(i));
                    if (el == null || el.getStartOffset() > mousepos || el.getEndOffset() < mousepos) continue;
                    final String w = DictionariesTextArea.this.displayedWords.get(i);
                    String hideW = StringUtil.format(OStrings.getString("DICTIONARY_HIDE"), w);
                    JMenuItem item = popup.add(hideW);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DictionariesTextArea.this.manager.addIgnoreWord(w);
                        }
                    });
                }
                popup.show(DictionariesTextArea.this, e.getX(), e.getY());
            }
        }
    };

    public DictionariesTextArea() {
        super(true);
        this.setContentType("text/html");
        ((HTMLDocument)this.getDocument()).setPreservesUnknownTags(false);
        String title = OStrings.getString("GUI_MATCHWINDOW_SUBWINDOWTITLE_Dictionary");
        Core.getMainWindow().addDockable(new DockableScrollPane("DICTIONARY", title, this, true));
        this.addMouseListener(this.mouseCallback);
        this.setEditable(false);
        AlwaysVisibleCaret.apply(this);
        this.setText(EXPLANATION);
        this.applyFont();
        this.setMinimumSize(new Dimension(100, 50));
        CoreEvents.registerEditorEventListener(new IEditorEventListener(){

            @Override
            public void onNewWord(String newWord) {
                DictionariesTextArea.this.callDictionary(newWord);
            }
        });
        CoreEvents.registerFontChangedEventListener(new IFontChangedEventListener(){

            @Override
            public void onFontChanged(Font newFont) {
                DictionariesTextArea.this.applyFont(newFont);
            }
        });
    }

    private void applyFont() {
        this.applyFont(Core.getMainWindow().getApplicationFont());
    }

    private void applyFont(Font font) {
        SimpleAttributeSet attr = new SimpleAttributeSet();
        HTMLDocument doc = (HTMLDocument)this.getDocument();
        doc.getStyleSheet().addCSSAttribute(attr, CSS.Attribute.BACKGROUND_COLOR, Styles.EditorColor.COLOR_BACKGROUND.toHex());
        doc.getStyleSheet().addCSSAttribute(attr, CSS.Attribute.COLOR, Styles.EditorColor.COLOR_FOREGROUND.toHex());
        doc.getStyleSheet().addCSSAttribute(attr, CSS.Attribute.FONT_FAMILY, font.getFontName());
        doc.getStyleSheet().addCSSAttribute(attr, CSS.Attribute.FONT_SIZE, font.getSize() + "pt");
        doc.setCharacterAttributes(0, doc.getLength(), attr, false);
    }

    @Override
    protected void onProjectOpen() {
        this.clear();
        IProject project = Core.getProject();
        this.tokenizer = project.getSourceTokenizer();
        this.manager.start(project.getProjectProperties().getDictRoot());
    }

    @Override
    protected void onProjectClose() {
        this.clear();
        this.setText(EXPLANATION);
        this.applyFont();
        this.manager.stop();
        this.tokenizer = null;
    }

    protected void clear() {
        UIThreadsUtil.mustBeSwingThread();
        this.setText("");
    }

    protected void callDictionary(String word) {
        Element el;
        UIThreadsUtil.mustBeSwingThread();
        HTMLDocument doc = (HTMLDocument)this.getDocument();
        int i = this.displayedWords.indexOf(word.toLowerCase());
        if (i >= 0 && (el = doc.getElement(Integer.toString(i))) != null) {
            try {
                Rectangle rect = this.getUI().modelToView(this, el.getStartOffset());
                if (rect != null) {
                    rect.height *= 2;
                    this.scrollRectToVisible(rect);
                }
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
        }
    }

    @Override
    protected void startSearchThread(SourceTextEntry newEntry) {
        new DictionaryEntriesSearchThread(newEntry).start();
    }

    @Override
    public void refresh() {
        SourceTextEntry ste = Core.getEditor().getCurrentEntry();
        if (ste != null) {
            this.startSearchThread(ste);
        }
    }

    @Override
    protected void setFoundResult(SourceTextEntry se, List<DictionaryEntry> data) {
        UIThreadsUtil.mustBeSwingThread();
        this.displayedWords.clear();
        if (data == null) {
            this.setText("");
            return;
        }
        StringBuilder txt = new StringBuilder();
        boolean wasPrev = false;
        int i = 0;
        for (DictionaryEntry de : data) {
            if (wasPrev) {
                txt.append("<br><hr>");
            } else {
                wasPrev = true;
            }
            txt.append("<b><span id=\"" + i + "\">");
            txt.append(de.getWord());
            txt.append("</span></b>");
            txt.append(" - ").append(de.getArticle());
            this.displayedWords.add(de.getWord().toLowerCase());
            ++i;
        }
        this.setText(txt.toString());
        this.applyFont();
        this.setCaretPosition(0);
    }

    public class DictionaryEntriesSearchThread
    extends EntryInfoSearchThread<List<DictionaryEntry>> {
        protected final String src;
        protected final ITokenizer tok;

        public DictionaryEntriesSearchThread(SourceTextEntry newEntry) {
            super(DictionariesTextArea.this, newEntry);
            this.src = newEntry.getSrcText();
            this.tok = DictionariesTextArea.this.tokenizer;
        }

        @Override
        protected List<DictionaryEntry> search() {
            if (this.tok == null) {
                return null;
            }
            ITokenizer.StemmingMode mode = Preferences.isPreferenceDefault("dictionary_fuzzy_matching", true) ? ITokenizer.StemmingMode.MATCHING : ITokenizer.StemmingMode.NONE;
            String[] tokenList = this.tok.tokenizeWordsToStrings(this.src, mode);
            TreeSet<String> words = new TreeSet<String>();
            for (String tok : tokenList) {
                this.checkEntryChanged();
                words.add(tok);
            }
            List<DictionaryEntry> result = DictionariesTextArea.this.manager.findWords(words);
            Collections.sort(result, new Comparator<DictionaryEntry>(){

                @Override
                public int compare(DictionaryEntry o1, DictionaryEntry o2) {
                    return o1.getWord().compareTo(o2.getWord());
                }
            });
            return result;
        }
    }
}

