/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.AttributeSet;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.omegat.core.Core;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.StringEntry;
import org.omegat.gui.common.EntryInfoThreadPane;
import org.omegat.gui.dialogs.CreateGlossaryEntry;
import org.omegat.gui.editor.EditorUtils;
import org.omegat.gui.glossary.FindGlossaryThread;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.gui.glossary.GlossaryReaderTSV;
import org.omegat.gui.glossary.TransTipsMarker;
import org.omegat.gui.glossary.TransTipsPopup;
import org.omegat.gui.main.DockableScrollPane;
import org.omegat.gui.main.MainWindow;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.AlwaysVisibleCaret;
import org.omegat.util.gui.DragTargetOverlay;
import org.omegat.util.gui.JTextPaneLinkifier;
import org.omegat.util.gui.Styles;
import org.omegat.util.gui.UIThreadsUtil;

public class GlossaryTextArea
extends EntryInfoThreadPane<List<GlossaryEntry>> {
    private static final String EXPLANATION = OStrings.getString("GUI_GLOSSARYWINDOW_explanation");
    private static final AttributeSet NO_ATTRIBUTES = Styles.createAttributeSet(null, null, false, null);
    private static final AttributeSet PRIORITY_ATTRIBUTES = Styles.createAttributeSet(null, null, true, null);
    protected StringEntry processedEntry;
    protected static List<GlossaryEntry> nowEntries;
    protected JPopupMenu popup;
    private CreateGlossaryEntry createGlossaryEntryDialog;
    protected MouseListener mouseListener = new PopupListener(this);

    public GlossaryTextArea(MainWindow mw) {
        super(true);
        String title = OStrings.getString("GUI_MATCHWINDOW_SUBWINDOWTITLE_Glossary");
        final DockableScrollPane scrollPane = new DockableScrollPane("GLOSSARY", title, this, true);
        Core.getMainWindow().addDockable(scrollPane);
        this.setEditable(false);
        AlwaysVisibleCaret.apply(this);
        this.setText(EXPLANATION);
        this.setMinimumSize(new Dimension(100, 50));
        this.popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(OStrings.getString("GUI_GLOSSARYWINDOW_addentry"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Core.getGlossary().showCreateGlossaryEntryDialog();
            }
        });
        this.popup.add(menuItem);
        this.addMouseListener(this.mouseListener);
        Core.getEditor().registerPopupMenuConstructors(300, new TransTipsPopup());
        if (!GraphicsEnvironment.isHeadless()) {
            DragTargetOverlay.apply(this, new DragTargetOverlay.FileDropInfo(mw, false){

                @Override
                public boolean canAcceptDrop() {
                    return Core.getProject().isProjectLoaded();
                }

                @Override
                public String getOverlayMessage() {
                    return OStrings.getString("DND_ADD_GLOSSARY_FILE");
                }

                @Override
                public String getImportDestination() {
                    return Core.getProject().getProjectProperties().getGlossaryRoot();
                }

                @Override
                public boolean acceptFile(File pathname) {
                    String name = pathname.getName().toLowerCase();
                    return name.endsWith(".csv") || name.endsWith(".tbx") || name.endsWith(".tab") || name.endsWith(".txt") || name.endsWith(".utf8");
                }

                @Override
                public Component getComponentToOverlay() {
                    return scrollPane;
                }
            });
        }
        JTextPaneLinkifier.linkify(this);
    }

    @Override
    protected void onProjectOpen() {
        this.clear();
        Core.getGlossaryManager().start();
    }

    @Override
    protected void onProjectClose() {
        this.clear();
        this.setText(EXPLANATION);
        Core.getGlossaryManager().stop();
    }

    @Override
    protected void startSearchThread(SourceTextEntry newEntry) {
        new FindGlossaryThread(this, newEntry, Core.getGlossaryManager()).start();
    }

    public void refresh() {
        SourceTextEntry ste = Core.getEditor().getCurrentEntry();
        if (ste != null) {
            this.startSearchThread(ste);
        }
    }

    @Override
    public void onEntryActivated(SourceTextEntry newEntry) {
        this.setText("");
        super.onEntryActivated(newEntry);
    }

    @Override
    protected void setFoundResult(SourceTextEntry en, List<GlossaryEntry> entries) {
        UIThreadsUtil.mustBeSwingThread();
        if (entries == null) {
            this.clear();
            return;
        }
        nowEntries = entries;
        if (Preferences.isPreference("transtips")) {
            Core.getEditor().remarkOneMarker(TransTipsMarker.class.getName());
        }
        GlossaryEntry.StyledString buf = new GlossaryEntry.StyledString();
        for (GlossaryEntry entry : entries) {
            GlossaryEntry.StyledString str = entry.toStyledString();
            buf.append(str);
            buf.append("\n\n");
        }
        this.setText(buf.text.toString());
        this.setCaretPosition(0);
        StyledDocument doc = this.getStyledDocument();
        doc.setCharacterAttributes(0, doc.getLength(), NO_ATTRIBUTES, true);
        for (int i = 0; i < buf.boldStarts.size(); ++i) {
            doc.setCharacterAttributes(buf.boldStarts.get(i), buf.boldLengths.get(i), PRIORITY_ATTRIBUTES, true);
        }
    }

    public void clear() {
        nowEntries = Collections.emptyList();
        this.setText("");
    }

    List<GlossaryEntry> getDisplayedEntries() {
        return nowEntries;
    }

    private void insertTerm(String selTxt) {
        Core.getEditor().insertText(selTxt);
    }

    public void showCreateGlossaryEntryDialog() {
        JFrame parent = Core.getMainWindow().getApplicationFrame();
        this.showCreateGlossaryEntryDialog(parent);
    }

    public void showCreateGlossaryEntryDialog(final Frame parent) {
        CreateGlossaryEntry d = this.createGlossaryEntryDialog;
        if (d != null) {
            d.requestFocus();
            return;
        }
        ProjectProperties props = Core.getProject().getProjectProperties();
        final File out = new File(props.getWriteableGlossary());
        final CreateGlossaryEntry dialog = new CreateGlossaryEntry(parent);
        String txt = dialog.getGlossaryFileText().getText();
        txt = MessageFormat.format(txt, out.getAbsolutePath());
        dialog.getGlossaryFileText().setText(txt);
        dialog.setVisible(true);
        dialog.getSourceText().requestFocus();
        dialog.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent e) {
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
                String sel = null;
                Component component = parent.getMostRecentFocusOwner();
                if (component instanceof JTextComponent && !StringUtil.isEmpty(sel = ((JTextComponent)component).getSelectedText())) {
                    sel = EditorUtils.removeDirectionChars(sel);
                }
                if (!StringUtil.isEmpty(sel)) {
                    if (StringUtil.isEmpty(dialog.getSourceText().getText())) {
                        this.setText(dialog.getSourceText(), sel);
                    } else if (StringUtil.isEmpty(dialog.getTargetText().getText())) {
                        this.setText(dialog.getTargetText(), sel);
                    } else if (StringUtil.isEmpty(dialog.getCommentText().getText())) {
                        this.setText(dialog.getCommentText(), sel);
                    }
                }
            }

            private void setText(JTextComponent comp, String text) {
                comp.setText(text);
                comp.requestFocus();
                comp.selectAll();
            }
        });
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                GlossaryTextArea.this.createGlossaryEntryDialog = null;
                if (dialog.getReturnStatus() == 1) {
                    String src = dialog.getSourceText().getText();
                    String loc = dialog.getTargetText().getText();
                    String com = dialog.getCommentText().getText();
                    if (!StringUtil.isEmpty(src) && !StringUtil.isEmpty(loc)) {
                        try {
                            GlossaryReaderTSV.append(out, new GlossaryEntry(src, loc, com, true));
                        }
                        catch (Exception ex) {
                            Log.log(ex);
                        }
                    }
                }
            }
        });
        this.createGlossaryEntryDialog = dialog;
    }

    class PopupListener
    extends MouseAdapter {
        private GlossaryTextArea glossaryTextArea;

        public PopupListener(GlossaryTextArea gte) {
            this.glossaryTextArea = gte;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger() || e.getButton() == 3) {
                String selTxt = this.glossaryTextArea.getSelectedText();
                if (selTxt == null) {
                    if (Core.getProject().isProjectLoaded()) {
                        GlossaryTextArea.this.popup.show(this.glossaryTextArea, e.getX(), e.getY());
                    }
                } else {
                    GlossaryTextArea.this.insertTerm(selTxt);
                }
            }
        }
    }
}

